# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-09-02 22:46
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0016_auto_20170830_1159'),
    ]

    operations = [
        migrations.CreateModel(
            name='InstructorAvailabilitySlot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('startTime', models.DateTimeField(verbose_name='Start time')),
                ('duration', models.PositiveSmallIntegerField(default=30, verbose_name='Slot duration (minutes)')),
                ('status', models.CharField(choices=[('A', 'Available'), ('B', 'Booked'), ('T', 'Tentative Booking'), ('U', 'Unavailable')], default='A', max_length=1)),
                ('creationDate', models.DateTimeField(auto_now_add=True)),
                ('modifiedDate', models.DateTimeField(auto_now=True)),
                ('eventRegistration', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='privateLessonSlots', to='core.EventRegistration', verbose_name='Final event registration')),
                ('instructor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Instructor', verbose_name='Instructor')),
            ],
            options={'ordering': ('-startTime', 'instructor__lastName', 'instructor__firstName'), 'permissions': (('edit_own_availability', "Can edit one's own private lesson availability."), ('edit_others_availability', "Can edit other instructors' private lesson availability.")), 'verbose_name': 'Private lesson availability slot', 'verbose_name_plural': 'Private lesson availability slots'},
        ),
        migrations.CreateModel(
            name='InstructorPrivateLessonDetails',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('couples', models.BooleanField(default=True, verbose_name='Private lessons for couples')),
                ('smallGroups', models.BooleanField(default=True, verbose_name='Private lessons for small groups')),
                ('defaultPricingTier', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.PricingTier', verbose_name='Default Pricing Tier')),
                ('instructor', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='core.Instructor')),
                ('roles', models.ManyToManyField(blank=True, to='core.DanceRole')),
            ],
            options={'ordering': ('instructor__lastName', 'instructor__firstName'), 'verbose_name': 'Instructor private lesson details', 'verbose_name_plural': "Instructors' private lesson details"},
        ),
        migrations.CreateModel(
            name='PrivateLessonEvent',
            fields=[
                ('event_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='core.Event')),
                ('participants', models.PositiveSmallIntegerField(blank=True, default=1, null=True, verbose_name='Expected # of Participants')),
                ('comments', models.TextField(blank=True, help_text='For internal use and recordkeeping.', null=True, verbose_name='Comments/Notes')),
                ('pricingTier', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.PricingTier', verbose_name='Pricing Tier')),
            ],
            options={'abstract': False, 'verbose_name': 'Private lesson', 'verbose_name_plural': 'Private lessons', 'permissions': (('view_others_lessons', 'Can view scheduled private lessons for all instructors'),),},
            bases=('core.event',),
        ),
        migrations.CreateModel(
            name='PrivateLessonCustomer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Customer', verbose_name='Customer')),
                ('lesson', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='private_lessons.PrivateLessonEvent', verbose_name='Lesson')),
            ],
            options={
                'verbose_name': 'Private lesson customer',
                'verbose_name_plural': 'Private lesson customers',
            },
        ),
        migrations.AddField(
            model_name='instructoravailabilityslot',
            name='lessonEvent',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='private_lessons.PrivateLessonEvent', verbose_name='Scheduled lesson'),
        ),
        migrations.AddField(
            model_name='instructoravailabilityslot',
            name='location',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.Location', verbose_name='Location'),
        ),
        migrations.AddField(
            model_name='instructoravailabilityslot',
            name='pricingTier',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='core.PricingTier', verbose_name='Pricing Tier'),
        ),
        migrations.AddField(
            model_name='instructoravailabilityslot',
            name='temporaryEventRegistration',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='privateLessonSlots', to='core.TemporaryEventRegistration', verbose_name='Temporary event registration'),
        ),
        migrations.AlterUniqueTogether(
            name='privatelessoncustomer',
            unique_together=set([('customer', 'lesson')]),
        ),
    ]
