# -*- coding: utf-8 -*-
# Generated by Django 1.10.6 on 2017-04-25 00:10
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ClassVoucher',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('classDescription', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.ClassDescription', verbose_name='Class Type (Description)')),
            ],
        ),
        migrations.CreateModel(
            name='CustomerVoucher',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('customer', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Customer')),
            ],
        ),
        migrations.CreateModel(
            name='DanceTypeVoucher',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('danceTypeLevel', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.DanceTypeLevel', verbose_name='Dance Type/Level')),
            ],
        ),
        migrations.CreateModel(
            name='TemporaryVoucherUse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.FloatField(validators=[django.core.validators.MinValueValidator(0)])),
                ('creationDate', models.DateTimeField(auto_now_add=True, null=True)),
                ('registration', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.TemporaryRegistration')),
            ],
        ),
        migrations.CreateModel(
            name='Voucher',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('voucherId', models.CharField(max_length=100, unique=True, verbose_name='Voucher Code')),
                ('name', models.CharField(max_length=80)),
                ('type', models.CharField(blank=True, max_length=200, null=True, verbose_name='Description')),
                ('originalAmount', models.FloatField(help_text='Enter the original amount of the voucher here.', validators=[django.core.validators.MinValueValidator(0)], verbose_name='Original Amount')),
                ('refundAmount', models.FloatField(default=0, help_text='When a refund is processed through Paypal, this should automatically update.  Otherwise it should not need to be changed.', verbose_name='Refunded Amount')),
                ('maxAmountPerUse', models.FloatField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(0)], verbose_name='Max. Amount Per Use')),
                ('singleUse', models.BooleanField(default=True, verbose_name='Single Use')),
                ('forFirstTimeCustomersOnly', models.BooleanField(default=False, verbose_name='For First-Time Customers Only')),
                ('forPreviousCustomersOnly', models.BooleanField(default=False, verbose_name='For Previous Customers Only')),
                ('creationDate', models.DateTimeField(auto_now_add=True)),
                ('expirationDate', models.DateTimeField(blank=True, null=True, verbose_name='Expiration Date')),
                ('disabled', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='VoucherCategory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=80, unique=True)),
                ('description', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name_plural': 'Voucher categories',
            },
        ),
        migrations.CreateModel(
            name='VoucherCredit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.FloatField(validators=[django.core.validators.MinValueValidator(0)])),
                ('description', models.TextField(blank=True, null=True)),
                ('creationDate', models.DateTimeField(auto_now_add=True, null=True)),
                ('voucher', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vouchers.Voucher')),
            ],
        ),
        migrations.CreateModel(
            name='VoucherReferralDiscount',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('referrerBonus', models.FloatField()),
                ('referreeVoucher', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='voucherreferralDiscountForReferree', to='vouchers.Voucher')),
                ('referrerVoucher', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='VoucherReferralDiscountForReferrer', to='vouchers.Voucher')),
            ],
        ),
        migrations.CreateModel(
            name='VoucherReferralDiscountUse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('creationDate', models.DateTimeField(auto_now_add=True, null=True)),
                ('voucherCredit', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vouchers.VoucherCredit')),
                ('voucherReferralDiscount', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vouchers.VoucherReferralDiscount')),
            ],
        ),
        migrations.CreateModel(
            name='VoucherUse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('amount', models.FloatField(validators=[django.core.validators.MinValueValidator(0)])),
                ('notes', models.CharField(blank=True, max_length=100, null=True)),
                ('creationDate', models.DateTimeField(auto_now_add=True, null=True)),
                ('registration', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='core.Registration')),
                ('voucher', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vouchers.Voucher')),
            ],
        ),
        migrations.AddField(
            model_name='voucherreferraldiscountuse',
            name='voucherUse',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vouchers.VoucherUse'),
        ),
        migrations.AddField(
            model_name='voucher',
            name='category',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='vouchers.VoucherCategory'),
        ),
        migrations.AddField(
            model_name='temporaryvoucheruse',
            name='voucher',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vouchers.Voucher'),
        ),
        migrations.AddField(
            model_name='dancetypevoucher',
            name='voucher',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vouchers.Voucher'),
        ),
        migrations.AddField(
            model_name='customervoucher',
            name='voucher',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vouchers.Voucher'),
        ),
        migrations.AddField(
            model_name='classvoucher',
            name='voucher',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vouchers.Voucher'),
        ),
    ]
