/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.StreamUtil;

public class DLBitString
extends ASN1BitString {
    public static ASN1BitString getInstance(Object obj) {
        if (obj == null || obj instanceof DLBitString) {
            return (DLBitString)obj;
        }
        if (obj instanceof DERBitString) {
            return (DERBitString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1BitString)DLBitString.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1BitString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DLBitString) {
            return DLBitString.getInstance(o);
        }
        return DLBitString.fromOctetString(((ASN1OctetString)o).getOctets());
    }

    protected DLBitString(byte data, int padBits) {
        this(DLBitString.toByteArray(data), padBits);
    }

    private static byte[] toByteArray(byte data) {
        byte[] rv = new byte[]{data};
        return rv;
    }

    public DLBitString(byte[] data, int padBits) {
        super(data, padBits);
    }

    public DLBitString(byte[] data) {
        this(data, 0);
    }

    public DLBitString(int value) {
        super(DLBitString.getBytes(value), DLBitString.getPadBits(value));
    }

    public DLBitString(ASN1Encodable obj) throws IOException {
        super(obj.toASN1Primitive().getEncoded("DER"), 0);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.data.length + 1) + this.data.length + 1;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        byte[] string = this.data;
        byte[] bytes = new byte[string.length + 1];
        bytes[0] = (byte)this.getPadBits();
        System.arraycopy(string, 0, bytes, 1, bytes.length - 1);
        out.writeEncoded(3, bytes);
    }

    static DLBitString fromOctetString(byte[] bytes) {
        if (bytes.length < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        byte padBits = bytes[0];
        byte[] data = new byte[bytes.length - 1];
        if (data.length != 0) {
            System.arraycopy(bytes, 1, data, 0, bytes.length - 1);
        }
        return new DLBitString(data, (int)padBits);
    }
}

