/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmc;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmc.OtherMsg;
import org.bouncycastle.asn1.cmc.TaggedAttribute;
import org.bouncycastle.asn1.cmc.TaggedContentInfo;
import org.bouncycastle.asn1.cmc.TaggedRequest;

public class PKIData
extends ASN1Object {
    private final TaggedAttribute[] controlSequence;
    private final TaggedRequest[] reqSequence;
    private final TaggedContentInfo[] cmsSequence;
    private final OtherMsg[] otherMsgSequence;

    public PKIData(TaggedAttribute[] controlSequence, TaggedRequest[] reqSequence, TaggedContentInfo[] cmsSequence, OtherMsg[] otherMsgSequence) {
        this.controlSequence = controlSequence;
        this.reqSequence = reqSequence;
        this.cmsSequence = cmsSequence;
        this.otherMsgSequence = otherMsgSequence;
    }

    private PKIData(ASN1Sequence seq) {
        if (seq.size() != 4) {
            throw new IllegalArgumentException("Sequence not 4 elements.");
        }
        ASN1Sequence s = (ASN1Sequence)seq.getObjectAt(0);
        this.controlSequence = new TaggedAttribute[s.size()];
        int t = 0;
        while (t < this.controlSequence.length) {
            this.controlSequence[t] = TaggedAttribute.getInstance(s.getObjectAt(t));
            ++t;
        }
        s = (ASN1Sequence)seq.getObjectAt(1);
        this.reqSequence = new TaggedRequest[s.size()];
        t = 0;
        while (t < this.reqSequence.length) {
            this.reqSequence[t] = TaggedRequest.getInstance(s.getObjectAt(t));
            ++t;
        }
        s = (ASN1Sequence)seq.getObjectAt(2);
        this.cmsSequence = new TaggedContentInfo[s.size()];
        t = 0;
        while (t < this.cmsSequence.length) {
            this.cmsSequence[t] = TaggedContentInfo.getInstance(s.getObjectAt(t));
            ++t;
        }
        s = (ASN1Sequence)seq.getObjectAt(3);
        this.otherMsgSequence = new OtherMsg[s.size()];
        t = 0;
        while (t < this.otherMsgSequence.length) {
            this.otherMsgSequence[t] = OtherMsg.getInstance(s.getObjectAt(t));
            ++t;
        }
    }

    public static PKIData getInstance(Object src) {
        if (src instanceof PKIData) {
            return (PKIData)src;
        }
        if (src != null) {
            return new PKIData(ASN1Sequence.getInstance(src));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(new ASN1Encodable[]{new DERSequence(this.controlSequence), new DERSequence(this.reqSequence), new DERSequence(this.cmsSequence), new DERSequence(this.otherMsgSequence)});
    }

    public TaggedAttribute[] getControlSequence() {
        return this.controlSequence;
    }

    public TaggedRequest[] getReqSequence() {
        return this.reqSequence;
    }

    public TaggedContentInfo[] getCmsSequence() {
        return this.cmsSequence;
    }

    public OtherMsg[] getOtherMsgSequence() {
        return this.otherMsgSequence;
    }
}

