/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.isismtt.x509.Admissions;
import org.bouncycastle.asn1.isismtt.x509.NamingAuthority;
import org.bouncycastle.asn1.isismtt.x509.ProfessionInfo;
import org.bouncycastle.asn1.test.ASN1UnitTest;
import org.bouncycastle.asn1.x500.DirectoryString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;

public class AdmissionsUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "Admissions";
    }

    @Override
    public void performTest() throws Exception {
        GeneralName name = new GeneralName(new X500Name("CN=hello world"));
        NamingAuthority auth = new NamingAuthority(new ASN1ObjectIdentifier("1.2.3"), "url", new DirectoryString("fred"));
        Admissions admissions = new Admissions(name, auth, new ProfessionInfo[0]);
        this.checkConstruction(admissions, name, auth);
        admissions = Admissions.getInstance(null);
        if (admissions != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            Admissions.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(Admissions admissions, GeneralName name, NamingAuthority auth) throws IOException {
        this.checkValues(admissions, name, auth);
        admissions = Admissions.getInstance(admissions);
        this.checkValues(admissions, name, auth);
        ASN1InputStream aIn = new ASN1InputStream(admissions.toASN1Primitive().getEncoded());
        ASN1Sequence info = (ASN1Sequence)aIn.readObject();
        admissions = Admissions.getInstance(info);
        this.checkValues(admissions, name, auth);
    }

    private void checkValues(Admissions admissions, GeneralName name, NamingAuthority auth) {
        this.checkMandatoryField("admissionAuthority", name, admissions.getAdmissionAuthority());
        this.checkMandatoryField("namingAuthority", auth, admissions.getNamingAuthority());
    }

    public static void main(String[] args) {
        AdmissionsUnitTest.runTest(new AdmissionsUnitTest());
    }
}

