/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.cmc.CMCStatus;
import org.bouncycastle.util.test.SimpleTest;

public class CMCStatusTest
extends SimpleTest {
    private static Object[][] types = new Object[][]{{"success", new Long(0L)}, {"failed", new Long(2L)}, {"pending", new Long(3L)}, {"noSupport", new Long(4L)}, {"confirmRequired", new Long(5L)}, {"popRequired", new Long(6L)}, {"partial", new Long(7L)}};
    private static Map typesMap = new HashMap();

    static {
        int t = 0;
        while (t < types.length) {
            typesMap.put(types[t][1], types[t][0]);
            ++t;
        }
    }

    public static void main(String[] args) {
        CMCStatusTest.runTest(new CMCStatusTest());
    }

    @Override
    public String getName() {
        return "CMCStatusTest";
    }

    @Override
    public void performTest() throws Exception {
        Field rangeField = CMCStatus.class.getDeclaredField("range");
        rangeField.setAccessible(true);
        Map range = (Map)rangeField.get(null);
        this.isEquals("Range in CMCStatus does not match test data.", range.size(), types.length);
        for (Object j : range.keySet()) {
            if (typesMap.containsKey(new Long(((ASN1Integer)j).getValue().longValue()))) continue;
            this.fail("The 'range' map in CMCStatus contains a value not in the test ('typesMap') map, value was: " + j.toString());
        }
        for (Object j : typesMap.keySet()) {
            if (range.containsKey(new ASN1Integer((Long)j))) continue;
            this.fail("The 'typesMap' map in CMCStatusTest contains a value not in the CMCStatus ('range') map, value was: " + j.toString());
        }
        byte[] b = CMCStatus.failed.getEncoded();
        CMCStatus r = CMCStatus.getInstance(b);
        this.isEquals(r, CMCStatus.failed);
    }
}

