/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cmc.BodyPartID;
import org.bouncycastle.asn1.cmc.BodyPartPath;
import org.bouncycastle.asn1.cmc.CMCUnsignedData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.util.test.SimpleTest;

public class CMCUnsignedDataTest
extends SimpleTest {
    public static void main(String[] args) {
        CMCUnsignedDataTest.runTest(new CMCUnsignedDataTest());
    }

    @Override
    public String getName() {
        return "CMCUnsignedDataTest";
    }

    @Override
    public void performTest() throws Exception {
        CMCUnsignedData data = new CMCUnsignedData(new BodyPartPath(new BodyPartID(10L)), PKCSObjectIdentifiers.certBag, new DEROctetString("Cats".getBytes()));
        byte[] b = data.getEncoded();
        CMCUnsignedData result = CMCUnsignedData.getInstance(data);
        this.isEquals(data.getBodyPartPath(), result.getBodyPartPath());
        this.isEquals(data.getIdentifier(), result.getIdentifier());
        this.isEquals(data.getContent(), result.getContent());
        try {
            CMCUnsignedData.getInstance(new DERSequence(new ASN1Integer(10L)));
            this.fail("Must fail, sequence must be 3");
        }
        catch (Exception ex) {
            this.isEquals(ex.getClass(), IllegalArgumentException.class);
        }
        try {
            CMCUnsignedData.getInstance(new DERSequence(new ASN1Encodable[]{new ASN1Integer(10L), new ASN1Integer(10L), new ASN1Integer(10L), new ASN1Integer(10L)}));
            this.fail("Must fail, sequence must be 3");
        }
        catch (Exception ex) {
            this.isEquals(ex.getClass(), IllegalArgumentException.class);
        }
    }
}

