/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import java.io.IOException;
import java.util.Random;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.icao.DataGroupHash;
import org.bouncycastle.util.test.SimpleTest;

public class DataGroupHashUnitTest
extends SimpleTest {
    @Override
    public String getName() {
        return "DataGroupHash";
    }

    private byte[] generateHash() {
        Random rand = new Random();
        byte[] bytes = new byte[20];
        int i = 0;
        while (i != bytes.length) {
            bytes[i] = (byte)rand.nextInt();
            ++i;
        }
        return bytes;
    }

    @Override
    public void performTest() throws Exception {
        int dataGroupNumber = 1;
        DEROctetString dataHash = new DEROctetString(this.generateHash());
        DataGroupHash dg = new DataGroupHash(dataGroupNumber, dataHash);
        this.checkConstruction(dg, dataGroupNumber, dataHash);
        try {
            DataGroupHash.getInstance(null);
        }
        catch (Exception e) {
            this.fail("getInstance() failed to handle null.");
        }
        try {
            DataGroupHash.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(DataGroupHash dg, int dataGroupNumber, ASN1OctetString dataGroupHashValue) throws IOException {
        this.checkValues(dg, dataGroupNumber, dataGroupHashValue);
        dg = DataGroupHash.getInstance(dg);
        this.checkValues(dg, dataGroupNumber, dataGroupHashValue);
        ASN1InputStream aIn = new ASN1InputStream(dg.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        dg = DataGroupHash.getInstance(seq);
        this.checkValues(dg, dataGroupNumber, dataGroupHashValue);
    }

    private void checkValues(DataGroupHash dg, int dataGroupNumber, ASN1OctetString dataGroupHashValue) {
        if (dg.getDataGroupNumber() != dataGroupNumber) {
            this.fail("group number don't match.");
        }
        if (!dg.getDataGroupHashValue().equals(dataGroupHashValue)) {
            this.fail("hash value don't match.");
        }
    }

    public static void main(String[] args) {
        DataGroupHashUnitTest.runTest(new DataGroupHashUnitTest());
    }
}

