/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.test;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.qualified.SemanticsInformation;
import org.bouncycastle.util.test.SimpleTest;

public class SemanticsInformationUnitTest
extends SimpleTest {
    @Override
    public String getName() {
        return "SemanticsInformation";
    }

    @Override
    public void performTest() throws Exception {
        ASN1ObjectIdentifier statementId = new ASN1ObjectIdentifier("1.1");
        SemanticsInformation mv = new SemanticsInformation(statementId);
        this.checkConstruction(mv, statementId, null);
        GeneralName[] names = new GeneralName[]{new GeneralName(1, "test@test.org"), new GeneralName(new X500Name("cn=test"))};
        mv = new SemanticsInformation(statementId, names);
        this.checkConstruction(mv, statementId, names);
        mv = new SemanticsInformation(names);
        this.checkConstruction(mv, null, names);
        mv = SemanticsInformation.getInstance(null);
        if (mv != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            SemanticsInformation.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            SemanticsInformation.getInstance(new DERSequence(v));
            this.fail("constructor failed to detect empty sequence.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(SemanticsInformation mv, ASN1ObjectIdentifier semanticsIdentifier, GeneralName[] names) throws Exception {
        this.checkStatement(mv, semanticsIdentifier, names);
        mv = SemanticsInformation.getInstance(mv);
        this.checkStatement(mv, semanticsIdentifier, names);
        ASN1InputStream aIn = new ASN1InputStream(mv.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        mv = SemanticsInformation.getInstance(seq);
        this.checkStatement(mv, semanticsIdentifier, names);
    }

    private void checkStatement(SemanticsInformation si, ASN1ObjectIdentifier id, GeneralName[] names) {
        if (id != null) {
            if (!si.getSemanticsIdentifier().equals(id)) {
                this.fail("ids don't match.");
            }
        } else if (si.getSemanticsIdentifier() != null) {
            this.fail("statementId found when none expected.");
        }
        if (names != null) {
            GeneralName[] siNames = si.getNameRegistrationAuthorities();
            int i = 0;
            while (i != siNames.length) {
                if (!names[i].equals(siNames[i])) {
                    this.fail("name registration authorities don't match.");
                }
                ++i;
            }
        } else if (si.getNameRegistrationAuthorities() != null) {
            this.fail("name registration authorities found when none expected.");
        }
    }

    public static void main(String[] args) {
        SemanticsInformationUnitTest.runTest(new SemanticsInformationUnitTest());
    }
}

