/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.params.KeyParameter;

public class NoekeonEngine
implements BlockCipher {
    private static final int genericSize = 16;
    private static final int[] nullVector = new int[4];
    private static final int[] roundConstants = new int[]{128, 27, 54, 108, 216, 171, 77, 154, 47, 94, 188, 99, 198, 151, 53, 106, 212};
    private int[] state = new int[4];
    private int[] subKeys = new int[4];
    private int[] decryptKeys = new int[4];
    private boolean _initialised = false;
    private boolean _forEncryption;

    @Override
    public String getAlgorithmName() {
        return "Noekeon";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public void init(boolean forEncryption, CipherParameters params) {
        if (!(params instanceof KeyParameter)) {
            throw new IllegalArgumentException("invalid parameter passed to Noekeon init - " + params.getClass().getName());
        }
        this._forEncryption = forEncryption;
        this._initialised = true;
        KeyParameter p = (KeyParameter)params;
        this.setKey(p.getKey());
    }

    @Override
    public int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (!this._initialised) {
            throw new IllegalStateException(String.valueOf(this.getAlgorithmName()) + " not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new OutputLengthException("output buffer too short");
        }
        return this._forEncryption ? this.encryptBlock(in, inOff, out, outOff) : this.decryptBlock(in, inOff, out, outOff);
    }

    @Override
    public void reset() {
    }

    private void setKey(byte[] key) {
        this.subKeys[0] = this.bytesToIntBig(key, 0);
        this.subKeys[1] = this.bytesToIntBig(key, 4);
        this.subKeys[2] = this.bytesToIntBig(key, 8);
        this.subKeys[3] = this.bytesToIntBig(key, 12);
    }

    private int encryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        this.state[0] = this.bytesToIntBig(in, inOff);
        this.state[1] = this.bytesToIntBig(in, inOff + 4);
        this.state[2] = this.bytesToIntBig(in, inOff + 8);
        this.state[3] = this.bytesToIntBig(in, inOff + 12);
        int i = 0;
        while (i < 16) {
            this.state[0] = this.state[0] ^ roundConstants[i];
            this.theta(this.state, this.subKeys);
            this.pi1(this.state);
            this.gamma(this.state);
            this.pi2(this.state);
            ++i;
        }
        this.state[0] = this.state[0] ^ roundConstants[i];
        this.theta(this.state, this.subKeys);
        this.intToBytesBig(this.state[0], out, outOff);
        this.intToBytesBig(this.state[1], out, outOff + 4);
        this.intToBytesBig(this.state[2], out, outOff + 8);
        this.intToBytesBig(this.state[3], out, outOff + 12);
        return 16;
    }

    private int decryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        this.state[0] = this.bytesToIntBig(in, inOff);
        this.state[1] = this.bytesToIntBig(in, inOff + 4);
        this.state[2] = this.bytesToIntBig(in, inOff + 8);
        this.state[3] = this.bytesToIntBig(in, inOff + 12);
        System.arraycopy(this.subKeys, 0, this.decryptKeys, 0, this.subKeys.length);
        this.theta(this.decryptKeys, nullVector);
        int i = 16;
        while (i > 0) {
            this.theta(this.state, this.decryptKeys);
            this.state[0] = this.state[0] ^ roundConstants[i];
            this.pi1(this.state);
            this.gamma(this.state);
            this.pi2(this.state);
            --i;
        }
        this.theta(this.state, this.decryptKeys);
        this.state[0] = this.state[0] ^ roundConstants[i];
        this.intToBytesBig(this.state[0], out, outOff);
        this.intToBytesBig(this.state[1], out, outOff + 4);
        this.intToBytesBig(this.state[2], out, outOff + 8);
        this.intToBytesBig(this.state[3], out, outOff + 12);
        return 16;
    }

    private void gamma(int[] a) {
        a[1] = a[1] ^ ~a[3] & ~a[2];
        a[0] = a[0] ^ a[2] & a[1];
        int tmp = a[3];
        a[3] = a[0];
        a[0] = tmp;
        a[2] = a[2] ^ (a[0] ^ a[1] ^ a[3]);
        a[1] = a[1] ^ ~a[3] & ~a[2];
        a[0] = a[0] ^ a[2] & a[1];
    }

    private void theta(int[] a, int[] k) {
        int tmp = a[0] ^ a[2];
        tmp ^= this.rotl(tmp, 8) ^ this.rotl(tmp, 24);
        a[1] = a[1] ^ tmp;
        a[3] = a[3] ^ tmp;
        int i = 0;
        while (i < 4) {
            int n = i;
            a[n] = a[n] ^ k[i];
            ++i;
        }
        tmp = a[1] ^ a[3];
        tmp ^= this.rotl(tmp, 8) ^ this.rotl(tmp, 24);
        a[0] = a[0] ^ tmp;
        a[2] = a[2] ^ tmp;
    }

    private void pi1(int[] a) {
        a[1] = this.rotl(a[1], 1);
        a[2] = this.rotl(a[2], 5);
        a[3] = this.rotl(a[3], 2);
    }

    private void pi2(int[] a) {
        a[1] = this.rotl(a[1], 31);
        a[2] = this.rotl(a[2], 27);
        a[3] = this.rotl(a[3], 30);
    }

    private int bytesToIntBig(byte[] in, int off) {
        return in[off++] << 24 | (in[off++] & 0xFF) << 16 | (in[off++] & 0xFF) << 8 | in[off] & 0xFF;
    }

    private void intToBytesBig(int x, byte[] out, int off) {
        out[off++] = (byte)(x >>> 24);
        out[off++] = (byte)(x >>> 16);
        out[off++] = (byte)(x >>> 8);
        out[off] = (byte)x;
    }

    private int rotl(int x, int y) {
        return x << y | x >>> 32 - y;
    }
}

