/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.symmetric;

import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherKeyGenerator;
import org.bouncycastle.crypto.engines.SerpentEngine;
import org.bouncycastle.crypto.engines.TnepresEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.generators.Poly1305KeyGenerator;
import org.bouncycastle.crypto.macs.GMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import org.bouncycastle.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class Serpent {
    private Serpent() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Serpent IV";
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new SerpentEngine()), 128);
        }
    }

    public static class CFB
    extends BaseBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new SerpentEngine(), 128)), 128);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new SerpentEngine();
                }
            });
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Serpent", 192, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Serpent.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.Serpent", String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("KeyGenerator.Serpent", String.valueOf(PREFIX) + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.Serpent", String.valueOf(PREFIX) + "$AlgParams");
            provider.addAlgorithm("Cipher.Tnepres", String.valueOf(PREFIX) + "$TECB");
            provider.addAlgorithm("KeyGenerator.Tnepres", String.valueOf(PREFIX) + "$TKeyGen");
            provider.addAlgorithm("AlgorithmParameters.Tnepres", String.valueOf(PREFIX) + "$TAlgParams");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_ECB, String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_ECB, String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_ECB, String.valueOf(PREFIX) + "$ECB");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_CBC, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_CBC, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_CBC, String.valueOf(PREFIX) + "$CBC");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_CFB, String.valueOf(PREFIX) + "$CFB");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_CFB, String.valueOf(PREFIX) + "$CFB");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_CFB, String.valueOf(PREFIX) + "$CFB");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_128_OFB, String.valueOf(PREFIX) + "$OFB");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_192_OFB, String.valueOf(PREFIX) + "$OFB");
            provider.addAlgorithm("Cipher", GNUObjectIdentifiers.Serpent_256_OFB, String.valueOf(PREFIX) + "$OFB");
            this.addGMacAlgorithm(provider, "SERPENT", String.valueOf(PREFIX) + "$SerpentGMAC", String.valueOf(PREFIX) + "$KeyGen");
            this.addGMacAlgorithm(provider, "TNEPRES", String.valueOf(PREFIX) + "$TSerpentGMAC", String.valueOf(PREFIX) + "$TKeyGen");
            this.addPoly1305Algorithm(provider, "SERPENT", String.valueOf(PREFIX) + "$Poly1305", String.valueOf(PREFIX) + "$Poly1305KeyGen");
        }
    }

    public static class OFB
    extends BaseBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new SerpentEngine(), 128)), 128);
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new org.bouncycastle.crypto.macs.Poly1305(new TwofishEngine()));
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-Serpent", 256, new Poly1305KeyGenerator());
        }
    }

    public static class SerpentGMAC
    extends BaseMac {
        public SerpentGMAC() {
            super(new GMac(new GCMBlockCipher(new SerpentEngine())));
        }
    }

    public static class TAlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "Tnepres IV";
        }
    }

    public static class TECB
    extends BaseBlockCipher {
        public TECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new TnepresEngine();
                }
            });
        }
    }

    public static class TKeyGen
    extends BaseKeyGenerator {
        public TKeyGen() {
            super("Tnepres", 192, new CipherKeyGenerator());
        }
    }

    public static class TSerpentGMAC
    extends BaseMac {
        public TSerpentGMAC() {
            super(new GMac(new GCMBlockCipher(new TnepresEngine())));
        }
    }
}

