/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class Shacal2Test
extends SimpleTest {
    static String[] cipherTests = new String[]{"512", "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F", "98BCC10405AB0BFC686BECECAAD01AC19B452511BCEB9CB094F905C51CA45430", "00112233445566778899AABBCCDDEEFF102132435465768798A9BACBDCEDFE0F"};
    private static final int KEY_SIZE_BITS = 512;
    private static final byte[] TEST_BYTES = new byte[1536];
    private static final char[] TEST_PASSWORD = new char[1536];

    static {
        new SecureRandom().nextBytes(TEST_BYTES);
        int total = TEST_PASSWORD.length;
        int c = 65;
        while (c <= 90 && total > 0) {
            Shacal2Test.TEST_PASSWORD[Shacal2Test.TEST_PASSWORD.length - total] = c;
            c = (char)(c + 1);
            --total;
        }
    }

    @Override
    public String getName() {
        return "Shacal2";
    }

    private void blockTest() throws Exception {
        byte[] salt = new byte[64];
        new SecureRandom().nextBytes(salt);
        PBEKeySpec keySpec = new PBEKeySpec(TEST_PASSWORD, salt, 262144, 512);
        SecretKeySpec secretKey = new SecretKeySpec(SecretKeyFactory.getInstance("PBKDF2", "BC").generateSecret(keySpec).getEncoded(), "Shacal2");
        Cipher cipher = Cipher.getInstance("Shacal2/CBC/ISO10126Padding", "BC");
        cipher.init(1, secretKey);
        byte[] iv = cipher.getIV();
        byte[] ciphertext = cipher.doFinal(TEST_BYTES);
        cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
        byte[] cleartext = cipher.doFinal(ciphertext);
        if (!Arrays.areEqual(TEST_BYTES, cleartext)) {
            this.fail("Invalid cleartext.");
        }
    }

    public void testECB(int strength, byte[] keyBytes, byte[] input, byte[] output) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "Shacal2");
        Cipher in = Cipher.getInstance("Shacal2/ECB/NoPadding", "BC");
        Cipher out = Cipher.getInstance("Shacal2/ECB/NoPadding", "BC");
        try {
            out.init(1, key);
        }
        catch (Exception e) {
            this.fail("Shacal2 failed initialisation - " + e.toString(), e);
        }
        try {
            in.init(2, key);
        }
        catch (Exception e) {
            this.fail("Shacal2 failed initialisation - " + e.toString(), e);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        try {
            int i = 0;
            while (i != input.length / 2) {
                cOut.write(input[i]);
                ++i;
            }
            cOut.write(input, input.length / 2, input.length - input.length / 2);
            cOut.close();
        }
        catch (IOException e) {
            this.fail("Shacal2 failed encryption - " + e.toString(), e);
        }
        byte[] bytes = bOut.toByteArray();
        if (!this.areEqual(bytes, output)) {
            this.fail("Shacal2 failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        try {
            DataInputStream dIn = new DataInputStream(cIn);
            bytes = new byte[input.length];
            int i = 0;
            while (i != input.length / 2) {
                bytes[i] = (byte)dIn.read();
                ++i;
            }
            dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        }
        catch (Exception e) {
            this.fail("Shacal2 failed encryption - " + e.toString(), e);
        }
        if (!this.areEqual(bytes, input)) {
            this.fail("Shacal2 failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
    }

    @Override
    public void performTest() throws Exception {
        int i = 0;
        while (i != cipherTests.length) {
            this.testECB(Integer.parseInt(cipherTests[i]), Hex.decode(cipherTests[i + 1]), Hex.decode(cipherTests[i + 2]), Hex.decode(cipherTests[i + 3]));
            i += 4;
        }
        this.blockTest();
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        Shacal2Test.runTest(new Shacal2Test());
    }
}

