/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.test;

import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.mceliece.McElieceCipher;
import org.bouncycastle.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.mceliece.McElieceKeyPairGenerator;
import org.bouncycastle.pqc.crypto.mceliece.McElieceParameters;
import org.bouncycastle.util.test.SimpleTest;

public class McElieceCipherTest
extends SimpleTest {
    SecureRandom keyRandom = new SecureRandom();

    @Override
    public String getName() {
        return "McEliecePKCS";
    }

    @Override
    public void performTest() throws InvalidCipherTextException {
        int numPassesKPG = 1;
        int numPassesEncDec = 10;
        Random rand = new Random();
        int j = 0;
        while (j < numPassesKPG) {
            McElieceParameters params = new McElieceParameters();
            McElieceKeyPairGenerator mcElieceKeyGen = new McElieceKeyPairGenerator();
            McElieceKeyGenerationParameters genParam = new McElieceKeyGenerationParameters(this.keyRandom, params);
            mcElieceKeyGen.init(genParam);
            AsymmetricCipherKeyPair pair = mcElieceKeyGen.generateKeyPair();
            ParametersWithRandom param = new ParametersWithRandom(pair.getPublic(), this.keyRandom);
            SHA256Digest msgDigest = new SHA256Digest();
            McElieceCipher mcEliecePKCSDigestCipher = new McElieceCipher();
            int k = 1;
            while (k <= numPassesEncDec) {
                System.out.println("############### test: " + k);
                mcEliecePKCSDigestCipher.init(true, param);
                int mLength = (rand.nextInt() & 0x1F) + 1;
                byte[] mBytes = new byte[mLength];
                rand.nextBytes(mBytes);
                msgDigest.update(mBytes, 0, mBytes.length);
                byte[] hash = new byte[msgDigest.getDigestSize()];
                msgDigest.doFinal(hash, 0);
                byte[] enc = mcEliecePKCSDigestCipher.messageEncrypt(hash);
                mcEliecePKCSDigestCipher.init(false, pair.getPrivate());
                byte[] constructedmessage = mcEliecePKCSDigestCipher.messageDecrypt(enc);
                boolean verified = true;
                int i = 0;
                while (i < hash.length) {
                    verified = verified && hash[i] == constructedmessage[i];
                    ++i;
                }
                if (!verified) {
                    this.fail("en/decryption fails");
                } else {
                    System.out.println("test okay");
                    System.out.println();
                }
                ++k;
            }
            ++j;
        }
    }

    public static void main(String[] args) {
        McElieceCipherTest.runTest(new McElieceCipherTest());
    }
}

