/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.test;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import org.bouncycastle.pqc.jcajce.provider.test.FlexiTest;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

public abstract class AsymmetricBlockCipherTest
extends FlexiTest {
    protected Cipher cipher;
    protected KeyPair keyPair;
    protected PublicKey pubKey;
    protected PrivateKey privKey;
    protected KeyPairGenerator kpg;
    private byte[] mBytes;
    private byte[] cBytes;
    private byte[] dBytes;

    protected final void performEnDecryptionTest(int numPassesKPG, int numPassesEncDec, AlgorithmParameterSpec params) {
        try {
            int j = 0;
            while (j < numPassesKPG) {
                this.keyPair = this.kpg.genKeyPair();
                this.pubKey = this.keyPair.getPublic();
                this.privKey = this.keyPair.getPrivate();
                int k = 1;
                while (k <= numPassesEncDec) {
                    this.cipher.init(1, (Key)this.pubKey, params, this.sr);
                    int plainTextSize = this.cipher.getBlockSize();
                    int mLength = this.rand.nextInt(plainTextSize) + 1;
                    this.mBytes = new byte[mLength];
                    this.rand.nextBytes(this.mBytes);
                    this.cBytes = this.cipher.doFinal(this.mBytes);
                    this.cipher.init(2, (Key)this.privKey, params);
                    this.dBytes = this.cipher.doFinal(this.cBytes);
                    AsymmetricBlockCipherTest.assertEquals("Encryption and Decryption test failed:\n actual decrypted text: " + ByteUtils.toHexString(this.dBytes) + "\n expected plain text: " + ByteUtils.toHexString(this.mBytes), this.mBytes, this.dBytes);
                    ++k;
                }
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AsymmetricBlockCipherTest.fail(e);
        }
    }
}

