/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.jcajce.provider.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Random;
import junit.framework.TestCase;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.spec.RainbowParameterSpec;
import org.bouncycastle.util.encoders.Hex;

public class RainbowSignatureTest
extends TestCase {
    protected KeyPairGenerator kpg;
    protected Signature sig;
    private Signature sigVerify;
    private KeyPair keyPair;
    private PublicKey pubKey;
    private PrivateKey privKey;
    private byte[] mBytes;
    private byte[] sigBytes;
    private boolean valid;
    Random rand = new Random();
    private KeyFactory kf;

    public void setUp() {
        if (Security.getProvider(BouncyCastlePQCProvider.PROVIDER_NAME) == null) {
            Security.addProvider(new BouncyCastlePQCProvider());
        }
    }

    protected final void performSignVerifyTest(int numPassesKPG, int numPassesSigVer, AlgorithmParameterSpec kpgParams) throws Exception {
        this.performSignVerifyTest(numPassesKPG, numPassesSigVer, kpgParams, 100);
    }

    protected final void performSignVerifyTest(int numPassesKPG, int numPassesSigVer, AlgorithmParameterSpec kpgParams, int messageSize) throws Exception {
        this.sigVerify = Signature.getInstance("SHA384withRainbow", "BCPQC");
        int j = 0;
        while (j < numPassesKPG) {
            if (kpgParams != null) {
                this.kpg.initialize(kpgParams);
            }
            this.keyPair = this.kpg.genKeyPair();
            this.pubKey = this.keyPair.getPublic();
            this.privKey = this.keyPair.getPrivate();
            this.sig.initSign(this.privKey);
            this.sigVerify.initVerify(this.pubKey);
            int k = 1;
            while (k <= numPassesSigVer) {
                this.mBytes = new byte[messageSize];
                this.rand.nextBytes(this.mBytes);
                this.sig.update(this.mBytes);
                this.sigBytes = this.sig.sign();
                this.sigVerify.update(this.mBytes);
                this.valid = this.sigVerify.verify(this.sigBytes);
                RainbowSignatureTest.assertTrue((String)("Signature generation and verification test failed.\nMessage: \"" + new String(Hex.encode(this.mBytes)) + "\"\n" + this.privKey + "\n" + this.pubKey), (boolean)this.valid);
                ++k;
            }
            ++j;
        }
    }

    protected final void performSignVerifyTest(int numPassesKPG, int numPassesSigVer, int keySize) throws Exception {
        int j = 0;
        while (j < numPassesKPG) {
            this.kpg.initialize(keySize);
            this.keyPair = this.kpg.genKeyPair();
            this.pubKey = this.keyPair.getPublic();
            this.privKey = this.keyPair.getPrivate();
            this.sig.initSign(this.privKey, new SecureRandom());
            this.sigVerify.initVerify(this.pubKey);
            int k = 1;
            while (k <= numPassesSigVer) {
                int messageSize = 100;
                this.mBytes = new byte[100];
                this.rand.nextBytes(this.mBytes);
                this.sig.update(this.mBytes, 0, this.mBytes.length);
                this.sigBytes = this.sig.sign();
                this.sigVerify.update(this.mBytes, 0, this.mBytes.length);
                this.valid = this.sigVerify.verify(this.sigBytes);
                RainbowSignatureTest.assertTrue((String)("Signature generation and verification test failed.\nMessage: \"" + new String(Hex.encode(this.mBytes)) + "\"\n" + this.privKey + "\n" + this.pubKey), (boolean)this.valid);
                ++k;
            }
            ++j;
        }
    }

    public void testRainbowWithSHA224() throws Exception {
        this.kpg = KeyPairGenerator.getInstance("Rainbow", BouncyCastlePQCProvider.PROVIDER_NAME);
        this.sig = Signature.getInstance("SHA224WITHRainbow", BouncyCastlePQCProvider.PROVIDER_NAME);
        this.sigVerify = Signature.getInstance("SHA224WITHRainbow", BouncyCastlePQCProvider.PROVIDER_NAME);
        this.performSignVerifyTest(1, 1, 28);
    }

    public void testRainbowithSHA256() throws Exception {
        this.kpg = KeyPairGenerator.getInstance("Rainbow");
        this.sig = Signature.getInstance("SHA256WITHRainbow");
        this.sigVerify = Signature.getInstance("SHA256WITHRainbow");
        this.performSignVerifyTest(1, 1, 32);
    }

    public void testRainbowWithSHA384() throws Exception {
        this.kpg = KeyPairGenerator.getInstance("Rainbow");
        this.sig = Signature.getInstance("SHA384WITHRainbow");
        this.sigVerify = Signature.getInstance("SHA384WITHRainbow");
        this.performSignVerifyTest(1, 1, 48);
    }

    public void testRainbowWithSHA512() throws Exception {
        this.kpg = KeyPairGenerator.getInstance("Rainbow");
        this.sig = Signature.getInstance("SHA512WITHRainbow");
        this.sigVerify = Signature.getInstance("SHA512WITHRainbow");
        this.performSignVerifyTest(1, 1, 64);
    }

    public void test_KeyFactory() throws Exception {
        this.kpg = KeyPairGenerator.getInstance("Rainbow");
        KeyFactory kf = KeyFactory.getInstance("Rainbow");
        RainbowParameterSpec specs = new RainbowParameterSpec();
        try {
            this.kpg.initialize(specs);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        this.kpg.initialize(5);
        this.keyPair = this.kpg.genKeyPair();
        this.pubKey = this.keyPair.getPublic();
        this.privKey = this.keyPair.getPrivate();
        byte[] pubKeyBytes = this.pubKey.getEncoded();
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyBytes);
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(this.privKey.getEncoded());
        PublicKey publicKeyKF = kf.generatePublic(pubKeySpec);
        RainbowSignatureTest.assertEquals((Object)this.pubKey, (Object)publicKeyKF);
        RainbowSignatureTest.assertEquals((int)this.pubKey.hashCode(), (int)publicKeyKF.hashCode());
        PrivateKey privKeyKF = kf.generatePrivate(privKeySpec);
        RainbowSignatureTest.assertEquals((Object)this.privKey, (Object)privKeyKF);
        RainbowSignatureTest.assertEquals((int)this.privKey.hashCode(), (int)privKeyKF.hashCode());
    }

    public void testSignVerifyWithRandomParams() throws Exception {
        this.kpg = KeyPairGenerator.getInstance("Rainbow");
        this.sig = Signature.getInstance("SHA384WITHRainbow");
        int kgen = 1;
        while (kgen <= 10) {
            int[] vi = this.chooseRandomParams();
            RainbowParameterSpec rbParams = new RainbowParameterSpec(vi);
            this.performSignVerifyTest(1, 100, rbParams);
            ++kgen;
        }
    }

    private int[] chooseRandomParams() {
        int n = this.rand.nextInt(10) + 2;
        int[] vi = new int[n];
        vi[0] = this.rand.nextInt(10) + 2;
        int i = 1;
        while (i < n) {
            vi[i] = vi[i - 1];
            int n2 = i++;
            vi[n2] = vi[n2] + (this.rand.nextInt(10) + 1);
        }
        return vi;
    }

    public void testSignVerifyWithDefaultParams() throws Exception {
        this.kpg = KeyPairGenerator.getInstance("Rainbow");
        this.sig = Signature.getInstance("SHA384WITHRainbow");
        this.performSignVerifyTest(15, 100, new RainbowParameterSpec());
    }

    public PublicKey getPublicKey(String file) throws Exception {
        this.kf = KeyFactory.getInstance("Rainbow");
        byte[] pubKeyBytes = this.getBytesFromFile(new File(file));
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(pubKeyBytes);
        return this.kf.generatePublic(pubKeySpec);
    }

    public byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }
}

