/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.ntru.polynomial.test;

import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import org.bouncycastle.pqc.math.ntru.polynomial.LongPolynomial5;
import org.bouncycastle.util.Arrays;

public class LongPolynomial5Test
extends TestCase {
    public void testMult() {
        this.testMult(new int[]{2}, new int[]{-1});
        int[] nArray = new int[2];
        nArray[0] = 2;
        int[] nArray2 = new int[2];
        nArray2[0] = -1;
        this.testMult(nArray, nArray2);
        int[] nArray3 = new int[3];
        nArray3[0] = 2;
        nArray3[2] = 3;
        int[] nArray4 = new int[3];
        nArray4[0] = -1;
        nArray4[2] = 1;
        this.testMult(nArray3, nArray4);
        int[] nArray5 = new int[4];
        nArray5[0] = 2;
        nArray5[2] = 3;
        nArray5[3] = 1;
        int[] nArray6 = new int[4];
        nArray6[0] = -1;
        nArray6[2] = 1;
        nArray6[3] = 1;
        this.testMult(nArray5, nArray6);
        int[] nArray7 = new int[5];
        nArray7[0] = 2;
        nArray7[2] = 3;
        nArray7[3] = 1;
        nArray7[4] = 2;
        int[] nArray8 = new int[5];
        nArray8[0] = -1;
        nArray8[2] = 1;
        nArray8[3] = 1;
        this.testMult(nArray7, nArray8);
        int[] nArray9 = new int[6];
        nArray9[0] = 2;
        nArray9[2] = 3;
        nArray9[3] = 1;
        nArray9[4] = 1;
        nArray9[5] = 5;
        int[] nArray10 = new int[6];
        nArray10[0] = 1;
        nArray10[1] = -1;
        nArray10[2] = 1;
        nArray10[3] = 1;
        nArray10[5] = 1;
        this.testMult(nArray9, nArray10);
        int[] nArray11 = new int[8];
        nArray11[0] = 2;
        nArray11[2] = 3;
        nArray11[3] = 1;
        nArray11[4] = 1;
        nArray11[5] = 5;
        nArray11[6] = 1;
        nArray11[7] = 4;
        int[] nArray12 = new int[8];
        nArray12[0] = 1;
        nArray12[2] = 1;
        nArray12[3] = 1;
        nArray12[4] = -1;
        nArray12[5] = 1;
        nArray12[7] = -1;
        this.testMult(nArray11, nArray12);
        int[] nArray13 = new int[8];
        nArray13[0] = 1;
        nArray13[2] = 1;
        nArray13[3] = 1;
        nArray13[4] = -1;
        nArray13[5] = 1;
        nArray13[7] = -1;
        this.testMult(new int[]{1368, 2047, 672, 871, 1662, 1352, 1099, 1608}, nArray13);
        SecureRandom rng = new SecureRandom();
        int i = 0;
        while (i < 10) {
            int[] coeffs1 = new int[rng.nextInt(2000) + 1];
            int[] coeffs2 = DenseTernaryPolynomial.generateRandom((int)coeffs1.length, (SecureRandom)rng).coeffs;
            this.testMult(coeffs1, coeffs2);
            ++i;
        }
    }

    private void testMult(int[] coeffs1, int[] coeffs2) {
        IntegerPolynomial i1 = new IntegerPolynomial(coeffs1);
        IntegerPolynomial i2 = new IntegerPolynomial(coeffs2);
        LongPolynomial5 a = new LongPolynomial5(i1);
        DenseTernaryPolynomial b = new DenseTernaryPolynomial(i2);
        IntegerPolynomial c1 = i1.mult(i2, 2048);
        IntegerPolynomial c2 = a.mult(b).toIntegerPolynomial();
        this.assertEqualsMod(c1.coeffs, c2.coeffs, 2048);
    }

    private void assertEqualsMod(int[] arr1, int[] arr2, int m) {
        LongPolynomial5Test.assertEquals((int)arr1.length, (int)arr2.length);
        int i = 0;
        while (i < arr1.length) {
            LongPolynomial5Test.assertEquals((int)((arr1[i] + m) % m), (int)((arr2[i] + m) % m));
            ++i;
        }
    }

    public void testToIntegerPolynomial() {
        int[] nArray = new int[8];
        nArray[0] = 2;
        nArray[2] = 3;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 5;
        nArray[6] = 1;
        nArray[7] = 4;
        int[] coeffs = nArray;
        LongPolynomial5 p = new LongPolynomial5(new IntegerPolynomial(coeffs));
        LongPolynomial5Test.assertTrue((boolean)Arrays.areEqual(coeffs, p.toIntegerPolynomial().coeffs));
    }
}

