/*
 * Decompiled with CFR 0.152.
 */
package org.nick.abe;

import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nick.abe.AndroidBackup;

public class Main {
    private static final String VERSION = "v20180521";

    public static void main(String[] args) {
        String tarFilename;
        boolean unpack;
        Security.addProvider(new BouncyCastleProvider());
        int maxKeyLen = -1;
        int argsLength = args.length;
        String envVar = null;
        int argSum = 0;
        String envPassword = null;
        boolean debug = false;
        boolean envpasswordRequested = false;
        if (argsLength == 0) {
            Main.usage();
            System.exit(0);
        }
        if (argsLength == 1) {
            Main.usage();
            System.exit(1);
        }
        if (args[0].equals("-debug")) {
            debug = true;
            ++argSum;
        }
        if (args[0].startsWith("-useenv=")) {
            envVar = args[0].substring("-useenv=".length());
            if (envVar != null && !envVar.equals("")) {
                envPassword = System.getenv(envVar);
            }
            ++argSum;
        }
        if (args[1].startsWith("-useenv=")) {
            envVar = args[1].substring("-useenv=".length());
            if (envVar != null && !envVar.equals("")) {
                envPassword = System.getenv(envVar);
            }
            envpasswordRequested = true;
            ++argSum;
        }
        if (argsLength <= 1 + argSum) {
            Main.usage();
            System.exit(1);
        }
        if (debug) {
            Main.displayversion();
            if (envpasswordRequested) {
                if (envPassword == null || envPassword.equals("")) {
                    System.err.println("Using environment variable \"" + envVar + "\", password is null or empty");
                } else {
                    System.err.println("Using environment variable \"" + envVar + "\", password is \"" + envPassword + "\"");
                }
            }
        }
        try {
            maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
            if (maxKeyLen < 256) {
                if (debug) {
                    System.err.println("Strong AES encryption not allowed");
                }
            } else if (debug) {
                System.err.println("Strong AES encryption allowed");
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String mode = args[0 + argSum];
        String password = envPassword;
        if ("info".equals(mode)) {
            String backupFilename = args[1 + argSum];
            if (argsLength > 2 + argSum) {
                password = args[2 + argSum];
            }
            AndroidBackup.infoBackup(backupFilename, password, debug);
            System.exit(0);
        }
        if (!("pack".equals(mode) || "unpack".equals(mode) || "pack-kk".equals(mode))) {
            Main.usage();
            System.exit(1);
        }
        if (argsLength < 3 + argSum) {
            Main.usage();
            System.exit(1);
        }
        String backupFilename = (unpack = "unpack".equals(mode)) ? args[1 + argSum] : args[2 + argSum];
        String string = tarFilename = unpack ? args[2 + argSum] : args[1 + argSum];
        if (argsLength > 3 + argSum) {
            password = args[3 + argSum];
        }
        if (unpack) {
            AndroidBackup.extractAsTar(backupFilename, tarFilename, password, debug);
        } else {
            boolean isKitKat = "pack-kk".equals(mode);
            AndroidBackup.packTar(tarFilename, backupFilename, password, isKitKat, debug);
        }
    }

    private static void usage() {
        System.err.println("android-backup-extractor v20180521");
        try {
            int maxKeyLen = Cipher.getMaxAllowedKeyLength("AES");
            System.err.println("Cipher.getMaxAllowedKeyLength(\"AES\") = " + maxKeyLen);
            if (maxKeyLen < 256) {
                System.err.println("Strong AES encryption not allowed, MaxKeyLenght is < 256 \nPlease install Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 or 8\nhttp://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html\nhttp://www.oracle.com/technetwork/java/javase/downloads/jce8-download-2133166.html");
            } else {
                System.err.println("Strong AES encryption allowed, MaxKeyLenght >= 256");
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        System.err.println("Usage:");
        System.err.println("\tinfo:\tabe [-debug] [-useenv=yourenv] info <backup.ab> [password]");
        System.err.println("\tunpack:\tabe [-debug] [-useenv=yourenv] unpack <backup.ab> <backup.tar> [password]");
        System.err.println("\tpack:\tabe [-debug] [-useenv=yourenv] pack <backup.tar> <backup.ab> [password]");
        System.err.println("\tpack 4.4.3+:\tabe [-debug] [-useenv=yourenv] pack-kk <backup.tar> <backup.ab> [password]");
        System.err.println("\tIf -useenv is used, yourenv is tried when password is not given");
        System.err.println("\tIf -debug is used, information and passwords may be shown");
        System.err.println("\tIf the filename is `-`, then data is read from standard input or written to standard output");
    }

    public static void displayversion() {
        System.err.println("android-backup-extractor v20180521");
    }
}

