# **************************************************************************
# *
# * Authors:     J.M. De la Rosa Trevin (delarosatrevin@scilifelab.se) [1]
# *              Grigory Sharov (gsharov@mrc-lmb.cam.ac.uk) [2]
# *
# * [1] SciLifeLab, Stockholm University
# * [2] MRC Laboratory of Molecular Biology (MRC-LMB)
# *
# * This program is free software; you can redistribute it and/or modify
# * it under the terms of the GNU General Public License as published by
# * the Free Software Foundation; either version 3 of the License, or
# * (at your option) any later version.
# *
# * This program is distributed in the hope that it will be useful,
# * but WITHOUT ANY WARRANTY; without even the implied warranty of
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# * GNU General Public License for more details.
# *
# * You should have received a copy of the GNU General Public License
# * along with this program; if not, write to the Free Software
# * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
# * 02111-1307  USA
# *
# *  All comments concerning this program package may be sent to the
# *  e-mail address 'delarosatrevin@scilifelab.se'
# *
# **************************************************************************

import json
import requests


class SessionClient:
    """
    Simple client to communicate with the emhub REST API.
    """
    def __init__(self, server_url='http://127.0.0.1:5000'):
        self._server_url = server_url
        # Store the last request object
        self.r = None

    def request(self, method, json=None):
        """ Make a request to this method passing the json data.
        """
        self.r = requests.post('%s/api/%s' % (self._server_url, method),
                               json=json)

        return self.r

    def json(self):
        if self.r.status_code == 200:
            return json.dumps(self.r.json(), indent=4)
        else:
            return "Request failed with status code: %s" % self.r.status_code
