"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const client_cloudformation_1 = require("@aws-sdk/client-cloudformation");
async function fetchOutputValue(stackName, outputName) {
    const cloudformation = new client_cloudformation_1.CloudFormationClient();
    const response = await cloudformation.send(new client_cloudformation_1.DescribeStacksCommand({
        StackName: stackName,
    }));
    if (!response.Stacks) {
        throw new Error(`Unable to find stack ${stackName}`);
    }
    const outputs = response.Stacks[0].Outputs ?? [];
    const output = outputs.find(o => o.OutputKey === outputName);
    if (!output) {
        throw new Error(`Unable to find output ${outputName} in stack ${stackName}`);
    }
    return output.OutputValue;
}
fetchOutputValue(process.argv[2], process.argv[3])
    .then(d => {
    console.log(JSON.stringify(d));
})
    .catch(e => {
    throw e;
});
//# sourceMappingURL=data:application/json;base64,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