import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeleteStackSetCommand, se_DeleteStackSetCommand } from "../protocols/Aws_query";
export { $Command };
export class DeleteStackSetCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "DeleteStackSet", {})
    .n("CloudFormationClient", "DeleteStackSetCommand")
    .f(void 0, void 0)
    .ser(se_DeleteStackSetCommand)
    .de(de_DeleteStackSetCommand)
    .build() {
}
