import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DeregisterTypeCommand, se_DeregisterTypeCommand } from "../protocols/Aws_query";
export { $Command };
export class DeregisterTypeCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "DeregisterType", {})
    .n("CloudFormationClient", "DeregisterTypeCommand")
    .f(void 0, void 0)
    .ser(se_DeregisterTypeCommand)
    .de(de_DeregisterTypeCommand)
    .build() {
}
