import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_DescribeStackSetCommand, se_DescribeStackSetCommand } from "../protocols/Aws_query";
export { $Command };
export class DescribeStackSetCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "DescribeStackSet", {})
    .n("CloudFormationClient", "DescribeStackSetCommand")
    .f(void 0, void 0)
    .ser(se_DescribeStackSetCommand)
    .de(de_DescribeStackSetCommand)
    .build() {
}
