import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ExecuteChangeSetCommand, se_ExecuteChangeSetCommand } from "../protocols/Aws_query";
export { $Command };
export class ExecuteChangeSetCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "ExecuteChangeSet", {})
    .n("CloudFormationClient", "ExecuteChangeSetCommand")
    .f(void 0, void 0)
    .ser(se_ExecuteChangeSetCommand)
    .de(de_ExecuteChangeSetCommand)
    .build() {
}
