import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_GetTemplateSummaryCommand, se_GetTemplateSummaryCommand } from "../protocols/Aws_query";
export { $Command };
export class GetTemplateSummaryCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "GetTemplateSummary", {})
    .n("CloudFormationClient", "GetTemplateSummaryCommand")
    .f(void 0, void 0)
    .ser(se_GetTemplateSummaryCommand)
    .de(de_GetTemplateSummaryCommand)
    .build() {
}
