import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListResourceScansCommand, se_ListResourceScansCommand } from "../protocols/Aws_query";
export { $Command };
export class ListResourceScansCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "ListResourceScans", {})
    .n("CloudFormationClient", "ListResourceScansCommand")
    .f(void 0, void 0)
    .ser(se_ListResourceScansCommand)
    .de(de_ListResourceScansCommand)
    .build() {
}
