import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListStackInstanceResourceDriftsCommand, se_ListStackInstanceResourceDriftsCommand, } from "../protocols/Aws_query";
export { $Command };
export class ListStackInstanceResourceDriftsCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "ListStackInstanceResourceDrifts", {})
    .n("CloudFormationClient", "ListStackInstanceResourceDriftsCommand")
    .f(void 0, void 0)
    .ser(se_ListStackInstanceResourceDriftsCommand)
    .de(de_ListStackInstanceResourceDriftsCommand)
    .build() {
}
