import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_ListTypesCommand, se_ListTypesCommand } from "../protocols/Aws_query";
export { $Command };
export class ListTypesCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "ListTypes", {})
    .n("CloudFormationClient", "ListTypesCommand")
    .f(void 0, void 0)
    .ser(se_ListTypesCommand)
    .de(de_ListTypesCommand)
    .build() {
}
