import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_UpdateGeneratedTemplateCommand, se_UpdateGeneratedTemplateCommand } from "../protocols/Aws_query";
export { $Command };
export class UpdateGeneratedTemplateCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "UpdateGeneratedTemplate", {})
    .n("CloudFormationClient", "UpdateGeneratedTemplateCommand")
    .f(void 0, void 0)
    .ser(se_UpdateGeneratedTemplateCommand)
    .de(de_UpdateGeneratedTemplateCommand)
    .build() {
}
