import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { de_UpdateStackCommand, se_UpdateStackCommand } from "../protocols/Aws_query";
export { $Command };
export class UpdateStackCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("CloudFormation", "UpdateStack", {})
    .n("CloudFormationClient", "UpdateStackCommand")
    .f(void 0, void 0)
    .ser(se_UpdateStackCommand)
    .de(de_UpdateStackCommand)
    .build() {
}
