import { CloudFormationServiceException as __BaseException } from "./CloudFormationServiceException";
export const AccountFilterType = {
    DIFFERENCE: "DIFFERENCE",
    INTERSECTION: "INTERSECTION",
    NONE: "NONE",
    UNION: "UNION",
};
export const AccountGateStatus = {
    FAILED: "FAILED",
    SKIPPED: "SKIPPED",
    SUCCEEDED: "SUCCEEDED",
};
export class InvalidOperationException extends __BaseException {
    name = "InvalidOperationException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "InvalidOperationException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidOperationException.prototype);
        this.Message = opts.Message;
    }
}
export class OperationNotFoundException extends __BaseException {
    name = "OperationNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "OperationNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OperationNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const ThirdPartyType = {
    HOOK: "HOOK",
    MODULE: "MODULE",
    RESOURCE: "RESOURCE",
};
export const VersionBump = {
    MAJOR: "MAJOR",
    MINOR: "MINOR",
};
export class CFNRegistryException extends __BaseException {
    name = "CFNRegistryException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "CFNRegistryException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CFNRegistryException.prototype);
        this.Message = opts.Message;
    }
}
export class TypeNotFoundException extends __BaseException {
    name = "TypeNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TypeNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TypeNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class AlreadyExistsException extends __BaseException {
    name = "AlreadyExistsException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "AlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, AlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
export const AttributeChangeType = {
    Add: "Add",
    Modify: "Modify",
    Remove: "Remove",
};
export class TypeConfigurationNotFoundException extends __BaseException {
    name = "TypeConfigurationNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TypeConfigurationNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TypeConfigurationNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const CallAs = {
    DELEGATED_ADMIN: "DELEGATED_ADMIN",
    SELF: "SELF",
};
export class TokenAlreadyExistsException extends __BaseException {
    name = "TokenAlreadyExistsException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "TokenAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, TokenAlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
export const Capability = {
    CAPABILITY_AUTO_EXPAND: "CAPABILITY_AUTO_EXPAND",
    CAPABILITY_IAM: "CAPABILITY_IAM",
    CAPABILITY_NAMED_IAM: "CAPABILITY_NAMED_IAM",
};
export const Category = {
    ACTIVATED: "ACTIVATED",
    AWS_TYPES: "AWS_TYPES",
    REGISTERED: "REGISTERED",
    THIRD_PARTY: "THIRD_PARTY",
};
export const ChangeAction = {
    Add: "Add",
    Dynamic: "Dynamic",
    Import: "Import",
    Modify: "Modify",
    Remove: "Remove",
};
export const ChangeSource = {
    Automatic: "Automatic",
    DirectModification: "DirectModification",
    ParameterReference: "ParameterReference",
    ResourceAttribute: "ResourceAttribute",
    ResourceReference: "ResourceReference",
};
export const EvaluationType = {
    Dynamic: "Dynamic",
    Static: "Static",
};
export const ResourceAttribute = {
    CreationPolicy: "CreationPolicy",
    DeletionPolicy: "DeletionPolicy",
    Metadata: "Metadata",
    Properties: "Properties",
    Tags: "Tags",
    UpdatePolicy: "UpdatePolicy",
    UpdateReplacePolicy: "UpdateReplacePolicy",
};
export const RequiresRecreation = {
    Always: "Always",
    Conditionally: "Conditionally",
    Never: "Never",
};
export const PolicyAction = {
    Delete: "Delete",
    ReplaceAndDelete: "ReplaceAndDelete",
    ReplaceAndRetain: "ReplaceAndRetain",
    ReplaceAndSnapshot: "ReplaceAndSnapshot",
    Retain: "Retain",
    Snapshot: "Snapshot",
};
export const Replacement = {
    Conditional: "Conditional",
    False: "False",
    True: "True",
};
export const ChangeType = {
    Resource: "Resource",
};
export const HookFailureMode = {
    FAIL: "FAIL",
    WARN: "WARN",
};
export const HookInvocationPoint = {
    PRE_PROVISION: "PRE_PROVISION",
};
export const HookTargetType = {
    RESOURCE: "RESOURCE",
};
export const ChangeSetHooksStatus = {
    PLANNED: "PLANNED",
    PLANNING: "PLANNING",
    UNAVAILABLE: "UNAVAILABLE",
};
export class ChangeSetNotFoundException extends __BaseException {
    name = "ChangeSetNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ChangeSetNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ChangeSetNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const ChangeSetStatus = {
    CREATE_COMPLETE: "CREATE_COMPLETE",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    CREATE_PENDING: "CREATE_PENDING",
    DELETE_COMPLETE: "DELETE_COMPLETE",
    DELETE_FAILED: "DELETE_FAILED",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
    DELETE_PENDING: "DELETE_PENDING",
    FAILED: "FAILED",
};
export const ExecutionStatus = {
    AVAILABLE: "AVAILABLE",
    EXECUTE_COMPLETE: "EXECUTE_COMPLETE",
    EXECUTE_FAILED: "EXECUTE_FAILED",
    EXECUTE_IN_PROGRESS: "EXECUTE_IN_PROGRESS",
    OBSOLETE: "OBSOLETE",
    UNAVAILABLE: "UNAVAILABLE",
};
export const ChangeSetType = {
    CREATE: "CREATE",
    IMPORT: "IMPORT",
    UPDATE: "UPDATE",
};
export const OnStackFailure = {
    DELETE: "DELETE",
    DO_NOTHING: "DO_NOTHING",
    ROLLBACK: "ROLLBACK",
};
export class InsufficientCapabilitiesException extends __BaseException {
    name = "InsufficientCapabilitiesException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "InsufficientCapabilitiesException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InsufficientCapabilitiesException.prototype);
        this.Message = opts.Message;
    }
}
export class LimitExceededException extends __BaseException {
    name = "LimitExceededException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "LimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, LimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export class ConcurrentResourcesLimitExceededException extends __BaseException {
    name = "ConcurrentResourcesLimitExceededException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ConcurrentResourcesLimitExceededException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ConcurrentResourcesLimitExceededException.prototype);
        this.Message = opts.Message;
    }
}
export const GeneratedTemplateDeletionPolicy = {
    DELETE: "DELETE",
    RETAIN: "RETAIN",
};
export const GeneratedTemplateUpdateReplacePolicy = {
    DELETE: "DELETE",
    RETAIN: "RETAIN",
};
export const OnFailure = {
    DELETE: "DELETE",
    DO_NOTHING: "DO_NOTHING",
    ROLLBACK: "ROLLBACK",
};
export const ConcurrencyMode = {
    SOFT_FAILURE_TOLERANCE: "SOFT_FAILURE_TOLERANCE",
    STRICT_FAILURE_TOLERANCE: "STRICT_FAILURE_TOLERANCE",
};
export const RegionConcurrencyType = {
    PARALLEL: "PARALLEL",
    SEQUENTIAL: "SEQUENTIAL",
};
export class OperationIdAlreadyExistsException extends __BaseException {
    name = "OperationIdAlreadyExistsException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "OperationIdAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OperationIdAlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
export class OperationInProgressException extends __BaseException {
    name = "OperationInProgressException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "OperationInProgressException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, OperationInProgressException.prototype);
        this.Message = opts.Message;
    }
}
export class StackSetNotFoundException extends __BaseException {
    name = "StackSetNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "StackSetNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StackSetNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class StaleRequestException extends __BaseException {
    name = "StaleRequestException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "StaleRequestException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StaleRequestException.prototype);
        this.Message = opts.Message;
    }
}
export class CreatedButModifiedException extends __BaseException {
    name = "CreatedButModifiedException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "CreatedButModifiedException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, CreatedButModifiedException.prototype);
        this.Message = opts.Message;
    }
}
export const PermissionModels = {
    SELF_MANAGED: "SELF_MANAGED",
    SERVICE_MANAGED: "SERVICE_MANAGED",
};
export class NameAlreadyExistsException extends __BaseException {
    name = "NameAlreadyExistsException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "NameAlreadyExistsException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, NameAlreadyExistsException.prototype);
        this.Message = opts.Message;
    }
}
export class InvalidChangeSetStatusException extends __BaseException {
    name = "InvalidChangeSetStatusException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "InvalidChangeSetStatusException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, InvalidChangeSetStatusException.prototype);
        this.Message = opts.Message;
    }
}
export class GeneratedTemplateNotFoundException extends __BaseException {
    name = "GeneratedTemplateNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "GeneratedTemplateNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, GeneratedTemplateNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const DeletionMode = {
    FORCE_DELETE_STACK: "FORCE_DELETE_STACK",
    STANDARD: "STANDARD",
};
export class StackSetNotEmptyException extends __BaseException {
    name = "StackSetNotEmptyException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "StackSetNotEmptyException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StackSetNotEmptyException.prototype);
        this.Message = opts.Message;
    }
}
export const RegistryType = {
    HOOK: "HOOK",
    MODULE: "MODULE",
    RESOURCE: "RESOURCE",
};
export const GeneratedTemplateResourceStatus = {
    COMPLETE: "COMPLETE",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    PENDING: "PENDING",
};
export const WarningType = {
    EXCLUDED_PROPERTIES: "EXCLUDED_PROPERTIES",
    MUTUALLY_EXCLUSIVE_PROPERTIES: "MUTUALLY_EXCLUSIVE_PROPERTIES",
    MUTUALLY_EXCLUSIVE_TYPES: "MUTUALLY_EXCLUSIVE_TYPES",
    UNSUPPORTED_PROPERTIES: "UNSUPPORTED_PROPERTIES",
};
export const GeneratedTemplateStatus = {
    COMPLETE: "COMPLETE",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    CREATE_PENDING: "CREATE_PENDING",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
    DELETE_PENDING: "DELETE_PENDING",
    FAILED: "FAILED",
    UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS",
    UPDATE_PENDING: "UPDATE_PENDING",
};
export const OrganizationStatus = {
    DISABLED: "DISABLED",
    DISABLED_PERMANENTLY: "DISABLED_PERMANENTLY",
    ENABLED: "ENABLED",
};
export const IdentityProvider = {
    AWS_Marketplace: "AWS_Marketplace",
    Bitbucket: "Bitbucket",
    GitHub: "GitHub",
};
export const PublisherStatus = {
    UNVERIFIED: "UNVERIFIED",
    VERIFIED: "VERIFIED",
};
export const ResourceScanStatus = {
    COMPLETE: "COMPLETE",
    EXPIRED: "EXPIRED",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
};
export class ResourceScanNotFoundException extends __BaseException {
    name = "ResourceScanNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ResourceScanNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceScanNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const StackDriftDetectionStatus = {
    DETECTION_COMPLETE: "DETECTION_COMPLETE",
    DETECTION_FAILED: "DETECTION_FAILED",
    DETECTION_IN_PROGRESS: "DETECTION_IN_PROGRESS",
};
export const StackDriftStatus = {
    DRIFTED: "DRIFTED",
    IN_SYNC: "IN_SYNC",
    NOT_CHECKED: "NOT_CHECKED",
    UNKNOWN: "UNKNOWN",
};
export const DetailedStatus = {
    CONFIGURATION_COMPLETE: "CONFIGURATION_COMPLETE",
    VALIDATION_FAILED: "VALIDATION_FAILED",
};
export const HookStatus = {
    HOOK_COMPLETE_FAILED: "HOOK_COMPLETE_FAILED",
    HOOK_COMPLETE_SUCCEEDED: "HOOK_COMPLETE_SUCCEEDED",
    HOOK_FAILED: "HOOK_FAILED",
    HOOK_IN_PROGRESS: "HOOK_IN_PROGRESS",
};
export const ResourceStatus = {
    CREATE_COMPLETE: "CREATE_COMPLETE",
    CREATE_FAILED: "CREATE_FAILED",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    DELETE_COMPLETE: "DELETE_COMPLETE",
    DELETE_FAILED: "DELETE_FAILED",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
    DELETE_SKIPPED: "DELETE_SKIPPED",
    EXPORT_COMPLETE: "EXPORT_COMPLETE",
    EXPORT_FAILED: "EXPORT_FAILED",
    EXPORT_IN_PROGRESS: "EXPORT_IN_PROGRESS",
    EXPORT_ROLLBACK_COMPLETE: "EXPORT_ROLLBACK_COMPLETE",
    EXPORT_ROLLBACK_FAILED: "EXPORT_ROLLBACK_FAILED",
    EXPORT_ROLLBACK_IN_PROGRESS: "EXPORT_ROLLBACK_IN_PROGRESS",
    IMPORT_COMPLETE: "IMPORT_COMPLETE",
    IMPORT_FAILED: "IMPORT_FAILED",
    IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS",
    IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE",
    IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED",
    IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS",
    ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE",
    ROLLBACK_FAILED: "ROLLBACK_FAILED",
    ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS",
    UPDATE_COMPLETE: "UPDATE_COMPLETE",
    UPDATE_FAILED: "UPDATE_FAILED",
    UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS",
    UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE",
    UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED",
    UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS",
};
export const StackInstanceDetailedStatus = {
    CANCELLED: "CANCELLED",
    FAILED: "FAILED",
    FAILED_IMPORT: "FAILED_IMPORT",
    INOPERABLE: "INOPERABLE",
    PENDING: "PENDING",
    RUNNING: "RUNNING",
    SKIPPED_SUSPENDED_ACCOUNT: "SKIPPED_SUSPENDED_ACCOUNT",
    SUCCEEDED: "SUCCEEDED",
};
export const StackInstanceStatus = {
    CURRENT: "CURRENT",
    INOPERABLE: "INOPERABLE",
    OUTDATED: "OUTDATED",
};
export class StackInstanceNotFoundException extends __BaseException {
    name = "StackInstanceNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "StackInstanceNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StackInstanceNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const StackRefactorExecutionStatus = {
    AVAILABLE: "AVAILABLE",
    EXECUTE_COMPLETE: "EXECUTE_COMPLETE",
    EXECUTE_FAILED: "EXECUTE_FAILED",
    EXECUTE_IN_PROGRESS: "EXECUTE_IN_PROGRESS",
    OBSOLETE: "OBSOLETE",
    ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE",
    ROLLBACK_FAILED: "ROLLBACK_FAILED",
    ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS",
    UNAVAILABLE: "UNAVAILABLE",
};
export const StackRefactorStatus = {
    CREATE_COMPLETE: "CREATE_COMPLETE",
    CREATE_FAILED: "CREATE_FAILED",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    DELETE_COMPLETE: "DELETE_COMPLETE",
    DELETE_FAILED: "DELETE_FAILED",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
};
export class StackRefactorNotFoundException extends __BaseException {
    name = "StackRefactorNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "StackRefactorNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StackRefactorNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const StackResourceDriftStatus = {
    DELETED: "DELETED",
    IN_SYNC: "IN_SYNC",
    MODIFIED: "MODIFIED",
    NOT_CHECKED: "NOT_CHECKED",
    UNKNOWN: "UNKNOWN",
};
export const DifferenceType = {
    ADD: "ADD",
    NOT_EQUAL: "NOT_EQUAL",
    REMOVE: "REMOVE",
};
export const StackStatus = {
    CREATE_COMPLETE: "CREATE_COMPLETE",
    CREATE_FAILED: "CREATE_FAILED",
    CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS",
    DELETE_COMPLETE: "DELETE_COMPLETE",
    DELETE_FAILED: "DELETE_FAILED",
    DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS",
    IMPORT_COMPLETE: "IMPORT_COMPLETE",
    IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS",
    IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE",
    IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED",
    IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS",
    REVIEW_IN_PROGRESS: "REVIEW_IN_PROGRESS",
    ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE",
    ROLLBACK_FAILED: "ROLLBACK_FAILED",
    ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS",
    UPDATE_COMPLETE: "UPDATE_COMPLETE",
    UPDATE_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS",
    UPDATE_FAILED: "UPDATE_FAILED",
    UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS",
    UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE",
    UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS",
    UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED",
    UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS",
};
export const StackSetDriftDetectionStatus = {
    COMPLETED: "COMPLETED",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    PARTIAL_SUCCESS: "PARTIAL_SUCCESS",
    STOPPED: "STOPPED",
};
export const StackSetDriftStatus = {
    DRIFTED: "DRIFTED",
    IN_SYNC: "IN_SYNC",
    NOT_CHECKED: "NOT_CHECKED",
};
export const StackSetStatus = {
    ACTIVE: "ACTIVE",
    DELETED: "DELETED",
};
export const StackSetOperationAction = {
    CREATE: "CREATE",
    DELETE: "DELETE",
    DETECT_DRIFT: "DETECT_DRIFT",
    UPDATE: "UPDATE",
};
export const StackSetOperationStatus = {
    FAILED: "FAILED",
    QUEUED: "QUEUED",
    RUNNING: "RUNNING",
    STOPPED: "STOPPED",
    STOPPING: "STOPPING",
    SUCCEEDED: "SUCCEEDED",
};
export const DeprecatedStatus = {
    DEPRECATED: "DEPRECATED",
    LIVE: "LIVE",
};
export const ProvisioningType = {
    FULLY_MUTABLE: "FULLY_MUTABLE",
    IMMUTABLE: "IMMUTABLE",
    NON_PROVISIONABLE: "NON_PROVISIONABLE",
};
export const TypeTestsStatus = {
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
    NOT_TESTED: "NOT_TESTED",
    PASSED: "PASSED",
};
export const Visibility = {
    PRIVATE: "PRIVATE",
    PUBLIC: "PUBLIC",
};
export const RegistrationStatus = {
    COMPLETE: "COMPLETE",
    FAILED: "FAILED",
    IN_PROGRESS: "IN_PROGRESS",
};
export const TemplateFormat = {
    JSON: "JSON",
    YAML: "YAML",
};
export const TemplateStage = {
    Original: "Original",
    Processed: "Processed",
};
export class StackNotFoundException extends __BaseException {
    name = "StackNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "StackNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, StackNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export class HookResultNotFoundException extends __BaseException {
    name = "HookResultNotFoundException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "HookResultNotFoundException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, HookResultNotFoundException.prototype);
        this.Message = opts.Message;
    }
}
export const ListHookResultsTargetType = {
    CHANGE_SET: "CHANGE_SET",
    CLOUD_CONTROL: "CLOUD_CONTROL",
    RESOURCE: "RESOURCE",
    STACK: "STACK",
};
export class ResourceScanInProgressException extends __BaseException {
    name = "ResourceScanInProgressException";
    $fault = "client";
    Message;
    constructor(opts) {
        super({
            name: "ResourceScanInProgressException",
            $fault: "client",
            ...opts,
        });
        Object.setPrototypeOf(this, ResourceScanInProgressException.prototype);
        this.Message = opts.Message;
    }
}
export const ScanType = {
    FULL: "FULL",
    PARTIAL: "PARTIAL",
};
export const StackInstanceFilterName = {
    DETAILED_STATUS: "DETAILED_STATUS",
    DRIFT_STATUS: "DRIFT_STATUS",
    LAST_OPERATION_ID: "LAST_OPERATION_ID",
};
export const StackRefactorActionType = {
    CREATE: "CREATE",
    MOVE: "MOVE",
};
export const StackRefactorDetection = {
    AUTO: "AUTO",
    MANUAL: "MANUAL",
};
export const StackRefactorActionEntity = {
    RESOURCE: "RESOURCE",
    STACK: "STACK",
};
export const OperationResultFilterName = {
    OPERATION_RESULT_STATUS: "OPERATION_RESULT_STATUS",
};
export const StackSetOperationResultStatus = {
    CANCELLED: "CANCELLED",
    FAILED: "FAILED",
    PENDING: "PENDING",
    RUNNING: "RUNNING",
    SUCCEEDED: "SUCCEEDED",
};
