import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { DeleteGeneratedTemplateInput } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link DeleteGeneratedTemplateCommand}.
 */
export interface DeleteGeneratedTemplateCommandInput extends DeleteGeneratedTemplateInput {
}
/**
 * @public
 *
 * The output of {@link DeleteGeneratedTemplateCommand}.
 */
export interface DeleteGeneratedTemplateCommandOutput extends __MetadataBearer {
}
declare const DeleteGeneratedTemplateCommand_base: {
    new (input: DeleteGeneratedTemplateCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteGeneratedTemplateCommandInput, DeleteGeneratedTemplateCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: DeleteGeneratedTemplateCommandInput): import("@smithy/smithy-client").CommandImpl<DeleteGeneratedTemplateCommandInput, DeleteGeneratedTemplateCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Deleted a generated template.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, DeleteGeneratedTemplateCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, DeleteGeneratedTemplateCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // DeleteGeneratedTemplateInput
 *   GeneratedTemplateName: "STRING_VALUE", // required
 * };
 * const command = new DeleteGeneratedTemplateCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param DeleteGeneratedTemplateCommandInput - {@link DeleteGeneratedTemplateCommandInput}
 * @returns {@link DeleteGeneratedTemplateCommandOutput}
 * @see {@link DeleteGeneratedTemplateCommandInput} for command's `input` shape.
 * @see {@link DeleteGeneratedTemplateCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link ConcurrentResourcesLimitExceededException} (client fault)
 *  <p>No more than 5 generated templates can be in an <code>InProgress</code> or <code>Pending</code> status at one
 *    time. This error is also returned if a generated template that is in an <code>InProgress</code> or
 *    <code>Pending</code> status is attempted to be updated or deleted.</p>
 *
 * @throws {@link GeneratedTemplateNotFoundException} (client fault)
 *  <p>The generated template was not found.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 *
 * @example To delete a generated template
 * ```javascript
 * // This example deletes a generated template
 * const input = {
 *   GeneratedTemplateName: "JazzyTemplate"
 * };
 * const command = new DeleteGeneratedTemplateCommand(input);
 * const response = await client.send(command);
 * /* response is
 * { /* metadata only *\/ }
 * *\/
 * ```
 *
 * @public
 */
export declare class DeleteGeneratedTemplateCommand extends DeleteGeneratedTemplateCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: DeleteGeneratedTemplateInput;
            output: {};
        };
        sdk: {
            input: DeleteGeneratedTemplateCommandInput;
            output: DeleteGeneratedTemplateCommandOutput;
        };
    };
}
