import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { ExecuteStackRefactorInput } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ExecuteStackRefactorCommand}.
 */
export interface ExecuteStackRefactorCommandInput extends ExecuteStackRefactorInput {
}
/**
 * @public
 *
 * The output of {@link ExecuteStackRefactorCommand}.
 */
export interface ExecuteStackRefactorCommandOutput extends __MetadataBearer {
}
declare const ExecuteStackRefactorCommand_base: {
    new (input: ExecuteStackRefactorCommandInput): import("@smithy/smithy-client").CommandImpl<ExecuteStackRefactorCommandInput, ExecuteStackRefactorCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ExecuteStackRefactorCommandInput): import("@smithy/smithy-client").CommandImpl<ExecuteStackRefactorCommandInput, ExecuteStackRefactorCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Executes the stack refactor operation.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, ExecuteStackRefactorCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, ExecuteStackRefactorCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // ExecuteStackRefactorInput
 *   StackRefactorId: "STRING_VALUE", // required
 * };
 * const command = new ExecuteStackRefactorCommand(input);
 * const response = await client.send(command);
 * // {};
 *
 * ```
 *
 * @param ExecuteStackRefactorCommandInput - {@link ExecuteStackRefactorCommandInput}
 * @returns {@link ExecuteStackRefactorCommandOutput}
 * @see {@link ExecuteStackRefactorCommandInput} for command's `input` shape.
 * @see {@link ExecuteStackRefactorCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 *
 * @public
 */
export declare class ExecuteStackRefactorCommand extends ExecuteStackRefactorCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ExecuteStackRefactorInput;
            output: {};
        };
        sdk: {
            input: ExecuteStackRefactorCommandInput;
            output: ExecuteStackRefactorCommandOutput;
        };
    };
}
