import { Command as $Command } from "@smithy/smithy-client";
import { MetadataBearer as __MetadataBearer } from "@smithy/types";
import { CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../CloudFormationClient";
import { ListStackSetAutoDeploymentTargetsInput, ListStackSetAutoDeploymentTargetsOutput } from "../models/models_0";
/**
 * @public
 */
export type { __MetadataBearer };
export { $Command };
/**
 * @public
 *
 * The input for {@link ListStackSetAutoDeploymentTargetsCommand}.
 */
export interface ListStackSetAutoDeploymentTargetsCommandInput extends ListStackSetAutoDeploymentTargetsInput {
}
/**
 * @public
 *
 * The output of {@link ListStackSetAutoDeploymentTargetsCommand}.
 */
export interface ListStackSetAutoDeploymentTargetsCommandOutput extends ListStackSetAutoDeploymentTargetsOutput, __MetadataBearer {
}
declare const ListStackSetAutoDeploymentTargetsCommand_base: {
    new (input: ListStackSetAutoDeploymentTargetsCommandInput): import("@smithy/smithy-client").CommandImpl<ListStackSetAutoDeploymentTargetsCommandInput, ListStackSetAutoDeploymentTargetsCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    new (input: ListStackSetAutoDeploymentTargetsCommandInput): import("@smithy/smithy-client").CommandImpl<ListStackSetAutoDeploymentTargetsCommandInput, ListStackSetAutoDeploymentTargetsCommandOutput, CloudFormationClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes>;
    getEndpointParameterInstructions(): import("@smithy/middleware-endpoint").EndpointParameterInstructions;
};
/**
 * <p>Returns summary information about deployment targets for a stack set.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { CloudFormationClient, ListStackSetAutoDeploymentTargetsCommand } from "@aws-sdk/client-cloudformation"; // ES Modules import
 * // const { CloudFormationClient, ListStackSetAutoDeploymentTargetsCommand } = require("@aws-sdk/client-cloudformation"); // CommonJS import
 * const client = new CloudFormationClient(config);
 * const input = { // ListStackSetAutoDeploymentTargetsInput
 *   StackSetName: "STRING_VALUE", // required
 *   NextToken: "STRING_VALUE",
 *   MaxResults: Number("int"),
 *   CallAs: "SELF" || "DELEGATED_ADMIN",
 * };
 * const command = new ListStackSetAutoDeploymentTargetsCommand(input);
 * const response = await client.send(command);
 * // { // ListStackSetAutoDeploymentTargetsOutput
 * //   Summaries: [ // StackSetAutoDeploymentTargetSummaries
 * //     { // StackSetAutoDeploymentTargetSummary
 * //       OrganizationalUnitId: "STRING_VALUE",
 * //       Regions: [ // RegionList
 * //         "STRING_VALUE",
 * //       ],
 * //     },
 * //   ],
 * //   NextToken: "STRING_VALUE",
 * // };
 *
 * ```
 *
 * @param ListStackSetAutoDeploymentTargetsCommandInput - {@link ListStackSetAutoDeploymentTargetsCommandInput}
 * @returns {@link ListStackSetAutoDeploymentTargetsCommandOutput}
 * @see {@link ListStackSetAutoDeploymentTargetsCommandInput} for command's `input` shape.
 * @see {@link ListStackSetAutoDeploymentTargetsCommandOutput} for command's `response` shape.
 * @see {@link CloudFormationClientResolvedConfig | config} for CloudFormationClient's `config` shape.
 *
 * @throws {@link StackSetNotFoundException} (client fault)
 *  <p>The specified stack set doesn't exist.</p>
 *
 * @throws {@link CloudFormationServiceException}
 * <p>Base exception class for all service exceptions from CloudFormation service.</p>
 *
 *
 * @public
 */
export declare class ListStackSetAutoDeploymentTargetsCommand extends ListStackSetAutoDeploymentTargetsCommand_base {
    /** @internal type navigation helper, not in runtime. */
    protected static __types: {
        api: {
            input: ListStackSetAutoDeploymentTargetsInput;
            output: ListStackSetAutoDeploymentTargetsOutput;
        };
        sdk: {
            input: ListStackSetAutoDeploymentTargetsCommandInput;
            output: ListStackSetAutoDeploymentTargetsCommandOutput;
        };
    };
}
