import {
  HostHeaderInputConfig,
  HostHeaderResolvedConfig,
} from "@aws-sdk/middleware-host-header";
import {
  UserAgentInputConfig,
  UserAgentResolvedConfig,
} from "@aws-sdk/middleware-user-agent";
import {
  RegionInputConfig,
  RegionResolvedConfig,
} from "@smithy/config-resolver";
import {
  EndpointInputConfig,
  EndpointResolvedConfig,
} from "@smithy/middleware-endpoint";
import {
  RetryInputConfig,
  RetryResolvedConfig,
} from "@smithy/middleware-retry";
import { HttpHandlerUserInput as __HttpHandlerUserInput } from "@smithy/protocol-http";
import {
  Client as __Client,
  DefaultsMode as __DefaultsMode,
  SmithyConfiguration as __SmithyConfiguration,
  SmithyResolvedConfiguration as __SmithyResolvedConfiguration,
} from "@smithy/smithy-client";
import {
  AwsCredentialIdentityProvider,
  BodyLengthCalculator as __BodyLengthCalculator,
  CheckOptionalClientConfig as __CheckOptionalClientConfig,
  ChecksumConstructor as __ChecksumConstructor,
  Decoder as __Decoder,
  Encoder as __Encoder,
  HashConstructor as __HashConstructor,
  HttpHandlerOptions as __HttpHandlerOptions,
  Logger as __Logger,
  Provider as __Provider,
  Provider,
  StreamCollector as __StreamCollector,
  UrlParser as __UrlParser,
  UserAgent as __UserAgent,
} from "@smithy/types";
import {
  HttpAuthSchemeInputConfig,
  HttpAuthSchemeResolvedConfig,
} from "./auth/httpAuthSchemeProvider";
import {
  ActivateOrganizationsAccessCommandInput,
  ActivateOrganizationsAccessCommandOutput,
} from "./commands/ActivateOrganizationsAccessCommand";
import {
  ActivateTypeCommandInput,
  ActivateTypeCommandOutput,
} from "./commands/ActivateTypeCommand";
import {
  BatchDescribeTypeConfigurationsCommandInput,
  BatchDescribeTypeConfigurationsCommandOutput,
} from "./commands/BatchDescribeTypeConfigurationsCommand";
import {
  CancelUpdateStackCommandInput,
  CancelUpdateStackCommandOutput,
} from "./commands/CancelUpdateStackCommand";
import {
  ContinueUpdateRollbackCommandInput,
  ContinueUpdateRollbackCommandOutput,
} from "./commands/ContinueUpdateRollbackCommand";
import {
  CreateChangeSetCommandInput,
  CreateChangeSetCommandOutput,
} from "./commands/CreateChangeSetCommand";
import {
  CreateGeneratedTemplateCommandInput,
  CreateGeneratedTemplateCommandOutput,
} from "./commands/CreateGeneratedTemplateCommand";
import {
  CreateStackCommandInput,
  CreateStackCommandOutput,
} from "./commands/CreateStackCommand";
import {
  CreateStackInstancesCommandInput,
  CreateStackInstancesCommandOutput,
} from "./commands/CreateStackInstancesCommand";
import {
  CreateStackRefactorCommandInput,
  CreateStackRefactorCommandOutput,
} from "./commands/CreateStackRefactorCommand";
import {
  CreateStackSetCommandInput,
  CreateStackSetCommandOutput,
} from "./commands/CreateStackSetCommand";
import {
  DeactivateOrganizationsAccessCommandInput,
  DeactivateOrganizationsAccessCommandOutput,
} from "./commands/DeactivateOrganizationsAccessCommand";
import {
  DeactivateTypeCommandInput,
  DeactivateTypeCommandOutput,
} from "./commands/DeactivateTypeCommand";
import {
  DeleteChangeSetCommandInput,
  DeleteChangeSetCommandOutput,
} from "./commands/DeleteChangeSetCommand";
import {
  DeleteGeneratedTemplateCommandInput,
  DeleteGeneratedTemplateCommandOutput,
} from "./commands/DeleteGeneratedTemplateCommand";
import {
  DeleteStackCommandInput,
  DeleteStackCommandOutput,
} from "./commands/DeleteStackCommand";
import {
  DeleteStackInstancesCommandInput,
  DeleteStackInstancesCommandOutput,
} from "./commands/DeleteStackInstancesCommand";
import {
  DeleteStackSetCommandInput,
  DeleteStackSetCommandOutput,
} from "./commands/DeleteStackSetCommand";
import {
  DeregisterTypeCommandInput,
  DeregisterTypeCommandOutput,
} from "./commands/DeregisterTypeCommand";
import {
  DescribeAccountLimitsCommandInput,
  DescribeAccountLimitsCommandOutput,
} from "./commands/DescribeAccountLimitsCommand";
import {
  DescribeChangeSetCommandInput,
  DescribeChangeSetCommandOutput,
} from "./commands/DescribeChangeSetCommand";
import {
  DescribeChangeSetHooksCommandInput,
  DescribeChangeSetHooksCommandOutput,
} from "./commands/DescribeChangeSetHooksCommand";
import {
  DescribeGeneratedTemplateCommandInput,
  DescribeGeneratedTemplateCommandOutput,
} from "./commands/DescribeGeneratedTemplateCommand";
import {
  DescribeOrganizationsAccessCommandInput,
  DescribeOrganizationsAccessCommandOutput,
} from "./commands/DescribeOrganizationsAccessCommand";
import {
  DescribePublisherCommandInput,
  DescribePublisherCommandOutput,
} from "./commands/DescribePublisherCommand";
import {
  DescribeResourceScanCommandInput,
  DescribeResourceScanCommandOutput,
} from "./commands/DescribeResourceScanCommand";
import {
  DescribeStackDriftDetectionStatusCommandInput,
  DescribeStackDriftDetectionStatusCommandOutput,
} from "./commands/DescribeStackDriftDetectionStatusCommand";
import {
  DescribeStackEventsCommandInput,
  DescribeStackEventsCommandOutput,
} from "./commands/DescribeStackEventsCommand";
import {
  DescribeStackInstanceCommandInput,
  DescribeStackInstanceCommandOutput,
} from "./commands/DescribeStackInstanceCommand";
import {
  DescribeStackRefactorCommandInput,
  DescribeStackRefactorCommandOutput,
} from "./commands/DescribeStackRefactorCommand";
import {
  DescribeStackResourceCommandInput,
  DescribeStackResourceCommandOutput,
} from "./commands/DescribeStackResourceCommand";
import {
  DescribeStackResourceDriftsCommandInput,
  DescribeStackResourceDriftsCommandOutput,
} from "./commands/DescribeStackResourceDriftsCommand";
import {
  DescribeStackResourcesCommandInput,
  DescribeStackResourcesCommandOutput,
} from "./commands/DescribeStackResourcesCommand";
import {
  DescribeStacksCommandInput,
  DescribeStacksCommandOutput,
} from "./commands/DescribeStacksCommand";
import {
  DescribeStackSetCommandInput,
  DescribeStackSetCommandOutput,
} from "./commands/DescribeStackSetCommand";
import {
  DescribeStackSetOperationCommandInput,
  DescribeStackSetOperationCommandOutput,
} from "./commands/DescribeStackSetOperationCommand";
import {
  DescribeTypeCommandInput,
  DescribeTypeCommandOutput,
} from "./commands/DescribeTypeCommand";
import {
  DescribeTypeRegistrationCommandInput,
  DescribeTypeRegistrationCommandOutput,
} from "./commands/DescribeTypeRegistrationCommand";
import {
  DetectStackDriftCommandInput,
  DetectStackDriftCommandOutput,
} from "./commands/DetectStackDriftCommand";
import {
  DetectStackResourceDriftCommandInput,
  DetectStackResourceDriftCommandOutput,
} from "./commands/DetectStackResourceDriftCommand";
import {
  DetectStackSetDriftCommandInput,
  DetectStackSetDriftCommandOutput,
} from "./commands/DetectStackSetDriftCommand";
import {
  EstimateTemplateCostCommandInput,
  EstimateTemplateCostCommandOutput,
} from "./commands/EstimateTemplateCostCommand";
import {
  ExecuteChangeSetCommandInput,
  ExecuteChangeSetCommandOutput,
} from "./commands/ExecuteChangeSetCommand";
import {
  ExecuteStackRefactorCommandInput,
  ExecuteStackRefactorCommandOutput,
} from "./commands/ExecuteStackRefactorCommand";
import {
  GetGeneratedTemplateCommandInput,
  GetGeneratedTemplateCommandOutput,
} from "./commands/GetGeneratedTemplateCommand";
import {
  GetStackPolicyCommandInput,
  GetStackPolicyCommandOutput,
} from "./commands/GetStackPolicyCommand";
import {
  GetTemplateCommandInput,
  GetTemplateCommandOutput,
} from "./commands/GetTemplateCommand";
import {
  GetTemplateSummaryCommandInput,
  GetTemplateSummaryCommandOutput,
} from "./commands/GetTemplateSummaryCommand";
import {
  ImportStacksToStackSetCommandInput,
  ImportStacksToStackSetCommandOutput,
} from "./commands/ImportStacksToStackSetCommand";
import {
  ListChangeSetsCommandInput,
  ListChangeSetsCommandOutput,
} from "./commands/ListChangeSetsCommand";
import {
  ListExportsCommandInput,
  ListExportsCommandOutput,
} from "./commands/ListExportsCommand";
import {
  ListGeneratedTemplatesCommandInput,
  ListGeneratedTemplatesCommandOutput,
} from "./commands/ListGeneratedTemplatesCommand";
import {
  ListHookResultsCommandInput,
  ListHookResultsCommandOutput,
} from "./commands/ListHookResultsCommand";
import {
  ListImportsCommandInput,
  ListImportsCommandOutput,
} from "./commands/ListImportsCommand";
import {
  ListResourceScanRelatedResourcesCommandInput,
  ListResourceScanRelatedResourcesCommandOutput,
} from "./commands/ListResourceScanRelatedResourcesCommand";
import {
  ListResourceScanResourcesCommandInput,
  ListResourceScanResourcesCommandOutput,
} from "./commands/ListResourceScanResourcesCommand";
import {
  ListResourceScansCommandInput,
  ListResourceScansCommandOutput,
} from "./commands/ListResourceScansCommand";
import {
  ListStackInstanceResourceDriftsCommandInput,
  ListStackInstanceResourceDriftsCommandOutput,
} from "./commands/ListStackInstanceResourceDriftsCommand";
import {
  ListStackInstancesCommandInput,
  ListStackInstancesCommandOutput,
} from "./commands/ListStackInstancesCommand";
import {
  ListStackRefactorActionsCommandInput,
  ListStackRefactorActionsCommandOutput,
} from "./commands/ListStackRefactorActionsCommand";
import {
  ListStackRefactorsCommandInput,
  ListStackRefactorsCommandOutput,
} from "./commands/ListStackRefactorsCommand";
import {
  ListStackResourcesCommandInput,
  ListStackResourcesCommandOutput,
} from "./commands/ListStackResourcesCommand";
import {
  ListStacksCommandInput,
  ListStacksCommandOutput,
} from "./commands/ListStacksCommand";
import {
  ListStackSetAutoDeploymentTargetsCommandInput,
  ListStackSetAutoDeploymentTargetsCommandOutput,
} from "./commands/ListStackSetAutoDeploymentTargetsCommand";
import {
  ListStackSetOperationResultsCommandInput,
  ListStackSetOperationResultsCommandOutput,
} from "./commands/ListStackSetOperationResultsCommand";
import {
  ListStackSetOperationsCommandInput,
  ListStackSetOperationsCommandOutput,
} from "./commands/ListStackSetOperationsCommand";
import {
  ListStackSetsCommandInput,
  ListStackSetsCommandOutput,
} from "./commands/ListStackSetsCommand";
import {
  ListTypeRegistrationsCommandInput,
  ListTypeRegistrationsCommandOutput,
} from "./commands/ListTypeRegistrationsCommand";
import {
  ListTypesCommandInput,
  ListTypesCommandOutput,
} from "./commands/ListTypesCommand";
import {
  ListTypeVersionsCommandInput,
  ListTypeVersionsCommandOutput,
} from "./commands/ListTypeVersionsCommand";
import {
  PublishTypeCommandInput,
  PublishTypeCommandOutput,
} from "./commands/PublishTypeCommand";
import {
  RecordHandlerProgressCommandInput,
  RecordHandlerProgressCommandOutput,
} from "./commands/RecordHandlerProgressCommand";
import {
  RegisterPublisherCommandInput,
  RegisterPublisherCommandOutput,
} from "./commands/RegisterPublisherCommand";
import {
  RegisterTypeCommandInput,
  RegisterTypeCommandOutput,
} from "./commands/RegisterTypeCommand";
import {
  RollbackStackCommandInput,
  RollbackStackCommandOutput,
} from "./commands/RollbackStackCommand";
import {
  SetStackPolicyCommandInput,
  SetStackPolicyCommandOutput,
} from "./commands/SetStackPolicyCommand";
import {
  SetTypeConfigurationCommandInput,
  SetTypeConfigurationCommandOutput,
} from "./commands/SetTypeConfigurationCommand";
import {
  SetTypeDefaultVersionCommandInput,
  SetTypeDefaultVersionCommandOutput,
} from "./commands/SetTypeDefaultVersionCommand";
import {
  SignalResourceCommandInput,
  SignalResourceCommandOutput,
} from "./commands/SignalResourceCommand";
import {
  StartResourceScanCommandInput,
  StartResourceScanCommandOutput,
} from "./commands/StartResourceScanCommand";
import {
  StopStackSetOperationCommandInput,
  StopStackSetOperationCommandOutput,
} from "./commands/StopStackSetOperationCommand";
import {
  TestTypeCommandInput,
  TestTypeCommandOutput,
} from "./commands/TestTypeCommand";
import {
  UpdateGeneratedTemplateCommandInput,
  UpdateGeneratedTemplateCommandOutput,
} from "./commands/UpdateGeneratedTemplateCommand";
import {
  UpdateStackCommandInput,
  UpdateStackCommandOutput,
} from "./commands/UpdateStackCommand";
import {
  UpdateStackInstancesCommandInput,
  UpdateStackInstancesCommandOutput,
} from "./commands/UpdateStackInstancesCommand";
import {
  UpdateStackSetCommandInput,
  UpdateStackSetCommandOutput,
} from "./commands/UpdateStackSetCommand";
import {
  UpdateTerminationProtectionCommandInput,
  UpdateTerminationProtectionCommandOutput,
} from "./commands/UpdateTerminationProtectionCommand";
import {
  ValidateTemplateCommandInput,
  ValidateTemplateCommandOutput,
} from "./commands/ValidateTemplateCommand";
import {
  ClientInputEndpointParameters,
  ClientResolvedEndpointParameters,
  EndpointParameters,
} from "./endpoint/EndpointParameters";
import { RuntimeExtension, RuntimeExtensionsConfig } from "./runtimeExtensions";
export { __Client };
export type ServiceInputTypes =
  | ActivateOrganizationsAccessCommandInput
  | ActivateTypeCommandInput
  | BatchDescribeTypeConfigurationsCommandInput
  | CancelUpdateStackCommandInput
  | ContinueUpdateRollbackCommandInput
  | CreateChangeSetCommandInput
  | CreateGeneratedTemplateCommandInput
  | CreateStackCommandInput
  | CreateStackInstancesCommandInput
  | CreateStackRefactorCommandInput
  | CreateStackSetCommandInput
  | DeactivateOrganizationsAccessCommandInput
  | DeactivateTypeCommandInput
  | DeleteChangeSetCommandInput
  | DeleteGeneratedTemplateCommandInput
  | DeleteStackCommandInput
  | DeleteStackInstancesCommandInput
  | DeleteStackSetCommandInput
  | DeregisterTypeCommandInput
  | DescribeAccountLimitsCommandInput
  | DescribeChangeSetCommandInput
  | DescribeChangeSetHooksCommandInput
  | DescribeGeneratedTemplateCommandInput
  | DescribeOrganizationsAccessCommandInput
  | DescribePublisherCommandInput
  | DescribeResourceScanCommandInput
  | DescribeStackDriftDetectionStatusCommandInput
  | DescribeStackEventsCommandInput
  | DescribeStackInstanceCommandInput
  | DescribeStackRefactorCommandInput
  | DescribeStackResourceCommandInput
  | DescribeStackResourceDriftsCommandInput
  | DescribeStackResourcesCommandInput
  | DescribeStackSetCommandInput
  | DescribeStackSetOperationCommandInput
  | DescribeStacksCommandInput
  | DescribeTypeCommandInput
  | DescribeTypeRegistrationCommandInput
  | DetectStackDriftCommandInput
  | DetectStackResourceDriftCommandInput
  | DetectStackSetDriftCommandInput
  | EstimateTemplateCostCommandInput
  | ExecuteChangeSetCommandInput
  | ExecuteStackRefactorCommandInput
  | GetGeneratedTemplateCommandInput
  | GetStackPolicyCommandInput
  | GetTemplateCommandInput
  | GetTemplateSummaryCommandInput
  | ImportStacksToStackSetCommandInput
  | ListChangeSetsCommandInput
  | ListExportsCommandInput
  | ListGeneratedTemplatesCommandInput
  | ListHookResultsCommandInput
  | ListImportsCommandInput
  | ListResourceScanRelatedResourcesCommandInput
  | ListResourceScanResourcesCommandInput
  | ListResourceScansCommandInput
  | ListStackInstanceResourceDriftsCommandInput
  | ListStackInstancesCommandInput
  | ListStackRefactorActionsCommandInput
  | ListStackRefactorsCommandInput
  | ListStackResourcesCommandInput
  | ListStackSetAutoDeploymentTargetsCommandInput
  | ListStackSetOperationResultsCommandInput
  | ListStackSetOperationsCommandInput
  | ListStackSetsCommandInput
  | ListStacksCommandInput
  | ListTypeRegistrationsCommandInput
  | ListTypeVersionsCommandInput
  | ListTypesCommandInput
  | PublishTypeCommandInput
  | RecordHandlerProgressCommandInput
  | RegisterPublisherCommandInput
  | RegisterTypeCommandInput
  | RollbackStackCommandInput
  | SetStackPolicyCommandInput
  | SetTypeConfigurationCommandInput
  | SetTypeDefaultVersionCommandInput
  | SignalResourceCommandInput
  | StartResourceScanCommandInput
  | StopStackSetOperationCommandInput
  | TestTypeCommandInput
  | UpdateGeneratedTemplateCommandInput
  | UpdateStackCommandInput
  | UpdateStackInstancesCommandInput
  | UpdateStackSetCommandInput
  | UpdateTerminationProtectionCommandInput
  | ValidateTemplateCommandInput;
export type ServiceOutputTypes =
  | ActivateOrganizationsAccessCommandOutput
  | ActivateTypeCommandOutput
  | BatchDescribeTypeConfigurationsCommandOutput
  | CancelUpdateStackCommandOutput
  | ContinueUpdateRollbackCommandOutput
  | CreateChangeSetCommandOutput
  | CreateGeneratedTemplateCommandOutput
  | CreateStackCommandOutput
  | CreateStackInstancesCommandOutput
  | CreateStackRefactorCommandOutput
  | CreateStackSetCommandOutput
  | DeactivateOrganizationsAccessCommandOutput
  | DeactivateTypeCommandOutput
  | DeleteChangeSetCommandOutput
  | DeleteGeneratedTemplateCommandOutput
  | DeleteStackCommandOutput
  | DeleteStackInstancesCommandOutput
  | DeleteStackSetCommandOutput
  | DeregisterTypeCommandOutput
  | DescribeAccountLimitsCommandOutput
  | DescribeChangeSetCommandOutput
  | DescribeChangeSetHooksCommandOutput
  | DescribeGeneratedTemplateCommandOutput
  | DescribeOrganizationsAccessCommandOutput
  | DescribePublisherCommandOutput
  | DescribeResourceScanCommandOutput
  | DescribeStackDriftDetectionStatusCommandOutput
  | DescribeStackEventsCommandOutput
  | DescribeStackInstanceCommandOutput
  | DescribeStackRefactorCommandOutput
  | DescribeStackResourceCommandOutput
  | DescribeStackResourceDriftsCommandOutput
  | DescribeStackResourcesCommandOutput
  | DescribeStackSetCommandOutput
  | DescribeStackSetOperationCommandOutput
  | DescribeStacksCommandOutput
  | DescribeTypeCommandOutput
  | DescribeTypeRegistrationCommandOutput
  | DetectStackDriftCommandOutput
  | DetectStackResourceDriftCommandOutput
  | DetectStackSetDriftCommandOutput
  | EstimateTemplateCostCommandOutput
  | ExecuteChangeSetCommandOutput
  | ExecuteStackRefactorCommandOutput
  | GetGeneratedTemplateCommandOutput
  | GetStackPolicyCommandOutput
  | GetTemplateCommandOutput
  | GetTemplateSummaryCommandOutput
  | ImportStacksToStackSetCommandOutput
  | ListChangeSetsCommandOutput
  | ListExportsCommandOutput
  | ListGeneratedTemplatesCommandOutput
  | ListHookResultsCommandOutput
  | ListImportsCommandOutput
  | ListResourceScanRelatedResourcesCommandOutput
  | ListResourceScanResourcesCommandOutput
  | ListResourceScansCommandOutput
  | ListStackInstanceResourceDriftsCommandOutput
  | ListStackInstancesCommandOutput
  | ListStackRefactorActionsCommandOutput
  | ListStackRefactorsCommandOutput
  | ListStackResourcesCommandOutput
  | ListStackSetAutoDeploymentTargetsCommandOutput
  | ListStackSetOperationResultsCommandOutput
  | ListStackSetOperationsCommandOutput
  | ListStackSetsCommandOutput
  | ListStacksCommandOutput
  | ListTypeRegistrationsCommandOutput
  | ListTypeVersionsCommandOutput
  | ListTypesCommandOutput
  | PublishTypeCommandOutput
  | RecordHandlerProgressCommandOutput
  | RegisterPublisherCommandOutput
  | RegisterTypeCommandOutput
  | RollbackStackCommandOutput
  | SetStackPolicyCommandOutput
  | SetTypeConfigurationCommandOutput
  | SetTypeDefaultVersionCommandOutput
  | SignalResourceCommandOutput
  | StartResourceScanCommandOutput
  | StopStackSetOperationCommandOutput
  | TestTypeCommandOutput
  | UpdateGeneratedTemplateCommandOutput
  | UpdateStackCommandOutput
  | UpdateStackInstancesCommandOutput
  | UpdateStackSetCommandOutput
  | UpdateTerminationProtectionCommandOutput
  | ValidateTemplateCommandOutput;
export interface ClientDefaults
  extends Partial<__SmithyConfiguration<__HttpHandlerOptions>> {
  requestHandler?: __HttpHandlerUserInput;
  sha256?: __ChecksumConstructor | __HashConstructor;
  urlParser?: __UrlParser;
  bodyLengthChecker?: __BodyLengthCalculator;
  streamCollector?: __StreamCollector;
  base64Decoder?: __Decoder;
  base64Encoder?: __Encoder;
  utf8Decoder?: __Decoder;
  utf8Encoder?: __Encoder;
  runtime?: string;
  disableHostPrefix?: boolean;
  serviceId?: string;
  useDualstackEndpoint?: boolean | __Provider<boolean>;
  useFipsEndpoint?: boolean | __Provider<boolean>;
  region?: string | __Provider<string>;
  profile?: string;
  defaultUserAgentProvider?: Provider<__UserAgent>;
  credentialDefaultProvider?: (input: any) => AwsCredentialIdentityProvider;
  maxAttempts?: number | __Provider<number>;
  retryMode?: string | __Provider<string>;
  logger?: __Logger;
  extensions?: RuntimeExtension[];
  defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
export type CloudFormationClientConfigType = Partial<
  __SmithyConfiguration<__HttpHandlerOptions>
> &
  ClientDefaults &
  UserAgentInputConfig &
  RetryInputConfig &
  RegionInputConfig &
  HostHeaderInputConfig &
  EndpointInputConfig<EndpointParameters> &
  HttpAuthSchemeInputConfig &
  ClientInputEndpointParameters;
export interface CloudFormationClientConfig
  extends CloudFormationClientConfigType {}
export type CloudFormationClientResolvedConfigType =
  __SmithyResolvedConfiguration<__HttpHandlerOptions> &
    Required<ClientDefaults> &
    RuntimeExtensionsConfig &
    UserAgentResolvedConfig &
    RetryResolvedConfig &
    RegionResolvedConfig &
    HostHeaderResolvedConfig &
    EndpointResolvedConfig<EndpointParameters> &
    HttpAuthSchemeResolvedConfig &
    ClientResolvedEndpointParameters;
export interface CloudFormationClientResolvedConfig
  extends CloudFormationClientResolvedConfigType {}
export declare class CloudFormationClient extends __Client<
  __HttpHandlerOptions,
  ServiceInputTypes,
  ServiceOutputTypes,
  CloudFormationClientResolvedConfig
> {
  readonly config: CloudFormationClientResolvedConfig;
  constructor(
    ...[configuration]: __CheckOptionalClientConfig<CloudFormationClientConfig>
  );
  destroy(): void;
}
