import {
  AwsSdkSigV4AuthInputConfig,
  AwsSdkSigV4AuthResolvedConfig,
  AwsSdkSigV4PreviouslyResolved,
} from "@aws-sdk/core";
import {
  HandlerExecutionContext,
  HttpAuthScheme,
  HttpAuthSchemeParameters,
  HttpAuthSchemeParametersProvider,
  HttpAuthSchemeProvider,
  Provider,
} from "@smithy/types";
import { CloudFormationClientResolvedConfig } from "../CloudFormationClient";
export interface CloudFormationHttpAuthSchemeParameters
  extends HttpAuthSchemeParameters {
  region?: string;
}
export interface CloudFormationHttpAuthSchemeParametersProvider
  extends HttpAuthSchemeParametersProvider<
    CloudFormationClientResolvedConfig,
    HandlerExecutionContext,
    CloudFormationHttpAuthSchemeParameters,
    object
  > {}
export declare const defaultCloudFormationHttpAuthSchemeParametersProvider: (
  config: CloudFormationClientResolvedConfig,
  context: HandlerExecutionContext,
  input: object
) => Promise<CloudFormationHttpAuthSchemeParameters>;
export interface CloudFormationHttpAuthSchemeProvider
  extends HttpAuthSchemeProvider<CloudFormationHttpAuthSchemeParameters> {}
export declare const defaultCloudFormationHttpAuthSchemeProvider: CloudFormationHttpAuthSchemeProvider;
export interface HttpAuthSchemeInputConfig extends AwsSdkSigV4AuthInputConfig {
  authSchemePreference?: string[] | Provider<string[]>;
  httpAuthSchemes?: HttpAuthScheme[];
  httpAuthSchemeProvider?: CloudFormationHttpAuthSchemeProvider;
}
export interface HttpAuthSchemeResolvedConfig
  extends AwsSdkSigV4AuthResolvedConfig {
  readonly authSchemePreference: Provider<string[]>;
  readonly httpAuthSchemes: HttpAuthScheme[];
  readonly httpAuthSchemeProvider: CloudFormationHttpAuthSchemeProvider;
}
export declare const resolveHttpAuthSchemeConfig: <T>(
  config: T & HttpAuthSchemeInputConfig & AwsSdkSigV4PreviouslyResolved
) => T & HttpAuthSchemeResolvedConfig;
