import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CloudFormationServiceException as __BaseException } from "./CloudFormationServiceException";
export declare const AccountFilterType: {
  readonly DIFFERENCE: "DIFFERENCE";
  readonly INTERSECTION: "INTERSECTION";
  readonly NONE: "NONE";
  readonly UNION: "UNION";
};
export type AccountFilterType =
  (typeof AccountFilterType)[keyof typeof AccountFilterType];
export declare const AccountGateStatus: {
  readonly FAILED: "FAILED";
  readonly SKIPPED: "SKIPPED";
  readonly SUCCEEDED: "SUCCEEDED";
};
export type AccountGateStatus =
  (typeof AccountGateStatus)[keyof typeof AccountGateStatus];
export interface AccountGateResult {
  Status?: AccountGateStatus | undefined;
  StatusReason?: string | undefined;
}
export interface AccountLimit {
  Name?: string | undefined;
  Value?: number | undefined;
}
export interface ActivateOrganizationsAccessInput {}
export interface ActivateOrganizationsAccessOutput {}
export declare class InvalidOperationException extends __BaseException {
  readonly name: "InvalidOperationException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<InvalidOperationException, __BaseException>
  );
}
export declare class OperationNotFoundException extends __BaseException {
  readonly name: "OperationNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<OperationNotFoundException, __BaseException>
  );
}
export interface LoggingConfig {
  LogRoleArn: string | undefined;
  LogGroupName: string | undefined;
}
export declare const ThirdPartyType: {
  readonly HOOK: "HOOK";
  readonly MODULE: "MODULE";
  readonly RESOURCE: "RESOURCE";
};
export type ThirdPartyType =
  (typeof ThirdPartyType)[keyof typeof ThirdPartyType];
export declare const VersionBump: {
  readonly MAJOR: "MAJOR";
  readonly MINOR: "MINOR";
};
export type VersionBump = (typeof VersionBump)[keyof typeof VersionBump];
export interface ActivateTypeInput {
  Type?: ThirdPartyType | undefined;
  PublicTypeArn?: string | undefined;
  PublisherId?: string | undefined;
  TypeName?: string | undefined;
  TypeNameAlias?: string | undefined;
  AutoUpdate?: boolean | undefined;
  LoggingConfig?: LoggingConfig | undefined;
  ExecutionRoleArn?: string | undefined;
  VersionBump?: VersionBump | undefined;
  MajorVersion?: number | undefined;
}
export interface ActivateTypeOutput {
  Arn?: string | undefined;
}
export declare class CFNRegistryException extends __BaseException {
  readonly name: "CFNRegistryException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<CFNRegistryException, __BaseException>
  );
}
export declare class TypeNotFoundException extends __BaseException {
  readonly name: "TypeNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TypeNotFoundException, __BaseException>
  );
}
export declare class AlreadyExistsException extends __BaseException {
  readonly name: "AlreadyExistsException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<AlreadyExistsException, __BaseException>
  );
}
export declare const AttributeChangeType: {
  readonly Add: "Add";
  readonly Modify: "Modify";
  readonly Remove: "Remove";
};
export type AttributeChangeType =
  (typeof AttributeChangeType)[keyof typeof AttributeChangeType];
export interface AutoDeployment {
  Enabled?: boolean | undefined;
  RetainStacksOnAccountRemoval?: boolean | undefined;
}
export interface TypeConfigurationIdentifier {
  TypeArn?: string | undefined;
  TypeConfigurationAlias?: string | undefined;
  TypeConfigurationArn?: string | undefined;
  Type?: ThirdPartyType | undefined;
  TypeName?: string | undefined;
}
export interface BatchDescribeTypeConfigurationsInput {
  TypeConfigurationIdentifiers: TypeConfigurationIdentifier[] | undefined;
}
export interface BatchDescribeTypeConfigurationsError {
  ErrorCode?: string | undefined;
  ErrorMessage?: string | undefined;
  TypeConfigurationIdentifier?: TypeConfigurationIdentifier | undefined;
}
export interface TypeConfigurationDetails {
  Arn?: string | undefined;
  Alias?: string | undefined;
  Configuration?: string | undefined;
  LastUpdated?: Date | undefined;
  TypeArn?: string | undefined;
  TypeName?: string | undefined;
  IsDefaultConfiguration?: boolean | undefined;
}
export interface BatchDescribeTypeConfigurationsOutput {
  Errors?: BatchDescribeTypeConfigurationsError[] | undefined;
  UnprocessedTypeConfigurations?: TypeConfigurationIdentifier[] | undefined;
  TypeConfigurations?: TypeConfigurationDetails[] | undefined;
}
export declare class TypeConfigurationNotFoundException extends __BaseException {
  readonly name: "TypeConfigurationNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      TypeConfigurationNotFoundException,
      __BaseException
    >
  );
}
export declare const CallAs: {
  readonly DELEGATED_ADMIN: "DELEGATED_ADMIN";
  readonly SELF: "SELF";
};
export type CallAs = (typeof CallAs)[keyof typeof CallAs];
export interface CancelUpdateStackInput {
  StackName: string | undefined;
  ClientRequestToken?: string | undefined;
}
export declare class TokenAlreadyExistsException extends __BaseException {
  readonly name: "TokenAlreadyExistsException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<TokenAlreadyExistsException, __BaseException>
  );
}
export declare const Capability: {
  readonly CAPABILITY_AUTO_EXPAND: "CAPABILITY_AUTO_EXPAND";
  readonly CAPABILITY_IAM: "CAPABILITY_IAM";
  readonly CAPABILITY_NAMED_IAM: "CAPABILITY_NAMED_IAM";
};
export type Capability = (typeof Capability)[keyof typeof Capability];
export declare const Category: {
  readonly ACTIVATED: "ACTIVATED";
  readonly AWS_TYPES: "AWS_TYPES";
  readonly REGISTERED: "REGISTERED";
  readonly THIRD_PARTY: "THIRD_PARTY";
};
export type Category = (typeof Category)[keyof typeof Category];
export declare const ChangeAction: {
  readonly Add: "Add";
  readonly Dynamic: "Dynamic";
  readonly Import: "Import";
  readonly Modify: "Modify";
  readonly Remove: "Remove";
};
export type ChangeAction = (typeof ChangeAction)[keyof typeof ChangeAction];
export declare const ChangeSource: {
  readonly Automatic: "Automatic";
  readonly DirectModification: "DirectModification";
  readonly ParameterReference: "ParameterReference";
  readonly ResourceAttribute: "ResourceAttribute";
  readonly ResourceReference: "ResourceReference";
};
export type ChangeSource = (typeof ChangeSource)[keyof typeof ChangeSource];
export declare const EvaluationType: {
  readonly Dynamic: "Dynamic";
  readonly Static: "Static";
};
export type EvaluationType =
  (typeof EvaluationType)[keyof typeof EvaluationType];
export declare const ResourceAttribute: {
  readonly CreationPolicy: "CreationPolicy";
  readonly DeletionPolicy: "DeletionPolicy";
  readonly Metadata: "Metadata";
  readonly Properties: "Properties";
  readonly Tags: "Tags";
  readonly UpdatePolicy: "UpdatePolicy";
  readonly UpdateReplacePolicy: "UpdateReplacePolicy";
};
export type ResourceAttribute =
  (typeof ResourceAttribute)[keyof typeof ResourceAttribute];
export declare const RequiresRecreation: {
  readonly Always: "Always";
  readonly Conditionally: "Conditionally";
  readonly Never: "Never";
};
export type RequiresRecreation =
  (typeof RequiresRecreation)[keyof typeof RequiresRecreation];
export interface ResourceTargetDefinition {
  Attribute?: ResourceAttribute | undefined;
  Name?: string | undefined;
  RequiresRecreation?: RequiresRecreation | undefined;
  Path?: string | undefined;
  BeforeValue?: string | undefined;
  AfterValue?: string | undefined;
  AttributeChangeType?: AttributeChangeType | undefined;
}
export interface ResourceChangeDetail {
  Target?: ResourceTargetDefinition | undefined;
  Evaluation?: EvaluationType | undefined;
  ChangeSource?: ChangeSource | undefined;
  CausingEntity?: string | undefined;
}
export interface ModuleInfo {
  TypeHierarchy?: string | undefined;
  LogicalIdHierarchy?: string | undefined;
}
export declare const PolicyAction: {
  readonly Delete: "Delete";
  readonly ReplaceAndDelete: "ReplaceAndDelete";
  readonly ReplaceAndRetain: "ReplaceAndRetain";
  readonly ReplaceAndSnapshot: "ReplaceAndSnapshot";
  readonly Retain: "Retain";
  readonly Snapshot: "Snapshot";
};
export type PolicyAction = (typeof PolicyAction)[keyof typeof PolicyAction];
export declare const Replacement: {
  readonly Conditional: "Conditional";
  readonly False: "False";
  readonly True: "True";
};
export type Replacement = (typeof Replacement)[keyof typeof Replacement];
export interface ResourceChange {
  PolicyAction?: PolicyAction | undefined;
  Action?: ChangeAction | undefined;
  LogicalResourceId?: string | undefined;
  PhysicalResourceId?: string | undefined;
  ResourceType?: string | undefined;
  Replacement?: Replacement | undefined;
  Scope?: ResourceAttribute[] | undefined;
  Details?: ResourceChangeDetail[] | undefined;
  ChangeSetId?: string | undefined;
  ModuleInfo?: ModuleInfo | undefined;
  BeforeContext?: string | undefined;
  AfterContext?: string | undefined;
}
export declare const ChangeType: {
  readonly Resource: "Resource";
};
export type ChangeType = (typeof ChangeType)[keyof typeof ChangeType];
export interface Change {
  Type?: ChangeType | undefined;
  HookInvocationCount?: number | undefined;
  ResourceChange?: ResourceChange | undefined;
}
export declare const HookFailureMode: {
  readonly FAIL: "FAIL";
  readonly WARN: "WARN";
};
export type HookFailureMode =
  (typeof HookFailureMode)[keyof typeof HookFailureMode];
export declare const HookInvocationPoint: {
  readonly PRE_PROVISION: "PRE_PROVISION";
};
export type HookInvocationPoint =
  (typeof HookInvocationPoint)[keyof typeof HookInvocationPoint];
export interface ChangeSetHookResourceTargetDetails {
  LogicalResourceId?: string | undefined;
  ResourceType?: string | undefined;
  ResourceAction?: ChangeAction | undefined;
}
export declare const HookTargetType: {
  readonly RESOURCE: "RESOURCE";
};
export type HookTargetType =
  (typeof HookTargetType)[keyof typeof HookTargetType];
export interface ChangeSetHookTargetDetails {
  TargetType?: HookTargetType | undefined;
  ResourceTargetDetails?: ChangeSetHookResourceTargetDetails | undefined;
}
export interface ChangeSetHook {
  InvocationPoint?: HookInvocationPoint | undefined;
  FailureMode?: HookFailureMode | undefined;
  TypeName?: string | undefined;
  TypeVersionId?: string | undefined;
  TypeConfigurationVersionId?: string | undefined;
  TargetDetails?: ChangeSetHookTargetDetails | undefined;
}
export declare const ChangeSetHooksStatus: {
  readonly PLANNED: "PLANNED";
  readonly PLANNING: "PLANNING";
  readonly UNAVAILABLE: "UNAVAILABLE";
};
export type ChangeSetHooksStatus =
  (typeof ChangeSetHooksStatus)[keyof typeof ChangeSetHooksStatus];
export declare class ChangeSetNotFoundException extends __BaseException {
  readonly name: "ChangeSetNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<ChangeSetNotFoundException, __BaseException>
  );
}
export declare const ChangeSetStatus: {
  readonly CREATE_COMPLETE: "CREATE_COMPLETE";
  readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
  readonly CREATE_PENDING: "CREATE_PENDING";
  readonly DELETE_COMPLETE: "DELETE_COMPLETE";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
  readonly DELETE_PENDING: "DELETE_PENDING";
  readonly FAILED: "FAILED";
};
export type ChangeSetStatus =
  (typeof ChangeSetStatus)[keyof typeof ChangeSetStatus];
export declare const ExecutionStatus: {
  readonly AVAILABLE: "AVAILABLE";
  readonly EXECUTE_COMPLETE: "EXECUTE_COMPLETE";
  readonly EXECUTE_FAILED: "EXECUTE_FAILED";
  readonly EXECUTE_IN_PROGRESS: "EXECUTE_IN_PROGRESS";
  readonly OBSOLETE: "OBSOLETE";
  readonly UNAVAILABLE: "UNAVAILABLE";
};
export type ExecutionStatus =
  (typeof ExecutionStatus)[keyof typeof ExecutionStatus];
export interface ChangeSetSummary {
  StackId?: string | undefined;
  StackName?: string | undefined;
  ChangeSetId?: string | undefined;
  ChangeSetName?: string | undefined;
  ExecutionStatus?: ExecutionStatus | undefined;
  Status?: ChangeSetStatus | undefined;
  StatusReason?: string | undefined;
  CreationTime?: Date | undefined;
  Description?: string | undefined;
  IncludeNestedStacks?: boolean | undefined;
  ParentChangeSetId?: string | undefined;
  RootChangeSetId?: string | undefined;
  ImportExistingResources?: boolean | undefined;
}
export declare const ChangeSetType: {
  readonly CREATE: "CREATE";
  readonly IMPORT: "IMPORT";
  readonly UPDATE: "UPDATE";
};
export type ChangeSetType = (typeof ChangeSetType)[keyof typeof ChangeSetType];
export interface ContinueUpdateRollbackInput {
  StackName: string | undefined;
  RoleARN?: string | undefined;
  ResourcesToSkip?: string[] | undefined;
  ClientRequestToken?: string | undefined;
}
export interface ContinueUpdateRollbackOutput {}
export declare const OnStackFailure: {
  readonly DELETE: "DELETE";
  readonly DO_NOTHING: "DO_NOTHING";
  readonly ROLLBACK: "ROLLBACK";
};
export type OnStackFailure =
  (typeof OnStackFailure)[keyof typeof OnStackFailure];
export interface Parameter {
  ParameterKey?: string | undefined;
  ParameterValue?: string | undefined;
  UsePreviousValue?: boolean | undefined;
  ResolvedValue?: string | undefined;
}
export interface ResourceToImport {
  ResourceType: string | undefined;
  LogicalResourceId: string | undefined;
  ResourceIdentifier: Record<string, string> | undefined;
}
export interface RollbackTrigger {
  Arn: string | undefined;
  Type: string | undefined;
}
export interface RollbackConfiguration {
  RollbackTriggers?: RollbackTrigger[] | undefined;
  MonitoringTimeInMinutes?: number | undefined;
}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateChangeSetInput {
  StackName: string | undefined;
  TemplateBody?: string | undefined;
  TemplateURL?: string | undefined;
  UsePreviousTemplate?: boolean | undefined;
  Parameters?: Parameter[] | undefined;
  Capabilities?: Capability[] | undefined;
  ResourceTypes?: string[] | undefined;
  RoleARN?: string | undefined;
  RollbackConfiguration?: RollbackConfiguration | undefined;
  NotificationARNs?: string[] | undefined;
  Tags?: Tag[] | undefined;
  ChangeSetName: string | undefined;
  ClientToken?: string | undefined;
  Description?: string | undefined;
  ChangeSetType?: ChangeSetType | undefined;
  ResourcesToImport?: ResourceToImport[] | undefined;
  IncludeNestedStacks?: boolean | undefined;
  OnStackFailure?: OnStackFailure | undefined;
  ImportExistingResources?: boolean | undefined;
}
export interface CreateChangeSetOutput {
  Id?: string | undefined;
  StackId?: string | undefined;
}
export declare class InsufficientCapabilitiesException extends __BaseException {
  readonly name: "InsufficientCapabilitiesException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      InsufficientCapabilitiesException,
      __BaseException
    >
  );
}
export declare class LimitExceededException extends __BaseException {
  readonly name: "LimitExceededException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<LimitExceededException, __BaseException>
  );
}
export declare class ConcurrentResourcesLimitExceededException extends __BaseException {
  readonly name: "ConcurrentResourcesLimitExceededException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      ConcurrentResourcesLimitExceededException,
      __BaseException
    >
  );
}
export interface ResourceDefinition {
  ResourceType: string | undefined;
  LogicalResourceId?: string | undefined;
  ResourceIdentifier: Record<string, string> | undefined;
}
export declare const GeneratedTemplateDeletionPolicy: {
  readonly DELETE: "DELETE";
  readonly RETAIN: "RETAIN";
};
export type GeneratedTemplateDeletionPolicy =
  (typeof GeneratedTemplateDeletionPolicy)[keyof typeof GeneratedTemplateDeletionPolicy];
export declare const GeneratedTemplateUpdateReplacePolicy: {
  readonly DELETE: "DELETE";
  readonly RETAIN: "RETAIN";
};
export type GeneratedTemplateUpdateReplacePolicy =
  (typeof GeneratedTemplateUpdateReplacePolicy)[keyof typeof GeneratedTemplateUpdateReplacePolicy];
export interface TemplateConfiguration {
  DeletionPolicy?: GeneratedTemplateDeletionPolicy | undefined;
  UpdateReplacePolicy?: GeneratedTemplateUpdateReplacePolicy | undefined;
}
export interface CreateGeneratedTemplateInput {
  Resources?: ResourceDefinition[] | undefined;
  GeneratedTemplateName: string | undefined;
  StackName?: string | undefined;
  TemplateConfiguration?: TemplateConfiguration | undefined;
}
export interface CreateGeneratedTemplateOutput {
  GeneratedTemplateId?: string | undefined;
}
export declare const OnFailure: {
  readonly DELETE: "DELETE";
  readonly DO_NOTHING: "DO_NOTHING";
  readonly ROLLBACK: "ROLLBACK";
};
export type OnFailure = (typeof OnFailure)[keyof typeof OnFailure];
export interface CreateStackInput {
  StackName: string | undefined;
  TemplateBody?: string | undefined;
  TemplateURL?: string | undefined;
  Parameters?: Parameter[] | undefined;
  DisableRollback?: boolean | undefined;
  RollbackConfiguration?: RollbackConfiguration | undefined;
  TimeoutInMinutes?: number | undefined;
  NotificationARNs?: string[] | undefined;
  Capabilities?: Capability[] | undefined;
  ResourceTypes?: string[] | undefined;
  RoleARN?: string | undefined;
  OnFailure?: OnFailure | undefined;
  StackPolicyBody?: string | undefined;
  StackPolicyURL?: string | undefined;
  Tags?: Tag[] | undefined;
  ClientRequestToken?: string | undefined;
  EnableTerminationProtection?: boolean | undefined;
  RetainExceptOnCreate?: boolean | undefined;
}
export interface CreateStackOutput {
  StackId?: string | undefined;
}
export interface DeploymentTargets {
  Accounts?: string[] | undefined;
  AccountsUrl?: string | undefined;
  OrganizationalUnitIds?: string[] | undefined;
  AccountFilterType?: AccountFilterType | undefined;
}
export declare const ConcurrencyMode: {
  readonly SOFT_FAILURE_TOLERANCE: "SOFT_FAILURE_TOLERANCE";
  readonly STRICT_FAILURE_TOLERANCE: "STRICT_FAILURE_TOLERANCE";
};
export type ConcurrencyMode =
  (typeof ConcurrencyMode)[keyof typeof ConcurrencyMode];
export declare const RegionConcurrencyType: {
  readonly PARALLEL: "PARALLEL";
  readonly SEQUENTIAL: "SEQUENTIAL";
};
export type RegionConcurrencyType =
  (typeof RegionConcurrencyType)[keyof typeof RegionConcurrencyType];
export interface StackSetOperationPreferences {
  RegionConcurrencyType?: RegionConcurrencyType | undefined;
  RegionOrder?: string[] | undefined;
  FailureToleranceCount?: number | undefined;
  FailureTolerancePercentage?: number | undefined;
  MaxConcurrentCount?: number | undefined;
  MaxConcurrentPercentage?: number | undefined;
  ConcurrencyMode?: ConcurrencyMode | undefined;
}
export interface CreateStackInstancesInput {
  StackSetName: string | undefined;
  Accounts?: string[] | undefined;
  DeploymentTargets?: DeploymentTargets | undefined;
  Regions: string[] | undefined;
  ParameterOverrides?: Parameter[] | undefined;
  OperationPreferences?: StackSetOperationPreferences | undefined;
  OperationId?: string | undefined;
  CallAs?: CallAs | undefined;
}
export interface CreateStackInstancesOutput {
  OperationId?: string | undefined;
}
export declare class OperationIdAlreadyExistsException extends __BaseException {
  readonly name: "OperationIdAlreadyExistsException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      OperationIdAlreadyExistsException,
      __BaseException
    >
  );
}
export declare class OperationInProgressException extends __BaseException {
  readonly name: "OperationInProgressException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<OperationInProgressException, __BaseException>
  );
}
export declare class StackSetNotFoundException extends __BaseException {
  readonly name: "StackSetNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<StackSetNotFoundException, __BaseException>
  );
}
export declare class StaleRequestException extends __BaseException {
  readonly name: "StaleRequestException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<StaleRequestException, __BaseException>
  );
}
export interface ResourceLocation {
  StackName: string | undefined;
  LogicalResourceId: string | undefined;
}
export interface ResourceMapping {
  Source: ResourceLocation | undefined;
  Destination: ResourceLocation | undefined;
}
export interface StackDefinition {
  StackName?: string | undefined;
  TemplateBody?: string | undefined;
  TemplateURL?: string | undefined;
}
export interface CreateStackRefactorInput {
  Description?: string | undefined;
  EnableStackCreation?: boolean | undefined;
  ResourceMappings?: ResourceMapping[] | undefined;
  StackDefinitions: StackDefinition[] | undefined;
}
export interface CreateStackRefactorOutput {
  StackRefactorId: string | undefined;
}
export declare class CreatedButModifiedException extends __BaseException {
  readonly name: "CreatedButModifiedException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<CreatedButModifiedException, __BaseException>
  );
}
export interface ManagedExecution {
  Active?: boolean | undefined;
}
export declare const PermissionModels: {
  readonly SELF_MANAGED: "SELF_MANAGED";
  readonly SERVICE_MANAGED: "SERVICE_MANAGED";
};
export type PermissionModels =
  (typeof PermissionModels)[keyof typeof PermissionModels];
export interface CreateStackSetInput {
  StackSetName: string | undefined;
  Description?: string | undefined;
  TemplateBody?: string | undefined;
  TemplateURL?: string | undefined;
  StackId?: string | undefined;
  Parameters?: Parameter[] | undefined;
  Capabilities?: Capability[] | undefined;
  Tags?: Tag[] | undefined;
  AdministrationRoleARN?: string | undefined;
  ExecutionRoleName?: string | undefined;
  PermissionModel?: PermissionModels | undefined;
  AutoDeployment?: AutoDeployment | undefined;
  CallAs?: CallAs | undefined;
  ClientRequestToken?: string | undefined;
  ManagedExecution?: ManagedExecution | undefined;
}
export interface CreateStackSetOutput {
  StackSetId?: string | undefined;
}
export declare class NameAlreadyExistsException extends __BaseException {
  readonly name: "NameAlreadyExistsException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<NameAlreadyExistsException, __BaseException>
  );
}
export interface DeactivateOrganizationsAccessInput {}
export interface DeactivateOrganizationsAccessOutput {}
export interface DeactivateTypeInput {
  TypeName?: string | undefined;
  Type?: ThirdPartyType | undefined;
  Arn?: string | undefined;
}
export interface DeactivateTypeOutput {}
export interface DeleteChangeSetInput {
  ChangeSetName: string | undefined;
  StackName?: string | undefined;
}
export interface DeleteChangeSetOutput {}
export declare class InvalidChangeSetStatusException extends __BaseException {
  readonly name: "InvalidChangeSetStatusException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      InvalidChangeSetStatusException,
      __BaseException
    >
  );
}
export interface DeleteGeneratedTemplateInput {
  GeneratedTemplateName: string | undefined;
}
export declare class GeneratedTemplateNotFoundException extends __BaseException {
  readonly name: "GeneratedTemplateNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      GeneratedTemplateNotFoundException,
      __BaseException
    >
  );
}
export declare const DeletionMode: {
  readonly FORCE_DELETE_STACK: "FORCE_DELETE_STACK";
  readonly STANDARD: "STANDARD";
};
export type DeletionMode = (typeof DeletionMode)[keyof typeof DeletionMode];
export interface DeleteStackInput {
  StackName: string | undefined;
  RetainResources?: string[] | undefined;
  RoleARN?: string | undefined;
  ClientRequestToken?: string | undefined;
  DeletionMode?: DeletionMode | undefined;
}
export interface DeleteStackInstancesInput {
  StackSetName: string | undefined;
  Accounts?: string[] | undefined;
  DeploymentTargets?: DeploymentTargets | undefined;
  Regions: string[] | undefined;
  OperationPreferences?: StackSetOperationPreferences | undefined;
  RetainStacks: boolean | undefined;
  OperationId?: string | undefined;
  CallAs?: CallAs | undefined;
}
export interface DeleteStackInstancesOutput {
  OperationId?: string | undefined;
}
export interface DeleteStackSetInput {
  StackSetName: string | undefined;
  CallAs?: CallAs | undefined;
}
export interface DeleteStackSetOutput {}
export declare class StackSetNotEmptyException extends __BaseException {
  readonly name: "StackSetNotEmptyException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<StackSetNotEmptyException, __BaseException>
  );
}
export declare const RegistryType: {
  readonly HOOK: "HOOK";
  readonly MODULE: "MODULE";
  readonly RESOURCE: "RESOURCE";
};
export type RegistryType = (typeof RegistryType)[keyof typeof RegistryType];
export interface DeregisterTypeInput {
  Arn?: string | undefined;
  Type?: RegistryType | undefined;
  TypeName?: string | undefined;
  VersionId?: string | undefined;
}
export interface DeregisterTypeOutput {}
export interface DescribeAccountLimitsInput {
  NextToken?: string | undefined;
}
export interface DescribeAccountLimitsOutput {
  AccountLimits?: AccountLimit[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeChangeSetInput {
  ChangeSetName: string | undefined;
  StackName?: string | undefined;
  NextToken?: string | undefined;
  IncludePropertyValues?: boolean | undefined;
}
export interface DescribeChangeSetOutput {
  ChangeSetName?: string | undefined;
  ChangeSetId?: string | undefined;
  StackId?: string | undefined;
  StackName?: string | undefined;
  Description?: string | undefined;
  Parameters?: Parameter[] | undefined;
  CreationTime?: Date | undefined;
  ExecutionStatus?: ExecutionStatus | undefined;
  Status?: ChangeSetStatus | undefined;
  StatusReason?: string | undefined;
  NotificationARNs?: string[] | undefined;
  RollbackConfiguration?: RollbackConfiguration | undefined;
  Capabilities?: Capability[] | undefined;
  Tags?: Tag[] | undefined;
  Changes?: Change[] | undefined;
  NextToken?: string | undefined;
  IncludeNestedStacks?: boolean | undefined;
  ParentChangeSetId?: string | undefined;
  RootChangeSetId?: string | undefined;
  OnStackFailure?: OnStackFailure | undefined;
  ImportExistingResources?: boolean | undefined;
}
export interface DescribeChangeSetHooksInput {
  ChangeSetName: string | undefined;
  StackName?: string | undefined;
  NextToken?: string | undefined;
  LogicalResourceId?: string | undefined;
}
export interface DescribeChangeSetHooksOutput {
  ChangeSetId?: string | undefined;
  ChangeSetName?: string | undefined;
  Hooks?: ChangeSetHook[] | undefined;
  Status?: ChangeSetHooksStatus | undefined;
  NextToken?: string | undefined;
  StackId?: string | undefined;
  StackName?: string | undefined;
}
export interface DescribeGeneratedTemplateInput {
  GeneratedTemplateName: string | undefined;
}
export interface TemplateProgress {
  ResourcesSucceeded?: number | undefined;
  ResourcesFailed?: number | undefined;
  ResourcesProcessing?: number | undefined;
  ResourcesPending?: number | undefined;
}
export declare const GeneratedTemplateResourceStatus: {
  readonly COMPLETE: "COMPLETE";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
  readonly PENDING: "PENDING";
};
export type GeneratedTemplateResourceStatus =
  (typeof GeneratedTemplateResourceStatus)[keyof typeof GeneratedTemplateResourceStatus];
export interface WarningProperty {
  PropertyPath?: string | undefined;
  Required?: boolean | undefined;
  Description?: string | undefined;
}
export declare const WarningType: {
  readonly EXCLUDED_PROPERTIES: "EXCLUDED_PROPERTIES";
  readonly MUTUALLY_EXCLUSIVE_PROPERTIES: "MUTUALLY_EXCLUSIVE_PROPERTIES";
  readonly MUTUALLY_EXCLUSIVE_TYPES: "MUTUALLY_EXCLUSIVE_TYPES";
  readonly UNSUPPORTED_PROPERTIES: "UNSUPPORTED_PROPERTIES";
};
export type WarningType = (typeof WarningType)[keyof typeof WarningType];
export interface WarningDetail {
  Type?: WarningType | undefined;
  Properties?: WarningProperty[] | undefined;
}
export interface ResourceDetail {
  ResourceType?: string | undefined;
  LogicalResourceId?: string | undefined;
  ResourceIdentifier?: Record<string, string> | undefined;
  ResourceStatus?: GeneratedTemplateResourceStatus | undefined;
  ResourceStatusReason?: string | undefined;
  Warnings?: WarningDetail[] | undefined;
}
export declare const GeneratedTemplateStatus: {
  readonly COMPLETE: "COMPLETE";
  readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
  readonly CREATE_PENDING: "CREATE_PENDING";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
  readonly DELETE_PENDING: "DELETE_PENDING";
  readonly FAILED: "FAILED";
  readonly UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS";
  readonly UPDATE_PENDING: "UPDATE_PENDING";
};
export type GeneratedTemplateStatus =
  (typeof GeneratedTemplateStatus)[keyof typeof GeneratedTemplateStatus];
export interface DescribeGeneratedTemplateOutput {
  GeneratedTemplateId?: string | undefined;
  GeneratedTemplateName?: string | undefined;
  Resources?: ResourceDetail[] | undefined;
  Status?: GeneratedTemplateStatus | undefined;
  StatusReason?: string | undefined;
  CreationTime?: Date | undefined;
  LastUpdatedTime?: Date | undefined;
  Progress?: TemplateProgress | undefined;
  StackId?: string | undefined;
  TemplateConfiguration?: TemplateConfiguration | undefined;
  TotalWarnings?: number | undefined;
}
export interface DescribeOrganizationsAccessInput {
  CallAs?: CallAs | undefined;
}
export declare const OrganizationStatus: {
  readonly DISABLED: "DISABLED";
  readonly DISABLED_PERMANENTLY: "DISABLED_PERMANENTLY";
  readonly ENABLED: "ENABLED";
};
export type OrganizationStatus =
  (typeof OrganizationStatus)[keyof typeof OrganizationStatus];
export interface DescribeOrganizationsAccessOutput {
  Status?: OrganizationStatus | undefined;
}
export interface DescribePublisherInput {
  PublisherId?: string | undefined;
}
export declare const IdentityProvider: {
  readonly AWS_Marketplace: "AWS_Marketplace";
  readonly Bitbucket: "Bitbucket";
  readonly GitHub: "GitHub";
};
export type IdentityProvider =
  (typeof IdentityProvider)[keyof typeof IdentityProvider];
export declare const PublisherStatus: {
  readonly UNVERIFIED: "UNVERIFIED";
  readonly VERIFIED: "VERIFIED";
};
export type PublisherStatus =
  (typeof PublisherStatus)[keyof typeof PublisherStatus];
export interface DescribePublisherOutput {
  PublisherId?: string | undefined;
  PublisherStatus?: PublisherStatus | undefined;
  IdentityProvider?: IdentityProvider | undefined;
  PublisherProfile?: string | undefined;
}
export interface DescribeResourceScanInput {
  ResourceScanId: string | undefined;
}
export interface ScanFilter {
  Types?: string[] | undefined;
}
export declare const ResourceScanStatus: {
  readonly COMPLETE: "COMPLETE";
  readonly EXPIRED: "EXPIRED";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
};
export type ResourceScanStatus =
  (typeof ResourceScanStatus)[keyof typeof ResourceScanStatus];
export interface DescribeResourceScanOutput {
  ResourceScanId?: string | undefined;
  Status?: ResourceScanStatus | undefined;
  StatusReason?: string | undefined;
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  PercentageCompleted?: number | undefined;
  ResourceTypes?: string[] | undefined;
  ResourcesScanned?: number | undefined;
  ResourcesRead?: number | undefined;
  ScanFilters?: ScanFilter[] | undefined;
}
export declare class ResourceScanNotFoundException extends __BaseException {
  readonly name: "ResourceScanNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<ResourceScanNotFoundException, __BaseException>
  );
}
export interface DescribeStackDriftDetectionStatusInput {
  StackDriftDetectionId: string | undefined;
}
export declare const StackDriftDetectionStatus: {
  readonly DETECTION_COMPLETE: "DETECTION_COMPLETE";
  readonly DETECTION_FAILED: "DETECTION_FAILED";
  readonly DETECTION_IN_PROGRESS: "DETECTION_IN_PROGRESS";
};
export type StackDriftDetectionStatus =
  (typeof StackDriftDetectionStatus)[keyof typeof StackDriftDetectionStatus];
export declare const StackDriftStatus: {
  readonly DRIFTED: "DRIFTED";
  readonly IN_SYNC: "IN_SYNC";
  readonly NOT_CHECKED: "NOT_CHECKED";
  readonly UNKNOWN: "UNKNOWN";
};
export type StackDriftStatus =
  (typeof StackDriftStatus)[keyof typeof StackDriftStatus];
export interface DescribeStackDriftDetectionStatusOutput {
  StackId: string | undefined;
  StackDriftDetectionId: string | undefined;
  StackDriftStatus?: StackDriftStatus | undefined;
  DetectionStatus: StackDriftDetectionStatus | undefined;
  DetectionStatusReason?: string | undefined;
  DriftedStackResourceCount?: number | undefined;
  Timestamp: Date | undefined;
}
export interface DescribeStackEventsInput {
  StackName?: string | undefined;
  NextToken?: string | undefined;
}
export declare const DetailedStatus: {
  readonly CONFIGURATION_COMPLETE: "CONFIGURATION_COMPLETE";
  readonly VALIDATION_FAILED: "VALIDATION_FAILED";
};
export type DetailedStatus =
  (typeof DetailedStatus)[keyof typeof DetailedStatus];
export declare const HookStatus: {
  readonly HOOK_COMPLETE_FAILED: "HOOK_COMPLETE_FAILED";
  readonly HOOK_COMPLETE_SUCCEEDED: "HOOK_COMPLETE_SUCCEEDED";
  readonly HOOK_FAILED: "HOOK_FAILED";
  readonly HOOK_IN_PROGRESS: "HOOK_IN_PROGRESS";
};
export type HookStatus = (typeof HookStatus)[keyof typeof HookStatus];
export declare const ResourceStatus: {
  readonly CREATE_COMPLETE: "CREATE_COMPLETE";
  readonly CREATE_FAILED: "CREATE_FAILED";
  readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
  readonly DELETE_COMPLETE: "DELETE_COMPLETE";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
  readonly DELETE_SKIPPED: "DELETE_SKIPPED";
  readonly EXPORT_COMPLETE: "EXPORT_COMPLETE";
  readonly EXPORT_FAILED: "EXPORT_FAILED";
  readonly EXPORT_IN_PROGRESS: "EXPORT_IN_PROGRESS";
  readonly EXPORT_ROLLBACK_COMPLETE: "EXPORT_ROLLBACK_COMPLETE";
  readonly EXPORT_ROLLBACK_FAILED: "EXPORT_ROLLBACK_FAILED";
  readonly EXPORT_ROLLBACK_IN_PROGRESS: "EXPORT_ROLLBACK_IN_PROGRESS";
  readonly IMPORT_COMPLETE: "IMPORT_COMPLETE";
  readonly IMPORT_FAILED: "IMPORT_FAILED";
  readonly IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS";
  readonly IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE";
  readonly IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED";
  readonly IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS";
  readonly ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE";
  readonly ROLLBACK_FAILED: "ROLLBACK_FAILED";
  readonly ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS";
  readonly UPDATE_COMPLETE: "UPDATE_COMPLETE";
  readonly UPDATE_FAILED: "UPDATE_FAILED";
  readonly UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS";
  readonly UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE";
  readonly UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED";
  readonly UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS";
};
export type ResourceStatus =
  (typeof ResourceStatus)[keyof typeof ResourceStatus];
export interface StackEvent {
  StackId: string | undefined;
  EventId: string | undefined;
  StackName: string | undefined;
  LogicalResourceId?: string | undefined;
  PhysicalResourceId?: string | undefined;
  ResourceType?: string | undefined;
  Timestamp: Date | undefined;
  ResourceStatus?: ResourceStatus | undefined;
  ResourceStatusReason?: string | undefined;
  ResourceProperties?: string | undefined;
  ClientRequestToken?: string | undefined;
  HookType?: string | undefined;
  HookStatus?: HookStatus | undefined;
  HookStatusReason?: string | undefined;
  HookInvocationPoint?: HookInvocationPoint | undefined;
  HookFailureMode?: HookFailureMode | undefined;
  DetailedStatus?: DetailedStatus | undefined;
}
export interface DescribeStackEventsOutput {
  StackEvents?: StackEvent[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeStackInstanceInput {
  StackSetName: string | undefined;
  StackInstanceAccount: string | undefined;
  StackInstanceRegion: string | undefined;
  CallAs?: CallAs | undefined;
}
export declare const StackInstanceDetailedStatus: {
  readonly CANCELLED: "CANCELLED";
  readonly FAILED: "FAILED";
  readonly FAILED_IMPORT: "FAILED_IMPORT";
  readonly INOPERABLE: "INOPERABLE";
  readonly PENDING: "PENDING";
  readonly RUNNING: "RUNNING";
  readonly SKIPPED_SUSPENDED_ACCOUNT: "SKIPPED_SUSPENDED_ACCOUNT";
  readonly SUCCEEDED: "SUCCEEDED";
};
export type StackInstanceDetailedStatus =
  (typeof StackInstanceDetailedStatus)[keyof typeof StackInstanceDetailedStatus];
export interface StackInstanceComprehensiveStatus {
  DetailedStatus?: StackInstanceDetailedStatus | undefined;
}
export declare const StackInstanceStatus: {
  readonly CURRENT: "CURRENT";
  readonly INOPERABLE: "INOPERABLE";
  readonly OUTDATED: "OUTDATED";
};
export type StackInstanceStatus =
  (typeof StackInstanceStatus)[keyof typeof StackInstanceStatus];
export interface StackInstance {
  StackSetId?: string | undefined;
  Region?: string | undefined;
  Account?: string | undefined;
  StackId?: string | undefined;
  ParameterOverrides?: Parameter[] | undefined;
  Status?: StackInstanceStatus | undefined;
  StackInstanceStatus?: StackInstanceComprehensiveStatus | undefined;
  StatusReason?: string | undefined;
  OrganizationalUnitId?: string | undefined;
  DriftStatus?: StackDriftStatus | undefined;
  LastDriftCheckTimestamp?: Date | undefined;
  LastOperationId?: string | undefined;
}
export interface DescribeStackInstanceOutput {
  StackInstance?: StackInstance | undefined;
}
export declare class StackInstanceNotFoundException extends __BaseException {
  readonly name: "StackInstanceNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<StackInstanceNotFoundException, __BaseException>
  );
}
export interface DescribeStackRefactorInput {
  StackRefactorId: string | undefined;
}
export declare const StackRefactorExecutionStatus: {
  readonly AVAILABLE: "AVAILABLE";
  readonly EXECUTE_COMPLETE: "EXECUTE_COMPLETE";
  readonly EXECUTE_FAILED: "EXECUTE_FAILED";
  readonly EXECUTE_IN_PROGRESS: "EXECUTE_IN_PROGRESS";
  readonly OBSOLETE: "OBSOLETE";
  readonly ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE";
  readonly ROLLBACK_FAILED: "ROLLBACK_FAILED";
  readonly ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS";
  readonly UNAVAILABLE: "UNAVAILABLE";
};
export type StackRefactorExecutionStatus =
  (typeof StackRefactorExecutionStatus)[keyof typeof StackRefactorExecutionStatus];
export declare const StackRefactorStatus: {
  readonly CREATE_COMPLETE: "CREATE_COMPLETE";
  readonly CREATE_FAILED: "CREATE_FAILED";
  readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
  readonly DELETE_COMPLETE: "DELETE_COMPLETE";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
};
export type StackRefactorStatus =
  (typeof StackRefactorStatus)[keyof typeof StackRefactorStatus];
export interface DescribeStackRefactorOutput {
  Description?: string | undefined;
  StackRefactorId?: string | undefined;
  StackIds?: string[] | undefined;
  ExecutionStatus?: StackRefactorExecutionStatus | undefined;
  ExecutionStatusReason?: string | undefined;
  Status?: StackRefactorStatus | undefined;
  StatusReason?: string | undefined;
}
export declare class StackRefactorNotFoundException extends __BaseException {
  readonly name: "StackRefactorNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<StackRefactorNotFoundException, __BaseException>
  );
}
export interface DescribeStackResourceInput {
  StackName: string | undefined;
  LogicalResourceId: string | undefined;
}
export declare const StackResourceDriftStatus: {
  readonly DELETED: "DELETED";
  readonly IN_SYNC: "IN_SYNC";
  readonly MODIFIED: "MODIFIED";
  readonly NOT_CHECKED: "NOT_CHECKED";
  readonly UNKNOWN: "UNKNOWN";
};
export type StackResourceDriftStatus =
  (typeof StackResourceDriftStatus)[keyof typeof StackResourceDriftStatus];
export interface StackResourceDriftInformation {
  StackResourceDriftStatus: StackResourceDriftStatus | undefined;
  LastCheckTimestamp?: Date | undefined;
}
export interface StackResourceDetail {
  StackName?: string | undefined;
  StackId?: string | undefined;
  LogicalResourceId: string | undefined;
  PhysicalResourceId?: string | undefined;
  ResourceType: string | undefined;
  LastUpdatedTimestamp: Date | undefined;
  ResourceStatus: ResourceStatus | undefined;
  ResourceStatusReason?: string | undefined;
  Description?: string | undefined;
  Metadata?: string | undefined;
  DriftInformation?: StackResourceDriftInformation | undefined;
  ModuleInfo?: ModuleInfo | undefined;
}
export interface DescribeStackResourceOutput {
  StackResourceDetail?: StackResourceDetail | undefined;
}
export interface DescribeStackResourceDriftsInput {
  StackName: string | undefined;
  StackResourceDriftStatusFilters?: StackResourceDriftStatus[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface PhysicalResourceIdContextKeyValuePair {
  Key: string | undefined;
  Value: string | undefined;
}
export declare const DifferenceType: {
  readonly ADD: "ADD";
  readonly NOT_EQUAL: "NOT_EQUAL";
  readonly REMOVE: "REMOVE";
};
export type DifferenceType =
  (typeof DifferenceType)[keyof typeof DifferenceType];
export interface PropertyDifference {
  PropertyPath: string | undefined;
  ExpectedValue: string | undefined;
  ActualValue: string | undefined;
  DifferenceType: DifferenceType | undefined;
}
export interface StackResourceDrift {
  StackId: string | undefined;
  LogicalResourceId: string | undefined;
  PhysicalResourceId?: string | undefined;
  PhysicalResourceIdContext?:
    | PhysicalResourceIdContextKeyValuePair[]
    | undefined;
  ResourceType: string | undefined;
  ExpectedProperties?: string | undefined;
  ActualProperties?: string | undefined;
  PropertyDifferences?: PropertyDifference[] | undefined;
  StackResourceDriftStatus: StackResourceDriftStatus | undefined;
  Timestamp: Date | undefined;
  ModuleInfo?: ModuleInfo | undefined;
  DriftStatusReason?: string | undefined;
}
export interface DescribeStackResourceDriftsOutput {
  StackResourceDrifts: StackResourceDrift[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeStackResourcesInput {
  StackName?: string | undefined;
  LogicalResourceId?: string | undefined;
  PhysicalResourceId?: string | undefined;
}
export interface StackResource {
  StackName?: string | undefined;
  StackId?: string | undefined;
  LogicalResourceId: string | undefined;
  PhysicalResourceId?: string | undefined;
  ResourceType: string | undefined;
  Timestamp: Date | undefined;
  ResourceStatus: ResourceStatus | undefined;
  ResourceStatusReason?: string | undefined;
  Description?: string | undefined;
  DriftInformation?: StackResourceDriftInformation | undefined;
  ModuleInfo?: ModuleInfo | undefined;
}
export interface DescribeStackResourcesOutput {
  StackResources?: StackResource[] | undefined;
}
export interface DescribeStacksInput {
  StackName?: string | undefined;
  NextToken?: string | undefined;
}
export interface StackDriftInformation {
  StackDriftStatus: StackDriftStatus | undefined;
  LastCheckTimestamp?: Date | undefined;
}
export interface Output {
  OutputKey?: string | undefined;
  OutputValue?: string | undefined;
  Description?: string | undefined;
  ExportName?: string | undefined;
}
export declare const StackStatus: {
  readonly CREATE_COMPLETE: "CREATE_COMPLETE";
  readonly CREATE_FAILED: "CREATE_FAILED";
  readonly CREATE_IN_PROGRESS: "CREATE_IN_PROGRESS";
  readonly DELETE_COMPLETE: "DELETE_COMPLETE";
  readonly DELETE_FAILED: "DELETE_FAILED";
  readonly DELETE_IN_PROGRESS: "DELETE_IN_PROGRESS";
  readonly IMPORT_COMPLETE: "IMPORT_COMPLETE";
  readonly IMPORT_IN_PROGRESS: "IMPORT_IN_PROGRESS";
  readonly IMPORT_ROLLBACK_COMPLETE: "IMPORT_ROLLBACK_COMPLETE";
  readonly IMPORT_ROLLBACK_FAILED: "IMPORT_ROLLBACK_FAILED";
  readonly IMPORT_ROLLBACK_IN_PROGRESS: "IMPORT_ROLLBACK_IN_PROGRESS";
  readonly REVIEW_IN_PROGRESS: "REVIEW_IN_PROGRESS";
  readonly ROLLBACK_COMPLETE: "ROLLBACK_COMPLETE";
  readonly ROLLBACK_FAILED: "ROLLBACK_FAILED";
  readonly ROLLBACK_IN_PROGRESS: "ROLLBACK_IN_PROGRESS";
  readonly UPDATE_COMPLETE: "UPDATE_COMPLETE";
  readonly UPDATE_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS";
  readonly UPDATE_FAILED: "UPDATE_FAILED";
  readonly UPDATE_IN_PROGRESS: "UPDATE_IN_PROGRESS";
  readonly UPDATE_ROLLBACK_COMPLETE: "UPDATE_ROLLBACK_COMPLETE";
  readonly UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS: "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS";
  readonly UPDATE_ROLLBACK_FAILED: "UPDATE_ROLLBACK_FAILED";
  readonly UPDATE_ROLLBACK_IN_PROGRESS: "UPDATE_ROLLBACK_IN_PROGRESS";
};
export type StackStatus = (typeof StackStatus)[keyof typeof StackStatus];
export interface Stack {
  StackId?: string | undefined;
  StackName: string | undefined;
  ChangeSetId?: string | undefined;
  Description?: string | undefined;
  Parameters?: Parameter[] | undefined;
  CreationTime: Date | undefined;
  DeletionTime?: Date | undefined;
  LastUpdatedTime?: Date | undefined;
  RollbackConfiguration?: RollbackConfiguration | undefined;
  StackStatus: StackStatus | undefined;
  StackStatusReason?: string | undefined;
  DisableRollback?: boolean | undefined;
  NotificationARNs?: string[] | undefined;
  TimeoutInMinutes?: number | undefined;
  Capabilities?: Capability[] | undefined;
  Outputs?: Output[] | undefined;
  RoleARN?: string | undefined;
  Tags?: Tag[] | undefined;
  EnableTerminationProtection?: boolean | undefined;
  ParentId?: string | undefined;
  RootId?: string | undefined;
  DriftInformation?: StackDriftInformation | undefined;
  RetainExceptOnCreate?: boolean | undefined;
  DeletionMode?: DeletionMode | undefined;
  DetailedStatus?: DetailedStatus | undefined;
}
export interface DescribeStacksOutput {
  Stacks?: Stack[] | undefined;
  NextToken?: string | undefined;
}
export interface DescribeStackSetInput {
  StackSetName: string | undefined;
  CallAs?: CallAs | undefined;
}
export declare const StackSetDriftDetectionStatus: {
  readonly COMPLETED: "COMPLETED";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
  readonly PARTIAL_SUCCESS: "PARTIAL_SUCCESS";
  readonly STOPPED: "STOPPED";
};
export type StackSetDriftDetectionStatus =
  (typeof StackSetDriftDetectionStatus)[keyof typeof StackSetDriftDetectionStatus];
export declare const StackSetDriftStatus: {
  readonly DRIFTED: "DRIFTED";
  readonly IN_SYNC: "IN_SYNC";
  readonly NOT_CHECKED: "NOT_CHECKED";
};
export type StackSetDriftStatus =
  (typeof StackSetDriftStatus)[keyof typeof StackSetDriftStatus];
export interface StackSetDriftDetectionDetails {
  DriftStatus?: StackSetDriftStatus | undefined;
  DriftDetectionStatus?: StackSetDriftDetectionStatus | undefined;
  LastDriftCheckTimestamp?: Date | undefined;
  TotalStackInstancesCount?: number | undefined;
  DriftedStackInstancesCount?: number | undefined;
  InSyncStackInstancesCount?: number | undefined;
  InProgressStackInstancesCount?: number | undefined;
  FailedStackInstancesCount?: number | undefined;
}
export declare const StackSetStatus: {
  readonly ACTIVE: "ACTIVE";
  readonly DELETED: "DELETED";
};
export type StackSetStatus =
  (typeof StackSetStatus)[keyof typeof StackSetStatus];
export interface StackSet {
  StackSetName?: string | undefined;
  StackSetId?: string | undefined;
  Description?: string | undefined;
  Status?: StackSetStatus | undefined;
  TemplateBody?: string | undefined;
  Parameters?: Parameter[] | undefined;
  Capabilities?: Capability[] | undefined;
  Tags?: Tag[] | undefined;
  StackSetARN?: string | undefined;
  AdministrationRoleARN?: string | undefined;
  ExecutionRoleName?: string | undefined;
  StackSetDriftDetectionDetails?: StackSetDriftDetectionDetails | undefined;
  AutoDeployment?: AutoDeployment | undefined;
  PermissionModel?: PermissionModels | undefined;
  OrganizationalUnitIds?: string[] | undefined;
  ManagedExecution?: ManagedExecution | undefined;
  Regions?: string[] | undefined;
}
export interface DescribeStackSetOutput {
  StackSet?: StackSet | undefined;
}
export interface DescribeStackSetOperationInput {
  StackSetName: string | undefined;
  OperationId: string | undefined;
  CallAs?: CallAs | undefined;
}
export declare const StackSetOperationAction: {
  readonly CREATE: "CREATE";
  readonly DELETE: "DELETE";
  readonly DETECT_DRIFT: "DETECT_DRIFT";
  readonly UPDATE: "UPDATE";
};
export type StackSetOperationAction =
  (typeof StackSetOperationAction)[keyof typeof StackSetOperationAction];
export declare const StackSetOperationStatus: {
  readonly FAILED: "FAILED";
  readonly QUEUED: "QUEUED";
  readonly RUNNING: "RUNNING";
  readonly STOPPED: "STOPPED";
  readonly STOPPING: "STOPPING";
  readonly SUCCEEDED: "SUCCEEDED";
};
export type StackSetOperationStatus =
  (typeof StackSetOperationStatus)[keyof typeof StackSetOperationStatus];
export interface StackSetOperationStatusDetails {
  FailedStackInstancesCount?: number | undefined;
}
export interface StackSetOperation {
  OperationId?: string | undefined;
  StackSetId?: string | undefined;
  Action?: StackSetOperationAction | undefined;
  Status?: StackSetOperationStatus | undefined;
  OperationPreferences?: StackSetOperationPreferences | undefined;
  RetainStacks?: boolean | undefined;
  AdministrationRoleARN?: string | undefined;
  ExecutionRoleName?: string | undefined;
  CreationTimestamp?: Date | undefined;
  EndTimestamp?: Date | undefined;
  DeploymentTargets?: DeploymentTargets | undefined;
  StackSetDriftDetectionDetails?: StackSetDriftDetectionDetails | undefined;
  StatusReason?: string | undefined;
  StatusDetails?: StackSetOperationStatusDetails | undefined;
}
export interface DescribeStackSetOperationOutput {
  StackSetOperation?: StackSetOperation | undefined;
}
export interface DescribeTypeInput {
  Type?: RegistryType | undefined;
  TypeName?: string | undefined;
  Arn?: string | undefined;
  VersionId?: string | undefined;
  PublisherId?: string | undefined;
  PublicVersionNumber?: string | undefined;
}
export declare const DeprecatedStatus: {
  readonly DEPRECATED: "DEPRECATED";
  readonly LIVE: "LIVE";
};
export type DeprecatedStatus =
  (typeof DeprecatedStatus)[keyof typeof DeprecatedStatus];
export declare const ProvisioningType: {
  readonly FULLY_MUTABLE: "FULLY_MUTABLE";
  readonly IMMUTABLE: "IMMUTABLE";
  readonly NON_PROVISIONABLE: "NON_PROVISIONABLE";
};
export type ProvisioningType =
  (typeof ProvisioningType)[keyof typeof ProvisioningType];
export interface RequiredActivatedType {
  TypeNameAlias?: string | undefined;
  OriginalTypeName?: string | undefined;
  PublisherId?: string | undefined;
  SupportedMajorVersions?: number[] | undefined;
}
export declare const TypeTestsStatus: {
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
  readonly NOT_TESTED: "NOT_TESTED";
  readonly PASSED: "PASSED";
};
export type TypeTestsStatus =
  (typeof TypeTestsStatus)[keyof typeof TypeTestsStatus];
export declare const Visibility: {
  readonly PRIVATE: "PRIVATE";
  readonly PUBLIC: "PUBLIC";
};
export type Visibility = (typeof Visibility)[keyof typeof Visibility];
export interface DescribeTypeOutput {
  Arn?: string | undefined;
  Type?: RegistryType | undefined;
  TypeName?: string | undefined;
  DefaultVersionId?: string | undefined;
  IsDefaultVersion?: boolean | undefined;
  TypeTestsStatus?: TypeTestsStatus | undefined;
  TypeTestsStatusDescription?: string | undefined;
  Description?: string | undefined;
  Schema?: string | undefined;
  ProvisioningType?: ProvisioningType | undefined;
  DeprecatedStatus?: DeprecatedStatus | undefined;
  LoggingConfig?: LoggingConfig | undefined;
  RequiredActivatedTypes?: RequiredActivatedType[] | undefined;
  ExecutionRoleArn?: string | undefined;
  Visibility?: Visibility | undefined;
  SourceUrl?: string | undefined;
  DocumentationUrl?: string | undefined;
  LastUpdated?: Date | undefined;
  TimeCreated?: Date | undefined;
  ConfigurationSchema?: string | undefined;
  PublisherId?: string | undefined;
  OriginalTypeName?: string | undefined;
  OriginalTypeArn?: string | undefined;
  PublicVersionNumber?: string | undefined;
  LatestPublicVersion?: string | undefined;
  IsActivated?: boolean | undefined;
  AutoUpdate?: boolean | undefined;
}
export interface DescribeTypeRegistrationInput {
  RegistrationToken: string | undefined;
}
export declare const RegistrationStatus: {
  readonly COMPLETE: "COMPLETE";
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
};
export type RegistrationStatus =
  (typeof RegistrationStatus)[keyof typeof RegistrationStatus];
export interface DescribeTypeRegistrationOutput {
  ProgressStatus?: RegistrationStatus | undefined;
  Description?: string | undefined;
  TypeArn?: string | undefined;
  TypeVersionArn?: string | undefined;
}
export interface DetectStackDriftInput {
  StackName: string | undefined;
  LogicalResourceIds?: string[] | undefined;
}
export interface DetectStackDriftOutput {
  StackDriftDetectionId: string | undefined;
}
export interface DetectStackResourceDriftInput {
  StackName: string | undefined;
  LogicalResourceId: string | undefined;
}
export interface DetectStackResourceDriftOutput {
  StackResourceDrift: StackResourceDrift | undefined;
}
export interface DetectStackSetDriftInput {
  StackSetName: string | undefined;
  OperationPreferences?: StackSetOperationPreferences | undefined;
  OperationId?: string | undefined;
  CallAs?: CallAs | undefined;
}
export interface DetectStackSetDriftOutput {
  OperationId?: string | undefined;
}
export interface EstimateTemplateCostInput {
  TemplateBody?: string | undefined;
  TemplateURL?: string | undefined;
  Parameters?: Parameter[] | undefined;
}
export interface EstimateTemplateCostOutput {
  Url?: string | undefined;
}
export interface ExecuteChangeSetInput {
  ChangeSetName: string | undefined;
  StackName?: string | undefined;
  ClientRequestToken?: string | undefined;
  DisableRollback?: boolean | undefined;
  RetainExceptOnCreate?: boolean | undefined;
}
export interface ExecuteChangeSetOutput {}
export interface ExecuteStackRefactorInput {
  StackRefactorId: string | undefined;
}
export declare const TemplateFormat: {
  readonly JSON: "JSON";
  readonly YAML: "YAML";
};
export type TemplateFormat =
  (typeof TemplateFormat)[keyof typeof TemplateFormat];
export interface GetGeneratedTemplateInput {
  Format?: TemplateFormat | undefined;
  GeneratedTemplateName: string | undefined;
}
export interface GetGeneratedTemplateOutput {
  Status?: GeneratedTemplateStatus | undefined;
  TemplateBody?: string | undefined;
}
export interface GetStackPolicyInput {
  StackName: string | undefined;
}
export interface GetStackPolicyOutput {
  StackPolicyBody?: string | undefined;
}
export declare const TemplateStage: {
  readonly Original: "Original";
  readonly Processed: "Processed";
};
export type TemplateStage = (typeof TemplateStage)[keyof typeof TemplateStage];
export interface GetTemplateInput {
  StackName?: string | undefined;
  ChangeSetName?: string | undefined;
  TemplateStage?: TemplateStage | undefined;
}
export interface GetTemplateOutput {
  TemplateBody?: string | undefined;
  StagesAvailable?: TemplateStage[] | undefined;
}
export interface TemplateSummaryConfig {
  TreatUnrecognizedResourceTypesAsWarnings?: boolean | undefined;
}
export interface GetTemplateSummaryInput {
  TemplateBody?: string | undefined;
  TemplateURL?: string | undefined;
  StackName?: string | undefined;
  StackSetName?: string | undefined;
  CallAs?: CallAs | undefined;
  TemplateSummaryConfig?: TemplateSummaryConfig | undefined;
}
export interface ParameterConstraints {
  AllowedValues?: string[] | undefined;
}
export interface ParameterDeclaration {
  ParameterKey?: string | undefined;
  DefaultValue?: string | undefined;
  ParameterType?: string | undefined;
  NoEcho?: boolean | undefined;
  Description?: string | undefined;
  ParameterConstraints?: ParameterConstraints | undefined;
}
export interface ResourceIdentifierSummary {
  ResourceType?: string | undefined;
  LogicalResourceIds?: string[] | undefined;
  ResourceIdentifiers?: string[] | undefined;
}
export interface Warnings {
  UnrecognizedResourceTypes?: string[] | undefined;
}
export interface GetTemplateSummaryOutput {
  Parameters?: ParameterDeclaration[] | undefined;
  Description?: string | undefined;
  Capabilities?: Capability[] | undefined;
  CapabilitiesReason?: string | undefined;
  ResourceTypes?: string[] | undefined;
  Version?: string | undefined;
  Metadata?: string | undefined;
  DeclaredTransforms?: string[] | undefined;
  ResourceIdentifierSummaries?: ResourceIdentifierSummary[] | undefined;
  Warnings?: Warnings | undefined;
}
export interface ImportStacksToStackSetInput {
  StackSetName: string | undefined;
  StackIds?: string[] | undefined;
  StackIdsUrl?: string | undefined;
  OrganizationalUnitIds?: string[] | undefined;
  OperationPreferences?: StackSetOperationPreferences | undefined;
  OperationId?: string | undefined;
  CallAs?: CallAs | undefined;
}
export interface ImportStacksToStackSetOutput {
  OperationId?: string | undefined;
}
export declare class StackNotFoundException extends __BaseException {
  readonly name: "StackNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<StackNotFoundException, __BaseException>
  );
}
export interface ListChangeSetsInput {
  StackName: string | undefined;
  NextToken?: string | undefined;
}
export interface ListChangeSetsOutput {
  Summaries?: ChangeSetSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListExportsInput {
  NextToken?: string | undefined;
}
export interface Export {
  ExportingStackId?: string | undefined;
  Name?: string | undefined;
  Value?: string | undefined;
}
export interface ListExportsOutput {
  Exports?: Export[] | undefined;
  NextToken?: string | undefined;
}
export interface ListGeneratedTemplatesInput {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface TemplateSummary {
  GeneratedTemplateId?: string | undefined;
  GeneratedTemplateName?: string | undefined;
  Status?: GeneratedTemplateStatus | undefined;
  StatusReason?: string | undefined;
  CreationTime?: Date | undefined;
  LastUpdatedTime?: Date | undefined;
  NumberOfResources?: number | undefined;
}
export interface ListGeneratedTemplatesOutput {
  Summaries?: TemplateSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare class HookResultNotFoundException extends __BaseException {
  readonly name: "HookResultNotFoundException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<HookResultNotFoundException, __BaseException>
  );
}
export declare const ListHookResultsTargetType: {
  readonly CHANGE_SET: "CHANGE_SET";
  readonly CLOUD_CONTROL: "CLOUD_CONTROL";
  readonly RESOURCE: "RESOURCE";
  readonly STACK: "STACK";
};
export type ListHookResultsTargetType =
  (typeof ListHookResultsTargetType)[keyof typeof ListHookResultsTargetType];
export interface ListHookResultsInput {
  TargetType: ListHookResultsTargetType | undefined;
  TargetId: string | undefined;
  NextToken?: string | undefined;
}
export interface HookResultSummary {
  InvocationPoint?: HookInvocationPoint | undefined;
  FailureMode?: HookFailureMode | undefined;
  TypeName?: string | undefined;
  TypeVersionId?: string | undefined;
  TypeConfigurationVersionId?: string | undefined;
  Status?: HookStatus | undefined;
  HookStatusReason?: string | undefined;
}
export interface ListHookResultsOutput {
  TargetType?: ListHookResultsTargetType | undefined;
  TargetId?: string | undefined;
  HookResults?: HookResultSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListImportsInput {
  ExportName: string | undefined;
  NextToken?: string | undefined;
}
export interface ListImportsOutput {
  Imports?: string[] | undefined;
  NextToken?: string | undefined;
}
export interface ScannedResourceIdentifier {
  ResourceType: string | undefined;
  ResourceIdentifier: Record<string, string> | undefined;
}
export interface ListResourceScanRelatedResourcesInput {
  ResourceScanId: string | undefined;
  Resources: ScannedResourceIdentifier[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ScannedResource {
  ResourceType?: string | undefined;
  ResourceIdentifier?: Record<string, string> | undefined;
  ManagedByStack?: boolean | undefined;
}
export interface ListResourceScanRelatedResourcesOutput {
  RelatedResources?: ScannedResource[] | undefined;
  NextToken?: string | undefined;
}
export declare class ResourceScanInProgressException extends __BaseException {
  readonly name: "ResourceScanInProgressException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      ResourceScanInProgressException,
      __BaseException
    >
  );
}
export interface ListResourceScanResourcesInput {
  ResourceScanId: string | undefined;
  ResourceIdentifier?: string | undefined;
  ResourceTypePrefix?: string | undefined;
  TagKey?: string | undefined;
  TagValue?: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface ListResourceScanResourcesOutput {
  Resources?: ScannedResource[] | undefined;
  NextToken?: string | undefined;
}
export declare const ScanType: {
  readonly FULL: "FULL";
  readonly PARTIAL: "PARTIAL";
};
export type ScanType = (typeof ScanType)[keyof typeof ScanType];
export interface ListResourceScansInput {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  ScanTypeFilter?: ScanType | undefined;
}
export interface ResourceScanSummary {
  ResourceScanId?: string | undefined;
  Status?: ResourceScanStatus | undefined;
  StatusReason?: string | undefined;
  StartTime?: Date | undefined;
  EndTime?: Date | undefined;
  PercentageCompleted?: number | undefined;
  ScanType?: ScanType | undefined;
}
export interface ListResourceScansOutput {
  ResourceScanSummaries?: ResourceScanSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStackInstanceResourceDriftsInput {
  StackSetName: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  StackInstanceResourceDriftStatuses?: StackResourceDriftStatus[] | undefined;
  StackInstanceAccount: string | undefined;
  StackInstanceRegion: string | undefined;
  OperationId: string | undefined;
  CallAs?: CallAs | undefined;
}
export interface StackInstanceResourceDriftsSummary {
  StackId: string | undefined;
  LogicalResourceId: string | undefined;
  PhysicalResourceId?: string | undefined;
  PhysicalResourceIdContext?:
    | PhysicalResourceIdContextKeyValuePair[]
    | undefined;
  ResourceType: string | undefined;
  PropertyDifferences?: PropertyDifference[] | undefined;
  StackResourceDriftStatus: StackResourceDriftStatus | undefined;
  Timestamp: Date | undefined;
}
export interface ListStackInstanceResourceDriftsOutput {
  Summaries?: StackInstanceResourceDriftsSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const StackInstanceFilterName: {
  readonly DETAILED_STATUS: "DETAILED_STATUS";
  readonly DRIFT_STATUS: "DRIFT_STATUS";
  readonly LAST_OPERATION_ID: "LAST_OPERATION_ID";
};
export type StackInstanceFilterName =
  (typeof StackInstanceFilterName)[keyof typeof StackInstanceFilterName];
export interface StackInstanceFilter {
  Name?: StackInstanceFilterName | undefined;
  Values?: string | undefined;
}
export interface ListStackInstancesInput {
  StackSetName: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  Filters?: StackInstanceFilter[] | undefined;
  StackInstanceAccount?: string | undefined;
  StackInstanceRegion?: string | undefined;
  CallAs?: CallAs | undefined;
}
export interface StackInstanceSummary {
  StackSetId?: string | undefined;
  Region?: string | undefined;
  Account?: string | undefined;
  StackId?: string | undefined;
  Status?: StackInstanceStatus | undefined;
  StatusReason?: string | undefined;
  StackInstanceStatus?: StackInstanceComprehensiveStatus | undefined;
  OrganizationalUnitId?: string | undefined;
  DriftStatus?: StackDriftStatus | undefined;
  LastDriftCheckTimestamp?: Date | undefined;
  LastOperationId?: string | undefined;
}
export interface ListStackInstancesOutput {
  Summaries?: StackInstanceSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStackRefactorActionsInput {
  StackRefactorId: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export declare const StackRefactorActionType: {
  readonly CREATE: "CREATE";
  readonly MOVE: "MOVE";
};
export type StackRefactorActionType =
  (typeof StackRefactorActionType)[keyof typeof StackRefactorActionType];
export declare const StackRefactorDetection: {
  readonly AUTO: "AUTO";
  readonly MANUAL: "MANUAL";
};
export type StackRefactorDetection =
  (typeof StackRefactorDetection)[keyof typeof StackRefactorDetection];
export declare const StackRefactorActionEntity: {
  readonly RESOURCE: "RESOURCE";
  readonly STACK: "STACK";
};
export type StackRefactorActionEntity =
  (typeof StackRefactorActionEntity)[keyof typeof StackRefactorActionEntity];
export interface StackRefactorAction {
  Action?: StackRefactorActionType | undefined;
  Entity?: StackRefactorActionEntity | undefined;
  PhysicalResourceId?: string | undefined;
  ResourceIdentifier?: string | undefined;
  Description?: string | undefined;
  Detection?: StackRefactorDetection | undefined;
  DetectionReason?: string | undefined;
  TagResources?: Tag[] | undefined;
  UntagResources?: string[] | undefined;
  ResourceMapping?: ResourceMapping | undefined;
}
export interface ListStackRefactorActionsOutput {
  StackRefactorActions: StackRefactorAction[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStackRefactorsInput {
  ExecutionStatusFilter?: StackRefactorExecutionStatus[] | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface StackRefactorSummary {
  StackRefactorId?: string | undefined;
  Description?: string | undefined;
  ExecutionStatus?: StackRefactorExecutionStatus | undefined;
  ExecutionStatusReason?: string | undefined;
  Status?: StackRefactorStatus | undefined;
  StatusReason?: string | undefined;
}
export interface ListStackRefactorsOutput {
  StackRefactorSummaries: StackRefactorSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStackResourcesInput {
  StackName: string | undefined;
  NextToken?: string | undefined;
}
export interface StackResourceDriftInformationSummary {
  StackResourceDriftStatus: StackResourceDriftStatus | undefined;
  LastCheckTimestamp?: Date | undefined;
}
export interface StackResourceSummary {
  LogicalResourceId: string | undefined;
  PhysicalResourceId?: string | undefined;
  ResourceType: string | undefined;
  LastUpdatedTimestamp: Date | undefined;
  ResourceStatus: ResourceStatus | undefined;
  ResourceStatusReason?: string | undefined;
  DriftInformation?: StackResourceDriftInformationSummary | undefined;
  ModuleInfo?: ModuleInfo | undefined;
}
export interface ListStackResourcesOutput {
  StackResourceSummaries?: StackResourceSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStacksInput {
  NextToken?: string | undefined;
  StackStatusFilter?: StackStatus[] | undefined;
}
export interface StackDriftInformationSummary {
  StackDriftStatus: StackDriftStatus | undefined;
  LastCheckTimestamp?: Date | undefined;
}
export interface StackSummary {
  StackId?: string | undefined;
  StackName: string | undefined;
  TemplateDescription?: string | undefined;
  CreationTime: Date | undefined;
  LastUpdatedTime?: Date | undefined;
  DeletionTime?: Date | undefined;
  StackStatus: StackStatus | undefined;
  StackStatusReason?: string | undefined;
  ParentId?: string | undefined;
  RootId?: string | undefined;
  DriftInformation?: StackDriftInformationSummary | undefined;
}
export interface ListStacksOutput {
  StackSummaries?: StackSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStackSetAutoDeploymentTargetsInput {
  StackSetName: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  CallAs?: CallAs | undefined;
}
export interface StackSetAutoDeploymentTargetSummary {
  OrganizationalUnitId?: string | undefined;
  Regions?: string[] | undefined;
}
export interface ListStackSetAutoDeploymentTargetsOutput {
  Summaries?: StackSetAutoDeploymentTargetSummary[] | undefined;
  NextToken?: string | undefined;
}
export declare const OperationResultFilterName: {
  readonly OPERATION_RESULT_STATUS: "OPERATION_RESULT_STATUS";
};
export type OperationResultFilterName =
  (typeof OperationResultFilterName)[keyof typeof OperationResultFilterName];
export interface OperationResultFilter {
  Name?: OperationResultFilterName | undefined;
  Values?: string | undefined;
}
export interface ListStackSetOperationResultsInput {
  StackSetName: string | undefined;
  OperationId: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  CallAs?: CallAs | undefined;
  Filters?: OperationResultFilter[] | undefined;
}
export declare const StackSetOperationResultStatus: {
  readonly CANCELLED: "CANCELLED";
  readonly FAILED: "FAILED";
  readonly PENDING: "PENDING";
  readonly RUNNING: "RUNNING";
  readonly SUCCEEDED: "SUCCEEDED";
};
export type StackSetOperationResultStatus =
  (typeof StackSetOperationResultStatus)[keyof typeof StackSetOperationResultStatus];
export interface StackSetOperationResultSummary {
  Account?: string | undefined;
  Region?: string | undefined;
  Status?: StackSetOperationResultStatus | undefined;
  StatusReason?: string | undefined;
  AccountGateResult?: AccountGateResult | undefined;
  OrganizationalUnitId?: string | undefined;
}
export interface ListStackSetOperationResultsOutput {
  Summaries?: StackSetOperationResultSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStackSetOperationsInput {
  StackSetName: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  CallAs?: CallAs | undefined;
}
export interface StackSetOperationSummary {
  OperationId?: string | undefined;
  Action?: StackSetOperationAction | undefined;
  Status?: StackSetOperationStatus | undefined;
  CreationTimestamp?: Date | undefined;
  EndTimestamp?: Date | undefined;
  StatusReason?: string | undefined;
  StatusDetails?: StackSetOperationStatusDetails | undefined;
  OperationPreferences?: StackSetOperationPreferences | undefined;
}
export interface ListStackSetOperationsOutput {
  Summaries?: StackSetOperationSummary[] | undefined;
  NextToken?: string | undefined;
}
