import { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { CloudFormationServiceException as __BaseException } from "./CloudFormationServiceException";
import {
  AutoDeployment,
  CallAs,
  Capability,
  Category,
  DeploymentTargets,
  DeprecatedStatus,
  IdentityProvider,
  LoggingConfig,
  ManagedExecution,
  Parameter,
  PermissionModels,
  ProvisioningType,
  RegistrationStatus,
  RegistryType,
  ResourceDefinition,
  RollbackConfiguration,
  ScanFilter,
  StackDriftStatus,
  StackSetOperationPreferences,
  StackSetStatus,
  Tag,
  TemplateConfiguration,
  ThirdPartyType,
  Visibility,
} from "./models_0";
export interface ListStackSetsInput {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  Status?: StackSetStatus | undefined;
  CallAs?: CallAs | undefined;
}
export interface StackSetSummary {
  StackSetName?: string | undefined;
  StackSetId?: string | undefined;
  Description?: string | undefined;
  Status?: StackSetStatus | undefined;
  AutoDeployment?: AutoDeployment | undefined;
  PermissionModel?: PermissionModels | undefined;
  DriftStatus?: StackDriftStatus | undefined;
  LastDriftCheckTimestamp?: Date | undefined;
  ManagedExecution?: ManagedExecution | undefined;
}
export interface ListStackSetsOutput {
  Summaries?: StackSetSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListTypeRegistrationsInput {
  Type?: RegistryType | undefined;
  TypeName?: string | undefined;
  TypeArn?: string | undefined;
  RegistrationStatusFilter?: RegistrationStatus | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface ListTypeRegistrationsOutput {
  RegistrationTokenList?: string[] | undefined;
  NextToken?: string | undefined;
}
export interface TypeFilters {
  Category?: Category | undefined;
  PublisherId?: string | undefined;
  TypeNamePrefix?: string | undefined;
}
export interface ListTypesInput {
  Visibility?: Visibility | undefined;
  ProvisioningType?: ProvisioningType | undefined;
  DeprecatedStatus?: DeprecatedStatus | undefined;
  Type?: RegistryType | undefined;
  Filters?: TypeFilters | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
}
export interface TypeSummary {
  Type?: RegistryType | undefined;
  TypeName?: string | undefined;
  DefaultVersionId?: string | undefined;
  TypeArn?: string | undefined;
  LastUpdated?: Date | undefined;
  Description?: string | undefined;
  PublisherId?: string | undefined;
  OriginalTypeName?: string | undefined;
  PublicVersionNumber?: string | undefined;
  LatestPublicVersion?: string | undefined;
  PublisherIdentity?: IdentityProvider | undefined;
  PublisherName?: string | undefined;
  IsActivated?: boolean | undefined;
}
export interface ListTypesOutput {
  TypeSummaries?: TypeSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface ListTypeVersionsInput {
  Type?: RegistryType | undefined;
  TypeName?: string | undefined;
  Arn?: string | undefined;
  MaxResults?: number | undefined;
  NextToken?: string | undefined;
  DeprecatedStatus?: DeprecatedStatus | undefined;
  PublisherId?: string | undefined;
}
export interface TypeVersionSummary {
  Type?: RegistryType | undefined;
  TypeName?: string | undefined;
  VersionId?: string | undefined;
  IsDefaultVersion?: boolean | undefined;
  Arn?: string | undefined;
  TimeCreated?: Date | undefined;
  Description?: string | undefined;
  PublicVersionNumber?: string | undefined;
}
export interface ListTypeVersionsOutput {
  TypeVersionSummaries?: TypeVersionSummary[] | undefined;
  NextToken?: string | undefined;
}
export interface PublishTypeInput {
  Type?: ThirdPartyType | undefined;
  Arn?: string | undefined;
  TypeName?: string | undefined;
  PublicVersionNumber?: string | undefined;
}
export interface PublishTypeOutput {
  PublicTypeArn?: string | undefined;
}
export declare class InvalidStateTransitionException extends __BaseException {
  readonly name: "InvalidStateTransitionException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      InvalidStateTransitionException,
      __BaseException
    >
  );
}
export declare class OperationStatusCheckFailedException extends __BaseException {
  readonly name: "OperationStatusCheckFailedException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      OperationStatusCheckFailedException,
      __BaseException
    >
  );
}
export declare const OperationStatus: {
  readonly FAILED: "FAILED";
  readonly IN_PROGRESS: "IN_PROGRESS";
  readonly PENDING: "PENDING";
  readonly SUCCESS: "SUCCESS";
};
export type OperationStatus =
  (typeof OperationStatus)[keyof typeof OperationStatus];
export declare const HandlerErrorCode: {
  readonly AccessDenied: "AccessDenied";
  readonly AlreadyExists: "AlreadyExists";
  readonly GeneralServiceException: "GeneralServiceException";
  readonly HandlerInternalFailure: "HandlerInternalFailure";
  readonly InternalFailure: "InternalFailure";
  readonly InvalidCredentials: "InvalidCredentials";
  readonly InvalidRequest: "InvalidRequest";
  readonly InvalidTypeConfiguration: "InvalidTypeConfiguration";
  readonly NetworkFailure: "NetworkFailure";
  readonly NonCompliant: "NonCompliant";
  readonly NotFound: "NotFound";
  readonly NotUpdatable: "NotUpdatable";
  readonly ResourceConflict: "ResourceConflict";
  readonly ServiceInternalError: "ServiceInternalError";
  readonly ServiceLimitExceeded: "ServiceLimitExceeded";
  readonly ServiceTimeout: "NotStabilized";
  readonly Throttling: "Throttling";
  readonly Unknown: "Unknown";
  readonly UnsupportedTarget: "UnsupportedTarget";
};
export type HandlerErrorCode =
  (typeof HandlerErrorCode)[keyof typeof HandlerErrorCode];
export interface RecordHandlerProgressInput {
  BearerToken: string | undefined;
  OperationStatus: OperationStatus | undefined;
  CurrentOperationStatus?: OperationStatus | undefined;
  StatusMessage?: string | undefined;
  ErrorCode?: HandlerErrorCode | undefined;
  ResourceModel?: string | undefined;
  ClientRequestToken?: string | undefined;
}
export interface RecordHandlerProgressOutput {}
export interface RegisterPublisherInput {
  AcceptTermsAndConditions?: boolean | undefined;
  ConnectionArn?: string | undefined;
}
export interface RegisterPublisherOutput {
  PublisherId?: string | undefined;
}
export interface RegisterTypeInput {
  Type?: RegistryType | undefined;
  TypeName: string | undefined;
  SchemaHandlerPackage: string | undefined;
  LoggingConfig?: LoggingConfig | undefined;
  ExecutionRoleArn?: string | undefined;
  ClientRequestToken?: string | undefined;
}
export interface RegisterTypeOutput {
  RegistrationToken?: string | undefined;
}
export interface RollbackStackInput {
  StackName: string | undefined;
  RoleARN?: string | undefined;
  ClientRequestToken?: string | undefined;
  RetainExceptOnCreate?: boolean | undefined;
}
export interface RollbackStackOutput {
  StackId?: string | undefined;
}
export interface SetStackPolicyInput {
  StackName: string | undefined;
  StackPolicyBody?: string | undefined;
  StackPolicyURL?: string | undefined;
}
export interface SetTypeConfigurationInput {
  TypeArn?: string | undefined;
  Configuration: string | undefined;
  ConfigurationAlias?: string | undefined;
  TypeName?: string | undefined;
  Type?: ThirdPartyType | undefined;
}
export interface SetTypeConfigurationOutput {
  ConfigurationArn?: string | undefined;
}
export interface SetTypeDefaultVersionInput {
  Arn?: string | undefined;
  Type?: RegistryType | undefined;
  TypeName?: string | undefined;
  VersionId?: string | undefined;
}
export interface SetTypeDefaultVersionOutput {}
export declare const ResourceSignalStatus: {
  readonly FAILURE: "FAILURE";
  readonly SUCCESS: "SUCCESS";
};
export type ResourceSignalStatus =
  (typeof ResourceSignalStatus)[keyof typeof ResourceSignalStatus];
export interface SignalResourceInput {
  StackName: string | undefined;
  LogicalResourceId: string | undefined;
  UniqueId: string | undefined;
  Status: ResourceSignalStatus | undefined;
}
export declare class ResourceScanLimitExceededException extends __BaseException {
  readonly name: "ResourceScanLimitExceededException";
  readonly $fault: "client";
  Message?: string | undefined;
  constructor(
    opts: __ExceptionOptionType<
      ResourceScanLimitExceededException,
      __BaseException
    >
  );
}
export interface StartResourceScanInput {
  ClientRequestToken?: string | undefined;
  ScanFilters?: ScanFilter[] | undefined;
}
export interface StartResourceScanOutput {
  ResourceScanId?: string | undefined;
}
export interface StopStackSetOperationInput {
  StackSetName: string | undefined;
  OperationId: string | undefined;
  CallAs?: CallAs | undefined;
}
export interface StopStackSetOperationOutput {}
export interface TestTypeInput {
  Arn?: string | undefined;
  Type?: ThirdPartyType | undefined;
  TypeName?: string | undefined;
  VersionId?: string | undefined;
  LogDeliveryBucket?: string | undefined;
}
export interface TestTypeOutput {
  TypeVersionArn?: string | undefined;
}
export interface UpdateGeneratedTemplateInput {
  GeneratedTemplateName: string | undefined;
  NewGeneratedTemplateName?: string | undefined;
  AddResources?: ResourceDefinition[] | undefined;
  RemoveResources?: string[] | undefined;
  RefreshAllResources?: boolean | undefined;
  TemplateConfiguration?: TemplateConfiguration | undefined;
}
export interface UpdateGeneratedTemplateOutput {
  GeneratedTemplateId?: string | undefined;
}
export interface UpdateStackInput {
  StackName: string | undefined;
  TemplateBody?: string | undefined;
  TemplateURL?: string | undefined;
  UsePreviousTemplate?: boolean | undefined;
  StackPolicyDuringUpdateBody?: string | undefined;
  StackPolicyDuringUpdateURL?: string | undefined;
  Parameters?: Parameter[] | undefined;
  Capabilities?: Capability[] | undefined;
  ResourceTypes?: string[] | undefined;
  RoleARN?: string | undefined;
  RollbackConfiguration?: RollbackConfiguration | undefined;
  StackPolicyBody?: string | undefined;
  StackPolicyURL?: string | undefined;
  NotificationARNs?: string[] | undefined;
  Tags?: Tag[] | undefined;
  DisableRollback?: boolean | undefined;
  ClientRequestToken?: string | undefined;
  RetainExceptOnCreate?: boolean | undefined;
}
export interface UpdateStackOutput {
  StackId?: string | undefined;
}
export interface UpdateStackInstancesInput {
  StackSetName: string | undefined;
  Accounts?: string[] | undefined;
  DeploymentTargets?: DeploymentTargets | undefined;
  Regions: string[] | undefined;
  ParameterOverrides?: Parameter[] | undefined;
  OperationPreferences?: StackSetOperationPreferences | undefined;
  OperationId?: string | undefined;
  CallAs?: CallAs | undefined;
}
export interface UpdateStackInstancesOutput {
  OperationId?: string | undefined;
}
export interface UpdateStackSetInput {
  StackSetName: string | undefined;
  Description?: string | undefined;
  TemplateBody?: string | undefined;
  TemplateURL?: string | undefined;
  UsePreviousTemplate?: boolean | undefined;
  Parameters?: Parameter[] | undefined;
  Capabilities?: Capability[] | undefined;
  Tags?: Tag[] | undefined;
  OperationPreferences?: StackSetOperationPreferences | undefined;
  AdministrationRoleARN?: string | undefined;
  ExecutionRoleName?: string | undefined;
  DeploymentTargets?: DeploymentTargets | undefined;
  PermissionModel?: PermissionModels | undefined;
  AutoDeployment?: AutoDeployment | undefined;
  OperationId?: string | undefined;
  Accounts?: string[] | undefined;
  Regions?: string[] | undefined;
  CallAs?: CallAs | undefined;
  ManagedExecution?: ManagedExecution | undefined;
}
export interface UpdateStackSetOutput {
  OperationId?: string | undefined;
}
export interface UpdateTerminationProtectionInput {
  EnableTerminationProtection: boolean | undefined;
  StackName: string | undefined;
}
export interface UpdateTerminationProtectionOutput {
  StackId?: string | undefined;
}
export interface ValidateTemplateInput {
  TemplateBody?: string | undefined;
  TemplateURL?: string | undefined;
}
export interface TemplateParameter {
  ParameterKey?: string | undefined;
  DefaultValue?: string | undefined;
  NoEcho?: boolean | undefined;
  Description?: string | undefined;
}
export interface ValidateTemplateOutput {
  Parameters?: TemplateParameter[] | undefined;
  Description?: string | undefined;
  Capabilities?: Capability[] | undefined;
  CapabilitiesReason?: string | undefined;
  DeclaredTransforms?: string[] | undefined;
}
