"""Derived module from dmdbase.py for forward/backward dmd."""
from .dmd import DMD


class FbDMD(DMD):
    """
    Forward/backward DMD class.

    :param svd_rank: the rank for the truncation; If 0, the method computes the
        optimal rank and uses it for truncation; if positive interger, the
        method uses the argument for the truncation; if float between 0 and 1,
        the rank is the number of the biggest singular values that are needed
        to reach the 'energy' specified by `svd_rank`; if -1, the method does
        not compute truncation.
    :type svd_rank: int or float
    :param int tlsq_rank: rank truncation computing Total Least Square. Default
        is 0, that means no truncation.
    :param bool exact: flag to compute either exact DMD or projected DMD.
        Default is False.
    :param opt: argument to control the computation of DMD modes amplitudes.
        See :class:`DMDBase`. Default is False.
    :type opt: bool or int
    :param rescale_mode: Scale Atilde as shown in
            10.1016/j.jneumeth.2015.10.010 (section 2.4) before computing its
            eigendecomposition. None means no rescaling, 'auto' means automatic
            rescaling using singular values, otherwise the scaling factors.
    :type rescale_mode: {'auto'} or None or numpy.ndarray
    :param sorted_eigs: Sort eigenvalues (and modes/dynamics accordingly) by
        magnitude if `sorted_eigs='abs'`, by real part (and then by imaginary
        part to break ties) if `sorted_eigs='real'`. Default: False.
    :type sorted_eigs: {'real', 'abs'} or False

    Reference: Dawson et al. https://arxiv.org/abs/1507.02264
    """

    def __init__(self, svd_rank=0, tlsq_rank=0, exact=False, opt=False,
                 rescale_mode=None, sorted_eigs=False):
        super().__init__(svd_rank=svd_rank, tlsq_rank=tlsq_rank, exact=exact,
                         opt=opt, rescale_mode=rescale_mode,
                         forward_backward=True, sorted_eigs=sorted_eigs)
