# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from . import _utilities, _tables

__all__ = [
    'ServiceACLEntriesv1Entry',
    'ServiceComputeBackend',
    'ServiceComputeBigquerylogging',
    'ServiceComputeBlobstoragelogging',
    'ServiceComputeDomain',
    'ServiceComputeGcslogging',
    'ServiceComputeHealthcheck',
    'ServiceComputeHttpslogging',
    'ServiceComputeLogentry',
    'ServiceComputeLoggingCloudfile',
    'ServiceComputeLoggingDatadog',
    'ServiceComputeLoggingDigitalocean',
    'ServiceComputeLoggingElasticsearch',
    'ServiceComputeLoggingFtp',
    'ServiceComputeLoggingGooglepubsub',
    'ServiceComputeLoggingHeroku',
    'ServiceComputeLoggingHoneycomb',
    'ServiceComputeLoggingKafka',
    'ServiceComputeLoggingLoggly',
    'ServiceComputeLoggingLogshuttle',
    'ServiceComputeLoggingNewrelic',
    'ServiceComputeLoggingOpenstack',
    'ServiceComputeLoggingScalyr',
    'ServiceComputeLoggingSftp',
    'ServiceComputePackage',
    'ServiceComputePapertrail',
    'ServiceComputeS3logging',
    'ServiceComputeSplunk',
    'ServiceComputeSumologic',
    'ServiceComputeSyslog',
    'ServiceWafConfigurationRule',
    'Servicev1Acl',
    'Servicev1Backend',
    'Servicev1Bigquerylogging',
    'Servicev1Blobstoragelogging',
    'Servicev1CacheSetting',
    'Servicev1Condition',
    'Servicev1Dictionary',
    'Servicev1Director',
    'Servicev1Domain',
    'Servicev1Dynamicsnippet',
    'Servicev1Gcslogging',
    'Servicev1Gzip',
    'Servicev1Header',
    'Servicev1Healthcheck',
    'Servicev1Httpslogging',
    'Servicev1Logentry',
    'Servicev1LoggingCloudfile',
    'Servicev1LoggingDatadog',
    'Servicev1LoggingDigitalocean',
    'Servicev1LoggingElasticsearch',
    'Servicev1LoggingFtp',
    'Servicev1LoggingGooglepubsub',
    'Servicev1LoggingHeroku',
    'Servicev1LoggingHoneycomb',
    'Servicev1LoggingKafka',
    'Servicev1LoggingLoggly',
    'Servicev1LoggingLogshuttle',
    'Servicev1LoggingNewrelic',
    'Servicev1LoggingOpenstack',
    'Servicev1LoggingScalyr',
    'Servicev1LoggingSftp',
    'Servicev1Papertrail',
    'Servicev1RequestSetting',
    'Servicev1ResponseObject',
    'Servicev1S3logging',
    'Servicev1Snippet',
    'Servicev1Splunk',
    'Servicev1Sumologic',
    'Servicev1Syslog',
    'Servicev1Vcl',
    'Servicev1Waf',
    'GetWafRulesRuleResult',
]

@pulumi.output_type
class ServiceACLEntriesv1Entry(dict):
    def __init__(__self__, *,
                 ip: str,
                 comment: Optional[str] = None,
                 id: Optional[str] = None,
                 negated: Optional[bool] = None,
                 subnet: Optional[str] = None):
        """
        :param str ip: An IP address that is the focus for the ACL
        :param str comment: A personal freeform descriptive note
        :param bool negated: A boolean that will negate the match if true
        :param str subnet: An optional subnet mask applied to the IP address
        """
        pulumi.set(__self__, "ip", ip)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        An IP address that is the focus for the ACL
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        A personal freeform descriptive note
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def negated(self) -> Optional[bool]:
        """
        A boolean that will negate the match if true
        """
        return pulumi.get(self, "negated")

    @property
    @pulumi.getter
    def subnet(self) -> Optional[str]:
        """
        An optional subnet mask applied to the IP address
        """
        return pulumi.get(self, "subnet")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeBackend(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 auto_loadbalance: Optional[bool] = None,
                 between_bytes_timeout: Optional[float] = None,
                 connect_timeout: Optional[float] = None,
                 error_threshold: Optional[float] = None,
                 first_byte_timeout: Optional[float] = None,
                 healthcheck: Optional[str] = None,
                 max_conn: Optional[float] = None,
                 max_tls_version: Optional[str] = None,
                 min_tls_version: Optional[str] = None,
                 override_host: Optional[str] = None,
                 port: Optional[float] = None,
                 shield: Optional[str] = None,
                 ssl_ca_cert: Optional[str] = None,
                 ssl_cert_hostname: Optional[str] = None,
                 ssl_check_cert: Optional[bool] = None,
                 ssl_ciphers: Optional[str] = None,
                 ssl_client_cert: Optional[str] = None,
                 ssl_client_key: Optional[str] = None,
                 ssl_hostname: Optional[str] = None,
                 ssl_sni_hostname: Optional[str] = None,
                 use_ssl: Optional[bool] = None,
                 weight: Optional[float] = None):
        """
        :param str address: The SFTP address to stream logs to.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param bool auto_loadbalance: Denotes if this Backend should be
               included in the pool of backends that requests are load balanced against.
               Default `true`.
        :param float between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`.
        :param float connect_timeout: How long to wait for a timeout in milliseconds.
               Default `1000`
        :param float error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`.
        :param float first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`.
        :param str healthcheck: Name of a defined `healthcheck` to assign to this backend.
        :param float max_conn: Maximum number of connections for this Backend.
               Default `200`.
        :param str max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param str min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param str override_host: The hostname to override the Host header.
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param str shield: The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response.
        :param str ssl_ca_cert: CA certificate attached to origin.
        :param str ssl_cert_hostname: Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all.
        :param bool ssl_check_cert: Be strict about checking SSL certs. Default `true`.
        :param str ssl_ciphers: Comma separated list of OpenSSL Ciphers to try when negotiating to the backend.
        :param str ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend.
        :param str ssl_client_key: Client key attached to origin. Used when connecting to the backend.
        :param str ssl_hostname: Used for both SNI during the TLS handshake and to validate the cert.
        :param str ssl_sni_hostname: Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all.
        :param bool use_ssl: Whether or not to use SSL to reach the backend. Default `false`.
        :param float weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives `weight / total` of the traffic. Default `100`.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if auto_loadbalance is not None:
            pulumi.set(__self__, "auto_loadbalance", auto_loadbalance)
        if between_bytes_timeout is not None:
            pulumi.set(__self__, "between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if first_byte_timeout is not None:
            pulumi.set(__self__, "first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if max_conn is not None:
            pulumi.set(__self__, "max_conn", max_conn)
        if max_tls_version is not None:
            pulumi.set(__self__, "max_tls_version", max_tls_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if override_host is not None:
            pulumi.set(__self__, "override_host", override_host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if ssl_ca_cert is not None:
            pulumi.set(__self__, "ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            pulumi.set(__self__, "ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            pulumi.set(__self__, "ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            pulumi.set(__self__, "ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            pulumi.set(__self__, "ssl_client_key", ssl_client_key)
        if ssl_hostname is not None:
            pulumi.set(__self__, "ssl_hostname", ssl_hostname)
        if ssl_sni_hostname is not None:
            pulumi.set(__self__, "ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="autoLoadbalance")
    def auto_loadbalance(self) -> Optional[bool]:
        """
        Denotes if this Backend should be
        included in the pool of backends that requests are load balanced against.
        Default `true`.
        """
        return pulumi.get(self, "auto_loadbalance")

    @property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[float]:
        """
        How long to wait between bytes in milliseconds. Default `10000`.
        """
        return pulumi.get(self, "between_bytes_timeout")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[float]:
        """
        How long to wait for a timeout in milliseconds.
        Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[float]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`.
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[float]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`.
        """
        return pulumi.get(self, "first_byte_timeout")

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[str]:
        """
        Name of a defined `healthcheck` to assign to this backend.
        """
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[float]:
        """
        Maximum number of connections for this Backend.
        Default `200`.
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[str]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[str]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[str]:
        """
        The hostname to override the Host header.
        """
        return pulumi.get(self, "override_host")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        The POP of the shield designated to reduce inbound load. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response.
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[str]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[str]:
        """
        Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all.
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[bool]:
        """
        Be strict about checking SSL certs. Default `true`.
        """
        return pulumi.get(self, "ssl_check_cert")

    @property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[str]:
        """
        Comma separated list of OpenSSL Ciphers to try when negotiating to the backend.
        """
        return pulumi.get(self, "ssl_ciphers")

    @property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[str]:
        """
        Client certificate attached to origin. Used when connecting to the backend.
        """
        return pulumi.get(self, "ssl_client_cert")

    @property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[str]:
        """
        Client key attached to origin. Used when connecting to the backend.
        """
        return pulumi.get(self, "ssl_client_key")

    @property
    @pulumi.getter(name="sslHostname")
    def ssl_hostname(self) -> Optional[str]:
        """
        Used for both SNI during the TLS handshake and to validate the cert.
        """
        return pulumi.get(self, "ssl_hostname")

    @property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[str]:
        """
        Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all.
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[bool]:
        """
        Whether or not to use SSL to reach the backend. Default `false`.
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter
    def weight(self) -> Optional[float]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives `weight / total` of the traffic. Default `100`.
        """
        return pulumi.get(self, "weight")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeBigquerylogging(dict):
    def __init__(__self__, *,
                 dataset: str,
                 email: str,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 table: str,
                 template: Optional[str] = None):
        """
        :param str dataset: The Honeycomb Dataset you want to log to.
        :param str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str project_id: The ID of your Google Cloud Platform project.
        :param str secret_key: Your DigitalOcean Spaces account secret key.
        :param str table: The ID of your BigQuery table.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "table", table)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The Honeycomb Dataset you want to log to.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your Google Cloud Platform project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your DigitalOcean Spaces account secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        The ID of your BigQuery table.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        return pulumi.get(self, "template")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeBlobstoragelogging(dict):
    def __init__(__self__, *,
                 account_name: str,
                 container: str,
                 name: str,
                 sas_token: str,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str account_name: The unique Azure Blob Storage namespace in which your data objects are stored.
        :param str container: The name of the Azure Blob Storage container in which to store logs.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work.
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sas_token", sas_token)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the Azure Blob Storage container in which to store logs.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> str:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work.
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeDomain(dict):
    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str comment: An optional comment about the Domain.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        An optional comment about the Domain.
        """
        return pulumi.get(self, "comment")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeGcslogging(dict):
    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 email: Optional[str] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str bucket_name: The name of your Cloud Files container.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable.
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str secret_key: Your DigitalOcean Spaces account secret key.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        Your DigitalOcean Spaces account secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeHealthcheck(dict):
    def __init__(__self__, *,
                 host: str,
                 name: str,
                 path: str,
                 check_interval: Optional[float] = None,
                 expected_response: Optional[float] = None,
                 http_version: Optional[str] = None,
                 initial: Optional[float] = None,
                 method: Optional[str] = None,
                 threshold: Optional[float] = None,
                 timeout: Optional[float] = None,
                 window: Optional[float] = None):
        """
        :param str host: The Host header to send for this Healthcheck.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str path: The path to upload logs to.
        :param float check_interval: How often to run the Healthcheck in milliseconds. Default `5000`.
        :param float expected_response: The status code expected from the host. Default `200`.
        :param str http_version: Whether to use version 1.0 or 1.1 HTTP. Default `1.1`.
        :param float initial: When loading a config, the initial number of probes to be seen as OK. Default `2`.
        :param str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`.
        :param float threshold: How many Healthchecks must succeed to be considered healthy. Default `3`.
        :param float timeout: Timeout in milliseconds. Default `500`.
        :param float window: The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if expected_response is not None:
            pulumi.set(__self__, "expected_response", expected_response)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if initial is not None:
            pulumi.set(__self__, "initial", initial)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The Host header to send for this Healthcheck.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[float]:
        """
        How often to run the Healthcheck in milliseconds. Default `5000`.
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="expectedResponse")
    def expected_response(self) -> Optional[float]:
        """
        The status code expected from the host. Default `200`.
        """
        return pulumi.get(self, "expected_response")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[str]:
        """
        Whether to use version 1.0 or 1.1 HTTP. Default `1.1`.
        """
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter
    def initial(self) -> Optional[float]:
        """
        When loading a config, the initial number of probes to be seen as OK. Default `2`.
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        How many Healthchecks must succeed to be considered healthy. Default `3`.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[float]:
        """
        Timeout in milliseconds. Default `500`.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def window(self) -> Optional[float]:
        """
        The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`.
        """
        return pulumi.get(self, "window")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeHttpslogging(dict):
    def __init__(__self__, *,
                 name: str,
                 url: str,
                 content_type: Optional[str] = None,
                 header_name: Optional[str] = None,
                 header_value: Optional[str] = None,
                 json_format: Optional[str] = None,
                 message_type: Optional[str] = None,
                 method: Optional[str] = None,
                 request_max_bytes: Optional[float] = None,
                 request_max_entries: Optional[float] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str url: Your OpenStack auth url.
        :param str content_type: Value of the `Content-Type` header sent with the request.
        :param str header_name: Custom header sent with the request.
        :param str header_value: Value of the custom header sent with the request.
        :param str json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`.
        :param float request_max_bytes: The maximum number of bytes sent in one request. Defaults to `0` for unbounded.
        :param float request_max_entries: The maximum number of logs sent in one request. Defaults to `0` for unbounded.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format.
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if json_format is not None:
            pulumi.set(__self__, "json_format", json_format)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        Value of the `Content-Type` header sent with the request.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[str]:
        """
        Custom header sent with the request.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[str]:
        """
        Value of the custom header sent with the request.
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[str]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`).
        """
        return pulumi.get(self, "json_format")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[float]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded.
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[float]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded.
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format.
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        return pulumi.get(self, "tls_hostname")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLogentry(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 port: Optional[float] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str token: The data authentication token associated with this endpoint.
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param bool use_tls: Whether to use TLS for secure logging. Can be either true or false.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Can be either true or false.
        """
        return pulumi.get(self, "use_tls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingCloudfile(dict):
    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 user: str,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 public_key: Optional[str] = None,
                 region: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your Cloud File account access key.
        :param str bucket_name: The name of your Cloud Files container.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str user: The username for your Cloud Files account.
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your Cloud File account access key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingDatadog(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 region: Optional[str] = None):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str token: The data authentication token associated with this endpoint.
        :param str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        """
        return pulumi.get(self, "region")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingDigitalocean(dict):
    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 secret_key: str,
                 domain: Optional[str] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your Cloud File account access key.
        :param str bucket_name: The name of your Cloud Files container.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str secret_key: Your DigitalOcean Spaces account secret key.
        :param str domain: The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your Cloud File account access key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your DigitalOcean Spaces account secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingElasticsearch(dict):
    def __init__(__self__, *,
                 index: str,
                 name: str,
                 url: str,
                 password: Optional[str] = None,
                 pipeline: Optional[str] = None,
                 request_max_bytes: Optional[float] = None,
                 request_max_entries: Optional[float] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str index: The name of the Elasticsearch index to send documents (logs) to.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str url: Your OpenStack auth url.
        :param str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        :param str pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing.
        :param float request_max_bytes: The maximum number of bytes sent in one request. Defaults to `0` for unbounded.
        :param float request_max_entries: The maximum number of logs sent in one request. Defaults to `0` for unbounded.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format.
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        :param str user: The username for your Cloud Files account.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def index(self) -> str:
        """
        The name of the Elasticsearch index to send documents (logs) to.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[str]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing.
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[float]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded.
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[float]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded.
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format.
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingFtp(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 password: str,
                 path: str,
                 user: str,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 period: Optional[float] = None,
                 port: Optional[float] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The SFTP address to stream logs to.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        :param str path: The path to upload logs to.
        :param str user: The username for your Cloud Files account.
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "user", user)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingGooglepubsub(dict):
    def __init__(__self__, *,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 topic: str,
                 user: str):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str project_id: The ID of your Google Cloud Platform project.
        :param str secret_key: Your DigitalOcean Spaces account secret key.
        :param str topic: The Kafka topic to send logs to.
        :param str user: The username for your Cloud Files account.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your Google Cloud Platform project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your DigitalOcean Spaces account secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kafka topic to send logs to.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingHeroku(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str token: The data authentication token associated with this endpoint.
        :param str url: Your OpenStack auth url.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingHoneycomb(dict):
    def __init__(__self__, *,
                 dataset: str,
                 name: str,
                 token: str):
        """
        :param str dataset: The Honeycomb Dataset you want to log to.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str token: The data authentication token associated with this endpoint.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The Honeycomb Dataset you want to log to.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingKafka(dict):
    def __init__(__self__, *,
                 brokers: str,
                 name: str,
                 topic: str,
                 compression_codec: Optional[str] = None,
                 required_acks: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str topic: The Kafka topic to send logs to.
        :param str compression_codec: The codec used for compression of your logs. One of: gzip, snappy, lz4.
        :param str required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: 1 (default) One server needs to respond. 0 No servers need to respond. -1	Wait for all in-sync replicas to respond.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format.
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        :param bool use_tls: Whether to use TLS for secure logging. Can be either true or false.
        """
        pulumi.set(__self__, "brokers", brokers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if required_acks is not None:
            pulumi.set(__self__, "required_acks", required_acks)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def brokers(self) -> str:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers.
        """
        return pulumi.get(self, "brokers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kafka topic to send logs to.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. One of: gzip, snappy, lz4.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[str]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: 1 (default) One server needs to respond. 0 No servers need to respond. -1	Wait for all in-sync replicas to respond.
        """
        return pulumi.get(self, "required_acks")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format.
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Can be either true or false.
        """
        return pulumi.get(self, "use_tls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingLoggly(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str token: The data authentication token associated with this endpoint.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingLogshuttle(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str token: The data authentication token associated with this endpoint.
        :param str url: Your OpenStack auth url.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingNewrelic(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str token: The data authentication token associated with this endpoint.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingOpenstack(dict):
    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 url: str,
                 user: str,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 public_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your Cloud File account access key.
        :param str bucket_name: The name of your Cloud Files container.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str url: Your OpenStack auth url.
        :param str user: The username for your Cloud Files account.
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your Cloud File account access key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingScalyr(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 region: Optional[str] = None):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str token: The data authentication token associated with this endpoint.
        :param str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        """
        return pulumi.get(self, "region")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeLoggingSftp(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 path: str,
                 ssh_known_hosts: str,
                 user: str,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 password: Optional[str] = None,
                 period: Optional[float] = None,
                 port: Optional[float] = None,
                 public_key: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The SFTP address to stream logs to.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str path: The path to upload logs to.
        :param str ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP.
        :param str user: The username for your Cloud Files account.
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str secret_key: Your DigitalOcean Spaces account secret key.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        pulumi.set(__self__, "user", user)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> str:
        """
        A list of host keys for all hosts we can connect to over SFTP.
        """
        return pulumi.get(self, "ssh_known_hosts")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        Your DigitalOcean Spaces account secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputePackage(dict):
    def __init__(__self__, *,
                 filename: str,
                 source_code_hash: Optional[str] = None):
        """
        :param str filename: The path to the Wasm deployment package within your local filesystem.
        """
        pulumi.set(__self__, "filename", filename)
        if source_code_hash is not None:
            pulumi.set(__self__, "source_code_hash", source_code_hash)

    @property
    @pulumi.getter
    def filename(self) -> str:
        """
        The path to the Wasm deployment package within your local filesystem.
        """
        return pulumi.get(self, "filename")

    @property
    @pulumi.getter(name="sourceCodeHash")
    def source_code_hash(self) -> Optional[str]:
        return pulumi.get(self, "source_code_hash")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputePapertrail(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 port: float):
        """
        :param str address: The SFTP address to stream logs to.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param float port: The port the SFTP service listens on. (Default: `22`).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeS3logging(dict):
    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 domain: Optional[str] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 public_key: Optional[str] = None,
                 redundancy: Optional[str] = None,
                 s3_access_key: Optional[str] = None,
                 s3_secret_key: Optional[str] = None,
                 server_side_encryption: Optional[str] = None,
                 server_side_encryption_kms_key_id: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str bucket_name: The name of your Cloud Files container.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str domain: The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str redundancy: The S3 redundancy level. Should be formatted; one of: `standard`, `reduced_redundancy` or null. Default `null`.
        :param str s3_access_key: AWS Access Key of an account with the required
               permissions to post logs. It is **strongly** recommended you create a separate
               IAM user with permissions to only operate on this Bucket. This key will be
               not be encrypted. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`.
        :param str s3_secret_key: AWS Secret Key of an account with the required
               permissions to post logs. It is **strongly** recommended you create a separate
               IAM user with permissions to only operate on this Bucket. This secret will be
               not be encrypted. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if s3_access_key is not None:
            pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_secret_key is not None:
            pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[str]:
        """
        The S3 redundancy level. Should be formatted; one of: `standard`, `reduced_redundancy` or null. Default `null`.
        """
        return pulumi.get(self, "redundancy")

    @property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[str]:
        """
        AWS Access Key of an account with the required
        permissions to post logs. It is **strongly** recommended you create a separate
        IAM user with permissions to only operate on this Bucket. This key will be
        not be encrypted. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`.
        """
        return pulumi.get(self, "s3_access_key")

    @property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[str]:
        """
        AWS Secret Key of an account with the required
        permissions to post logs. It is **strongly** recommended you create a separate
        IAM user with permissions to only operate on this Bucket. This secret will be
        not be encrypted. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`.
        """
        return pulumi.get(self, "s3_secret_key")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[str]:
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[str]:
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeSplunk(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 tls_ca_cert: Optional[str] = None,
                 tls_hostname: Optional[str] = None):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str token: The data authentication token associated with this endpoint.
        :param str url: Your OpenStack auth url.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format.
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        return pulumi.get(self, "tls_hostname")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeSumologic(dict):
    def __init__(__self__, *,
                 name: str,
                 url: str,
                 message_type: Optional[str] = None):
        """
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str url: Your OpenStack auth url.
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceComputeSyslog(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 message_type: Optional[str] = None,
                 port: Optional[float] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 token: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str address: The SFTP address to stream logs to.
        :param str name: The unique name of the Rackspace Cloud Files logging endpoint.
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format.
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        :param str token: The data authentication token associated with this endpoint.
        :param bool use_tls: Whether to use TLS for secure logging. Can be either true or false.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique name of the Rackspace Cloud Files logging endpoint.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format.
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Can be either true or false.
        """
        return pulumi.get(self, "use_tls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceWafConfigurationRule(dict):
    def __init__(__self__, *,
                 modsec_rule_id: float,
                 status: str,
                 revision: Optional[float] = None):
        """
        :param float modsec_rule_id: The Web Application Firewall rule's modsecurity ID.
        :param str status: The Web Application Firewall rule's status. Allowed values are (`log`, `block` and `score`).
        :param float revision: The Web Application Firewall rule's revision. The latest revision will be used if this is not provided.
        """
        pulumi.set(__self__, "modsec_rule_id", modsec_rule_id)
        pulumi.set(__self__, "status", status)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter(name="modsecRuleId")
    def modsec_rule_id(self) -> float:
        """
        The Web Application Firewall rule's modsecurity ID.
        """
        return pulumi.get(self, "modsec_rule_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The Web Application Firewall rule's status. Allowed values are (`log`, `block` and `score`).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def revision(self) -> Optional[float]:
        """
        The Web Application Firewall rule's revision. The latest revision will be used if this is not provided.
        """
        return pulumi.get(self, "revision")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Acl(dict):
    def __init__(__self__, *,
                 name: str,
                 acl_id: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str acl_id: The ID of the ACL.
        """
        pulumi.set(__self__, "name", name)
        if acl_id is not None:
            pulumi.set(__self__, "acl_id", acl_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="aclId")
    def acl_id(self) -> Optional[str]:
        """
        The ID of the ACL.
        """
        return pulumi.get(self, "acl_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Backend(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 auto_loadbalance: Optional[bool] = None,
                 between_bytes_timeout: Optional[float] = None,
                 connect_timeout: Optional[float] = None,
                 error_threshold: Optional[float] = None,
                 first_byte_timeout: Optional[float] = None,
                 healthcheck: Optional[str] = None,
                 max_conn: Optional[float] = None,
                 max_tls_version: Optional[str] = None,
                 min_tls_version: Optional[str] = None,
                 override_host: Optional[str] = None,
                 port: Optional[float] = None,
                 request_condition: Optional[str] = None,
                 shield: Optional[str] = None,
                 ssl_ca_cert: Optional[str] = None,
                 ssl_cert_hostname: Optional[str] = None,
                 ssl_check_cert: Optional[bool] = None,
                 ssl_ciphers: Optional[str] = None,
                 ssl_client_cert: Optional[str] = None,
                 ssl_client_key: Optional[str] = None,
                 ssl_hostname: Optional[str] = None,
                 ssl_sni_hostname: Optional[str] = None,
                 use_ssl: Optional[bool] = None,
                 weight: Optional[float] = None):
        """
        :param str address: The SFTP address to stream logs to.
        :param str name: A unique name to identify this dictionary.
        :param bool auto_loadbalance: Denotes if this Backend should be
               included in the pool of backends that requests are load balanced against.
               Default `true`.
        :param float between_bytes_timeout: How long to wait between bytes in milliseconds. Default `10000`.
        :param float connect_timeout: How long to wait for a timeout in milliseconds.
               Default `1000`
        :param float error_threshold: Number of errors to allow before the Backend is marked as down. Default `0`.
        :param float first_byte_timeout: How long to wait for the first bytes in milliseconds. Default `15000`.
        :param str healthcheck: Name of a defined `healthcheck` to assign to this backend.
        :param float max_conn: Maximum number of connections for this Backend.
               Default `200`.
        :param str max_tls_version: Maximum allowed TLS version on SSL connections to this backend.
        :param str min_tls_version: Minimum allowed TLS version on SSL connections to this backend.
        :param str override_host: The hostname to override the Host header.
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param str request_condition: Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`.
        :param str shield: Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response.
        :param str ssl_ca_cert: CA certificate attached to origin.
        :param str ssl_cert_hostname: Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all.
        :param bool ssl_check_cert: Be strict about checking SSL certs. Default `true`.
        :param str ssl_ciphers: Comma separated list of OpenSSL Ciphers to try when negotiating to the backend.
        :param str ssl_client_cert: Client certificate attached to origin. Used when connecting to the backend.
        :param str ssl_client_key: Client key attached to origin. Used when connecting to the backend.
        :param str ssl_hostname: Used for both SNI during the TLS handshake and to validate the cert.
        :param str ssl_sni_hostname: Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all.
        :param bool use_ssl: Whether or not to use SSL to reach the backend. Default `false`.
        :param float weight: The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives `weight / total` of the traffic. Default `100`.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if auto_loadbalance is not None:
            pulumi.set(__self__, "auto_loadbalance", auto_loadbalance)
        if between_bytes_timeout is not None:
            pulumi.set(__self__, "between_bytes_timeout", between_bytes_timeout)
        if connect_timeout is not None:
            pulumi.set(__self__, "connect_timeout", connect_timeout)
        if error_threshold is not None:
            pulumi.set(__self__, "error_threshold", error_threshold)
        if first_byte_timeout is not None:
            pulumi.set(__self__, "first_byte_timeout", first_byte_timeout)
        if healthcheck is not None:
            pulumi.set(__self__, "healthcheck", healthcheck)
        if max_conn is not None:
            pulumi.set(__self__, "max_conn", max_conn)
        if max_tls_version is not None:
            pulumi.set(__self__, "max_tls_version", max_tls_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if override_host is not None:
            pulumi.set(__self__, "override_host", override_host)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if ssl_ca_cert is not None:
            pulumi.set(__self__, "ssl_ca_cert", ssl_ca_cert)
        if ssl_cert_hostname is not None:
            pulumi.set(__self__, "ssl_cert_hostname", ssl_cert_hostname)
        if ssl_check_cert is not None:
            pulumi.set(__self__, "ssl_check_cert", ssl_check_cert)
        if ssl_ciphers is not None:
            pulumi.set(__self__, "ssl_ciphers", ssl_ciphers)
        if ssl_client_cert is not None:
            pulumi.set(__self__, "ssl_client_cert", ssl_client_cert)
        if ssl_client_key is not None:
            pulumi.set(__self__, "ssl_client_key", ssl_client_key)
        if ssl_hostname is not None:
            pulumi.set(__self__, "ssl_hostname", ssl_hostname)
        if ssl_sni_hostname is not None:
            pulumi.set(__self__, "ssl_sni_hostname", ssl_sni_hostname)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="autoLoadbalance")
    def auto_loadbalance(self) -> Optional[bool]:
        """
        Denotes if this Backend should be
        included in the pool of backends that requests are load balanced against.
        Default `true`.
        """
        return pulumi.get(self, "auto_loadbalance")

    @property
    @pulumi.getter(name="betweenBytesTimeout")
    def between_bytes_timeout(self) -> Optional[float]:
        """
        How long to wait between bytes in milliseconds. Default `10000`.
        """
        return pulumi.get(self, "between_bytes_timeout")

    @property
    @pulumi.getter(name="connectTimeout")
    def connect_timeout(self) -> Optional[float]:
        """
        How long to wait for a timeout in milliseconds.
        Default `1000`
        """
        return pulumi.get(self, "connect_timeout")

    @property
    @pulumi.getter(name="errorThreshold")
    def error_threshold(self) -> Optional[float]:
        """
        Number of errors to allow before the Backend is marked as down. Default `0`.
        """
        return pulumi.get(self, "error_threshold")

    @property
    @pulumi.getter(name="firstByteTimeout")
    def first_byte_timeout(self) -> Optional[float]:
        """
        How long to wait for the first bytes in milliseconds. Default `15000`.
        """
        return pulumi.get(self, "first_byte_timeout")

    @property
    @pulumi.getter
    def healthcheck(self) -> Optional[str]:
        """
        Name of a defined `healthcheck` to assign to this backend.
        """
        return pulumi.get(self, "healthcheck")

    @property
    @pulumi.getter(name="maxConn")
    def max_conn(self) -> Optional[float]:
        """
        Maximum number of connections for this Backend.
        Default `200`.
        """
        return pulumi.get(self, "max_conn")

    @property
    @pulumi.getter(name="maxTlsVersion")
    def max_tls_version(self) -> Optional[str]:
        """
        Maximum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "max_tls_version")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[str]:
        """
        Minimum allowed TLS version on SSL connections to this backend.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter(name="overrideHost")
    def override_host(self) -> Optional[str]:
        """
        The hostname to override the Host header.
        """
        return pulumi.get(self, "override_host")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`.
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response.
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter(name="sslCaCert")
    def ssl_ca_cert(self) -> Optional[str]:
        """
        CA certificate attached to origin.
        """
        return pulumi.get(self, "ssl_ca_cert")

    @property
    @pulumi.getter(name="sslCertHostname")
    def ssl_cert_hostname(self) -> Optional[str]:
        """
        Overrides ssl_hostname, but only for cert verification. Does not affect SNI at all.
        """
        return pulumi.get(self, "ssl_cert_hostname")

    @property
    @pulumi.getter(name="sslCheckCert")
    def ssl_check_cert(self) -> Optional[bool]:
        """
        Be strict about checking SSL certs. Default `true`.
        """
        return pulumi.get(self, "ssl_check_cert")

    @property
    @pulumi.getter(name="sslCiphers")
    def ssl_ciphers(self) -> Optional[str]:
        """
        Comma separated list of OpenSSL Ciphers to try when negotiating to the backend.
        """
        return pulumi.get(self, "ssl_ciphers")

    @property
    @pulumi.getter(name="sslClientCert")
    def ssl_client_cert(self) -> Optional[str]:
        """
        Client certificate attached to origin. Used when connecting to the backend.
        """
        return pulumi.get(self, "ssl_client_cert")

    @property
    @pulumi.getter(name="sslClientKey")
    def ssl_client_key(self) -> Optional[str]:
        """
        Client key attached to origin. Used when connecting to the backend.
        """
        return pulumi.get(self, "ssl_client_key")

    @property
    @pulumi.getter(name="sslHostname")
    def ssl_hostname(self) -> Optional[str]:
        """
        Used for both SNI during the TLS handshake and to validate the cert.
        """
        return pulumi.get(self, "ssl_hostname")

    @property
    @pulumi.getter(name="sslSniHostname")
    def ssl_sni_hostname(self) -> Optional[str]:
        """
        Overrides ssl_hostname, but only for SNI in the handshake. Does not affect cert validation at all.
        """
        return pulumi.get(self, "ssl_sni_hostname")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[bool]:
        """
        Whether or not to use SSL to reach the backend. Default `false`.
        """
        return pulumi.get(self, "use_ssl")

    @property
    @pulumi.getter
    def weight(self) -> Optional[float]:
        """
        The [portion of traffic](https://docs.fastly.com/en/guides/load-balancing-configuration#how-weight-affects-load-balancing) to send to this Backend. Each Backend receives `weight / total` of the traffic. Default `100`.
        """
        return pulumi.get(self, "weight")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Bigquerylogging(dict):
    def __init__(__self__, *,
                 dataset: str,
                 email: str,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 table: str,
                 format: Optional[str] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 template: Optional[str] = None):
        """
        :param str dataset: The Honeycomb Dataset you want to log to.
        :param str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable.
        :param str name: A unique name to identify this dictionary.
        :param str project_id: The ID of your Google Cloud Platform project.
        :param str secret_key: Your DigitalOcean Spaces account secret key.
        :param str table: The ID of your BigQuery table.
        :param str format: Apache style log formatting.
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str template: Big query table name suffix template. If set will be interpreted as a strftime compatible string and used as the [Template Suffix for your table](https://cloud.google.com/bigquery/streaming-data-into-bigquery#template-tables).
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "table", table)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The Honeycomb Dataset you want to log to.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your Google Cloud Platform project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your DigitalOcean Spaces account secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        The ID of your BigQuery table.
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter
    def template(self) -> Optional[str]:
        """
        Big query table name suffix template. If set will be interpreted as a strftime compatible string and used as the [Template Suffix for your table](https://cloud.google.com/bigquery/streaming-data-into-bigquery#template-tables).
        """
        return pulumi.get(self, "template")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Blobstoragelogging(dict):
    def __init__(__self__, *,
                 account_name: str,
                 container: str,
                 name: str,
                 sas_token: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str account_name: The unique Azure Blob Storage namespace in which your data objects are stored.
        :param str container: The name of the Azure Blob Storage container in which to store logs.
        :param str name: A unique name to identify this dictionary.
        :param str sas_token: The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sas_token", sas_token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        The unique Azure Blob Storage namespace in which your data objects are stored.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The name of the Azure Blob Storage container in which to store logs.
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sasToken")
    def sas_token(self) -> str:
        """
        The Azure shared access signature providing write access to the blob service objects. Be sure to update your token before it expires or the logging functionality will not work.
        """
        return pulumi.get(self, "sas_token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1CacheSetting(dict):
    def __init__(__self__, *,
                 name: str,
                 action: Optional[str] = None,
                 cache_condition: Optional[str] = None,
                 stale_ttl: Optional[float] = None,
                 ttl: Optional[float] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str action: Allows you to terminate request handling and immediately
               perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely).
        :param str cache_condition: Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals,
               see [Fastly's Documentation on Conditionals][fastly-conditionals].
        :param float stale_ttl: Max "Time To Live" for stale (unreachable) objects.
        :param float ttl: The Time-To-Live (TTL) for the object.
        """
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if stale_ttl is not None:
            pulumi.set(__self__, "stale_ttl", stale_ttl)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Allows you to terminate request handling and immediately
        perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely).
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals,
        see [Fastly's Documentation on Conditionals][fastly-conditionals].
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="staleTtl")
    def stale_ttl(self) -> Optional[float]:
        """
        Max "Time To Live" for stale (unreachable) objects.
        """
        return pulumi.get(self, "stale_ttl")

    @property
    @pulumi.getter
    def ttl(self) -> Optional[float]:
        """
        The Time-To-Live (TTL) for the object.
        """
        return pulumi.get(self, "ttl")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Condition(dict):
    def __init__(__self__, *,
                 name: str,
                 statement: str,
                 type: str,
                 priority: Optional[float] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str statement: The statement used to determine if the condition is met.
        :param str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`).
        :param float priority: Priority determines the ordering for multiple snippets. Lower numbers execute first.  Defaults to `100`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "statement", statement)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def statement(self) -> str:
        """
        The statement used to determine if the condition is met.
        """
        return pulumi.get(self, "statement")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[float]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first.  Defaults to `100`.
        """
        return pulumi.get(self, "priority")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Dictionary(dict):
    def __init__(__self__, *,
                 name: str,
                 dictionary_id: Optional[str] = None,
                 write_only: Optional[bool] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str dictionary_id: The ID of the dictionary.
        :param bool write_only: If `true`, the dictionary is a private dictionary, and items are not readable in the UI or
               via API. Default is `false`. It is important to note that changing this attribute will delete and recreate the
               dictionary, discard the current items in the dictionary. Using a write-only/private dictionary should only be done if
               the items are managed outside of the provider.
        """
        pulumi.set(__self__, "name", name)
        if dictionary_id is not None:
            pulumi.set(__self__, "dictionary_id", dictionary_id)
        if write_only is not None:
            pulumi.set(__self__, "write_only", write_only)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="dictionaryId")
    def dictionary_id(self) -> Optional[str]:
        """
        The ID of the dictionary.
        """
        return pulumi.get(self, "dictionary_id")

    @property
    @pulumi.getter(name="writeOnly")
    def write_only(self) -> Optional[bool]:
        """
        If `true`, the dictionary is a private dictionary, and items are not readable in the UI or
        via API. Default is `false`. It is important to note that changing this attribute will delete and recreate the
        dictionary, discard the current items in the dictionary. Using a write-only/private dictionary should only be done if
        the items are managed outside of the provider.
        """
        return pulumi.get(self, "write_only")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Director(dict):
    def __init__(__self__, *,
                 backends: List[str],
                 name: str,
                 capacity: Optional[float] = None,
                 comment: Optional[str] = None,
                 quorum: Optional[float] = None,
                 retries: Optional[float] = None,
                 shield: Optional[str] = None,
                 type: Optional[float] = None):
        """
        :param List[str] backends: Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        :param str name: A unique name to identify this dictionary.
        :param float capacity: Load balancing weight for the backends. Default `100`.
        :param str comment: An optional comment about the Director.
        :param float quorum: Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`.
        :param float retries: How many backends to search if it fails. Default `5`.
        :param str shield: Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response.
        :param float type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`).
        """
        pulumi.set(__self__, "backends", backends)
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if quorum is not None:
            pulumi.set(__self__, "quorum", quorum)
        if retries is not None:
            pulumi.set(__self__, "retries", retries)
        if shield is not None:
            pulumi.set(__self__, "shield", shield)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def backends(self) -> List[str]:
        """
        Names of defined backends to map the director to. Example: `[ "origin1", "origin2" ]`
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def capacity(self) -> Optional[float]:
        """
        Load balancing weight for the backends. Default `100`.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        An optional comment about the Director.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def quorum(self) -> Optional[float]:
        """
        Percentage of capacity that needs to be up for the director itself to be considered up. Default `75`.
        """
        return pulumi.get(self, "quorum")

    @property
    @pulumi.getter
    def retries(self) -> Optional[float]:
        """
        How many backends to search if it fails. Default `5`.
        """
        return pulumi.get(self, "retries")

    @property
    @pulumi.getter
    def shield(self) -> Optional[str]:
        """
        Selected POP to serve as a "shield" for backends. Valid values for `shield` are included in the [`GET /datacenters`](https://developer.fastly.com/reference/api/utils/datacenter/) API response.
        """
        return pulumi.get(self, "shield")

    @property
    @pulumi.getter
    def type(self) -> Optional[float]:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`).
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Domain(dict):
    def __init__(__self__, *,
                 name: str,
                 comment: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str comment: An optional comment about the Director.
        """
        pulumi.set(__self__, "name", name)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def comment(self) -> Optional[str]:
        """
        An optional comment about the Director.
        """
        return pulumi.get(self, "comment")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Dynamicsnippet(dict):
    def __init__(__self__, *,
                 name: str,
                 type: str,
                 priority: Optional[float] = None,
                 snippet_id: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`).
        :param float priority: Priority determines the ordering for multiple snippets. Lower numbers execute first.  Defaults to `100`.
        :param str snippet_id: The ID of the dynamic snippet.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if snippet_id is not None:
            pulumi.set(__self__, "snippet_id", snippet_id)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[float]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first.  Defaults to `100`.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="snippetId")
    def snippet_id(self) -> Optional[str]:
        """
        The ID of the dynamic snippet.
        """
        return pulumi.get(self, "snippet_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Gcslogging(dict):
    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 email: Optional[str] = None,
                 format: Optional[str] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str bucket_name: The name of your Cloud Files container.
        :param str name: A unique name to identify this dictionary.
        :param str email: The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable.
        :param str format: Apache style log formatting.
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str secret_key: Your DigitalOcean Spaces account secret key.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        """
        The email for the service account with write access to your BigQuery dataset. If not provided, this will be pulled from a `FASTLY_BQ_EMAIL` environment variable.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        Your DigitalOcean Spaces account secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Gzip(dict):
    def __init__(__self__, *,
                 name: str,
                 cache_condition: Optional[str] = None,
                 content_types: Optional[List[str]] = None,
                 extensions: Optional[List[str]] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str cache_condition: Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals,
               see [Fastly's Documentation on Conditionals][fastly-conditionals].
        :param List[str] content_types: The content-type for each type of content you wish to
               have dynamically gzip'ed. Example: `["text/html", "text/css"]`.
        :param List[str] extensions: File extensions for each file type to dynamically
               gzip. Example: `["css", "js"]`.
        """
        pulumi.set(__self__, "name", name)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if content_types is not None:
            pulumi.set(__self__, "content_types", content_types)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals,
        see [Fastly's Documentation on Conditionals][fastly-conditionals].
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Optional[List[str]]:
        """
        The content-type for each type of content you wish to
        have dynamically gzip'ed. Example: `["text/html", "text/css"]`.
        """
        return pulumi.get(self, "content_types")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[List[str]]:
        """
        File extensions for each file type to dynamically
        gzip. Example: `["css", "js"]`.
        """
        return pulumi.get(self, "extensions")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Header(dict):
    def __init__(__self__, *,
                 action: str,
                 destination: str,
                 name: str,
                 type: str,
                 cache_condition: Optional[str] = None,
                 ignore_if_set: Optional[bool] = None,
                 priority: Optional[float] = None,
                 regex: Optional[str] = None,
                 request_condition: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 source: Optional[str] = None,
                 substitution: Optional[str] = None):
        """
        :param str action: Allows you to terminate request handling and immediately
               perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely).
        :param str destination: The name of the header that is going to be affected by the Action.
        :param str name: A unique name to identify this dictionary.
        :param str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`).
        :param str cache_condition: Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals,
               see [Fastly's Documentation on Conditionals][fastly-conditionals].
        :param bool ignore_if_set: Do not add the header if it is already present. (Only applies to the `set` action.). Default `false`.
        :param float priority: Priority determines the ordering for multiple snippets. Lower numbers execute first.  Defaults to `100`.
        :param str regex: Regular expression to use (Only applies to the `regex` and `regex_repeat` actions.)
        :param str request_condition: Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str source: Variable to be used as a source for the header
               content. (Does not apply to the `delete` action.)
        :param str substitution: Value to substitute in place of regular expression. (Only applies to the `regex` and `regex_repeat` actions.)
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if ignore_if_set is not None:
            pulumi.set(__self__, "ignore_if_set", ignore_if_set)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitution is not None:
            pulumi.set(__self__, "substitution", substitution)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Allows you to terminate request handling and immediately
        perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely).
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def destination(self) -> str:
        """
        The name of the header that is going to be affected by the Action.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals,
        see [Fastly's Documentation on Conditionals][fastly-conditionals].
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter(name="ignoreIfSet")
    def ignore_if_set(self) -> Optional[bool]:
        """
        Do not add the header if it is already present. (Only applies to the `set` action.). Default `false`.
        """
        return pulumi.get(self, "ignore_if_set")

    @property
    @pulumi.getter
    def priority(self) -> Optional[float]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first.  Defaults to `100`.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        Regular expression to use (Only applies to the `regex` and `regex_repeat` actions.)
        """
        return pulumi.get(self, "regex")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`.
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter
    def source(self) -> Optional[str]:
        """
        Variable to be used as a source for the header
        content. (Does not apply to the `delete` action.)
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def substitution(self) -> Optional[str]:
        """
        Value to substitute in place of regular expression. (Only applies to the `regex` and `regex_repeat` actions.)
        """
        return pulumi.get(self, "substitution")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Healthcheck(dict):
    def __init__(__self__, *,
                 host: str,
                 name: str,
                 path: str,
                 check_interval: Optional[float] = None,
                 expected_response: Optional[float] = None,
                 http_version: Optional[str] = None,
                 initial: Optional[float] = None,
                 method: Optional[str] = None,
                 threshold: Optional[float] = None,
                 timeout: Optional[float] = None,
                 window: Optional[float] = None):
        """
        :param str host: The Host header to send for this Healthcheck.
        :param str name: A unique name to identify this dictionary.
        :param str path: The path to upload logs to.
        :param float check_interval: How often to run the Healthcheck in milliseconds. Default `5000`.
        :param float expected_response: The status code expected from the host. Default `200`.
        :param str http_version: Whether to use version 1.0 or 1.1 HTTP. Default `1.1`.
        :param float initial: When loading a config, the initial number of probes to be seen as OK. Default `2`.
        :param str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`.
        :param float threshold: How many Healthchecks must succeed to be considered healthy. Default `3`.
        :param float timeout: Timeout in milliseconds. Default `500`.
        :param float window: The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if expected_response is not None:
            pulumi.set(__self__, "expected_response", expected_response)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if initial is not None:
            pulumi.set(__self__, "initial", initial)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if window is not None:
            pulumi.set(__self__, "window", window)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The Host header to send for this Healthcheck.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[float]:
        """
        How often to run the Healthcheck in milliseconds. Default `5000`.
        """
        return pulumi.get(self, "check_interval")

    @property
    @pulumi.getter(name="expectedResponse")
    def expected_response(self) -> Optional[float]:
        """
        The status code expected from the host. Default `200`.
        """
        return pulumi.get(self, "expected_response")

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[str]:
        """
        Whether to use version 1.0 or 1.1 HTTP. Default `1.1`.
        """
        return pulumi.get(self, "http_version")

    @property
    @pulumi.getter
    def initial(self) -> Optional[float]:
        """
        When loading a config, the initial number of probes to be seen as OK. Default `2`.
        """
        return pulumi.get(self, "initial")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def threshold(self) -> Optional[float]:
        """
        How many Healthchecks must succeed to be considered healthy. Default `3`.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[float]:
        """
        Timeout in milliseconds. Default `500`.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def window(self) -> Optional[float]:
        """
        The number of most recent Healthcheck queries to keep for this Healthcheck. Default `5`.
        """
        return pulumi.get(self, "window")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Httpslogging(dict):
    def __init__(__self__, *,
                 name: str,
                 url: str,
                 content_type: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 header_name: Optional[str] = None,
                 header_value: Optional[str] = None,
                 json_format: Optional[str] = None,
                 message_type: Optional[str] = None,
                 method: Optional[str] = None,
                 placement: Optional[str] = None,
                 request_max_bytes: Optional[float] = None,
                 request_max_entries: Optional[float] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str url: Your OpenStack auth url.
        :param str content_type: The MIME type of the content.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str header_name: Custom header sent with the request.
        :param str header_value: Value of the custom header sent with the request.
        :param str json_format: Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str method: HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`.
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param float request_max_bytes: The maximum number of bytes sent in one request. Defaults to `0` for unbounded.
        :param float request_max_entries: The maximum number of logs sent in one request. Defaults to `0` for unbounded.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format.
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if header_name is not None:
            pulumi.set(__self__, "header_name", header_name)
        if header_value is not None:
            pulumi.set(__self__, "header_value", header_value)
        if json_format is not None:
            pulumi.set(__self__, "json_format", json_format)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The MIME type of the content.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="headerName")
    def header_name(self) -> Optional[str]:
        """
        Custom header sent with the request.
        """
        return pulumi.get(self, "header_name")

    @property
    @pulumi.getter(name="headerValue")
    def header_value(self) -> Optional[str]:
        """
        Value of the custom header sent with the request.
        """
        return pulumi.get(self, "header_value")

    @property
    @pulumi.getter(name="jsonFormat")
    def json_format(self) -> Optional[str]:
        """
        Formats log entries as JSON. Can be either disabled (`0`), array of json (`1`), or newline delimited json (`2`).
        """
        return pulumi.get(self, "json_format")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def method(self) -> Optional[str]:
        """
        HTTP method used for request. Can be either `POST` or `PUT`. Default `POST`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[float]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded.
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[float]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded.
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format.
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        return pulumi.get(self, "tls_hostname")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Logentry(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 port: Optional[float] = None,
                 response_condition: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str token: The data authentication token associated with this endpoint.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param bool use_tls: Whether to use TLS for secure logging. Can be either true or false.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Can be either true or false.
        """
        return pulumi.get(self, "use_tls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingCloudfile(dict):
    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 user: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your Cloud File account access key.
        :param str bucket_name: The name of your Cloud Files container.
        :param str name: A unique name to identify this dictionary.
        :param str user: The username for your Cloud Files account.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "user", user)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your Cloud File account access key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingDatadog(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str token: The data authentication token associated with this endpoint.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingDigitalocean(dict):
    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 secret_key: str,
                 domain: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your Cloud File account access key.
        :param str bucket_name: The name of your Cloud Files container.
        :param str name: A unique name to identify this dictionary.
        :param str secret_key: Your DigitalOcean Spaces account secret key.
        :param str domain: The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret_key", secret_key)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your Cloud File account access key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your DigitalOcean Spaces account secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingElasticsearch(dict):
    def __init__(__self__, *,
                 index: str,
                 name: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 password: Optional[str] = None,
                 pipeline: Optional[str] = None,
                 placement: Optional[str] = None,
                 request_max_bytes: Optional[float] = None,
                 request_max_entries: Optional[float] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 user: Optional[str] = None):
        """
        :param str index: The name of the Elasticsearch index to send documents (logs) to.
        :param str name: A unique name to identify this dictionary.
        :param str url: Your OpenStack auth url.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        :param str pipeline: The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing.
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param float request_max_bytes: The maximum number of bytes sent in one request. Defaults to `0` for unbounded.
        :param float request_max_entries: The maximum number of logs sent in one request. Defaults to `0` for unbounded.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format.
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        :param str user: The username for your Cloud Files account.
        """
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if pipeline is not None:
            pulumi.set(__self__, "pipeline", pipeline)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if request_max_bytes is not None:
            pulumi.set(__self__, "request_max_bytes", request_max_bytes)
        if request_max_entries is not None:
            pulumi.set(__self__, "request_max_entries", request_max_entries)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def index(self) -> str:
        """
        The name of the Elasticsearch index to send documents (logs) to.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def pipeline(self) -> Optional[str]:
        """
        The ID of the Elasticsearch ingest pipeline to apply pre-process transformations to before indexing.
        """
        return pulumi.get(self, "pipeline")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requestMaxBytes")
    def request_max_bytes(self) -> Optional[float]:
        """
        The maximum number of bytes sent in one request. Defaults to `0` for unbounded.
        """
        return pulumi.get(self, "request_max_bytes")

    @property
    @pulumi.getter(name="requestMaxEntries")
    def request_max_entries(self) -> Optional[float]:
        """
        The maximum number of logs sent in one request. Defaults to `0` for unbounded.
        """
        return pulumi.get(self, "request_max_entries")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format.
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def user(self) -> Optional[str]:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingFtp(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 password: str,
                 path: str,
                 user: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 period: Optional[float] = None,
                 placement: Optional[str] = None,
                 port: Optional[float] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The SFTP address to stream logs to.
        :param str name: A unique name to identify this dictionary.
        :param str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        :param str path: The path to upload logs to.
        :param str user: The username for your Cloud Files account.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "user", user)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingGooglepubsub(dict):
    def __init__(__self__, *,
                 name: str,
                 project_id: str,
                 secret_key: str,
                 topic: str,
                 user: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str project_id: The ID of your Google Cloud Platform project.
        :param str secret_key: Your DigitalOcean Spaces account secret key.
        :param str topic: The Kafka topic to send logs to.
        :param str user: The username for your Cloud Files account.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "secret_key", secret_key)
        pulumi.set(__self__, "topic", topic)
        pulumi.set(__self__, "user", user)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of your Google Cloud Platform project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> str:
        """
        Your DigitalOcean Spaces account secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kafka topic to send logs to.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingHeroku(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str token: The data authentication token associated with this endpoint.
        :param str url: Your OpenStack auth url.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingHoneycomb(dict):
    def __init__(__self__, *,
                 dataset: str,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str dataset: The Honeycomb Dataset you want to log to.
        :param str name: A unique name to identify this dictionary.
        :param str token: The data authentication token associated with this endpoint.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The Honeycomb Dataset you want to log to.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingKafka(dict):
    def __init__(__self__, *,
                 brokers: str,
                 name: str,
                 topic: str,
                 compression_codec: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 required_acks: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str brokers: A comma-separated list of IP addresses or hostnames of Kafka brokers.
        :param str name: A unique name to identify this dictionary.
        :param str topic: The Kafka topic to send logs to.
        :param str compression_codec: The codec used for compression of your logs. One of: gzip, snappy, lz4.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str required_acks: The Number of acknowledgements a leader must receive before a write is considered successful. One of: 1 (default) One server needs to respond. 0 No servers need to respond. -1	Wait for all in-sync replicas to respond.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format.
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        :param bool use_tls: Whether to use TLS for secure logging. Can be either true or false.
        """
        pulumi.set(__self__, "brokers", brokers)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "topic", topic)
        if compression_codec is not None:
            pulumi.set(__self__, "compression_codec", compression_codec)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if required_acks is not None:
            pulumi.set(__self__, "required_acks", required_acks)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def brokers(self) -> str:
        """
        A comma-separated list of IP addresses or hostnames of Kafka brokers.
        """
        return pulumi.get(self, "brokers")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The Kafka topic to send logs to.
        """
        return pulumi.get(self, "topic")

    @property
    @pulumi.getter(name="compressionCodec")
    def compression_codec(self) -> Optional[str]:
        """
        The codec used for compression of your logs. One of: gzip, snappy, lz4.
        """
        return pulumi.get(self, "compression_codec")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="requiredAcks")
    def required_acks(self) -> Optional[str]:
        """
        The Number of acknowledgements a leader must receive before a write is considered successful. One of: 1 (default) One server needs to respond. 0 No servers need to respond. -1	Wait for all in-sync replicas to respond.
        """
        return pulumi.get(self, "required_acks")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format.
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Can be either true or false.
        """
        return pulumi.get(self, "use_tls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingLoggly(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str token: The data authentication token associated with this endpoint.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingLogshuttle(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str token: The data authentication token associated with this endpoint.
        :param str url: Your OpenStack auth url.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingNewrelic(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str token: The data authentication token associated with this endpoint.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingOpenstack(dict):
    def __init__(__self__, *,
                 access_key: str,
                 bucket_name: str,
                 name: str,
                 url: str,
                 user: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str access_key: Your Cloud File account access key.
        :param str bucket_name: The name of your Cloud Files container.
        :param str name: A unique name to identify this dictionary.
        :param str url: Your OpenStack auth url.
        :param str user: The username for your Cloud Files account.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "user", user)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> str:
        """
        Your Cloud File account access key.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingScalyr(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 region: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str token: The data authentication token associated with this endpoint.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str region: The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The region to stream logs to. One of: DFW (Dallas), ORD (Chicago), IAD (Northern Virginia), LON (London), SYD (Sydney), HKG (Hong Kong).
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1LoggingSftp(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 path: str,
                 ssh_known_hosts: str,
                 user: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 password: Optional[str] = None,
                 period: Optional[float] = None,
                 placement: Optional[str] = None,
                 port: Optional[float] = None,
                 public_key: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 secret_key: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str address: The SFTP address to stream logs to.
        :param str name: A unique name to identify this dictionary.
        :param str path: The path to upload logs to.
        :param str ssh_known_hosts: A list of host keys for all hosts we can connect to over SFTP.
        :param str user: The username for your Cloud Files account.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str password: The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str secret_key: Your DigitalOcean Spaces account secret key.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "ssh_known_hosts", ssh_known_hosts)
        pulumi.set(__self__, "user", user)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="sshKnownHosts")
    def ssh_known_hosts(self) -> str:
        """
        A list of host keys for all hosts we can connect to over SFTP.
        """
        return pulumi.get(self, "ssh_known_hosts")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        The username for your Cloud Files account.
        """
        return pulumi.get(self, "user")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password for the server. If both `password` and `secret_key` are passed, `secret_key` will be preferred.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[str]:
        """
        Your DigitalOcean Spaces account secret key.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Papertrail(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 port: float,
                 format: Optional[str] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str address: The SFTP address to stream logs to.
        :param str name: A unique name to identify this dictionary.
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param str format: Apache style log formatting.
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> float:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1RequestSetting(dict):
    def __init__(__self__, *,
                 name: str,
                 action: Optional[str] = None,
                 bypass_busy_wait: Optional[bool] = None,
                 default_host: Optional[str] = None,
                 force_miss: Optional[bool] = None,
                 force_ssl: Optional[bool] = None,
                 geo_headers: Optional[bool] = None,
                 hash_keys: Optional[str] = None,
                 max_stale_age: Optional[float] = None,
                 request_condition: Optional[str] = None,
                 timer_support: Optional[bool] = None,
                 xff: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str action: Allows you to terminate request handling and immediately
               perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely).
        :param bool bypass_busy_wait: Disable collapsed forwarding, so you don't wait
               for other objects to origin.
        :param str default_host: Sets the host header.
        :param bool force_miss: Force a cache miss for the request. If specified,
               can be `true` or `false`.
        :param bool force_ssl: Forces the request to use SSL (Redirects a non-SSL request to SSL).
        :param bool geo_headers: Injects Fastly-Geo-Country, Fastly-Geo-City, and
               Fastly-Geo-Region into the request headers.
        :param str hash_keys: Comma separated list of varnish request object fields
               that should be in the hash key.
        :param float max_stale_age: How old an object is allowed to be to serve
               `stale-if-error` or `stale-while-revalidate`, in seconds.
        :param str request_condition: Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`.
        :param bool timer_support: Injects the X-Timer info into the request for
               viewing origin fetch durations.
        :param str xff: X-Forwarded-For, should be `clear`, `leave`, `append`,
               `append_all`, or `overwrite`. Default `append`.
        """
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if bypass_busy_wait is not None:
            pulumi.set(__self__, "bypass_busy_wait", bypass_busy_wait)
        if default_host is not None:
            pulumi.set(__self__, "default_host", default_host)
        if force_miss is not None:
            pulumi.set(__self__, "force_miss", force_miss)
        if force_ssl is not None:
            pulumi.set(__self__, "force_ssl", force_ssl)
        if geo_headers is not None:
            pulumi.set(__self__, "geo_headers", geo_headers)
        if hash_keys is not None:
            pulumi.set(__self__, "hash_keys", hash_keys)
        if max_stale_age is not None:
            pulumi.set(__self__, "max_stale_age", max_stale_age)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if timer_support is not None:
            pulumi.set(__self__, "timer_support", timer_support)
        if xff is not None:
            pulumi.set(__self__, "xff", xff)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        Allows you to terminate request handling and immediately
        perform an action. When set it can be `lookup` or `pass` (Ignore the cache completely).
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="bypassBusyWait")
    def bypass_busy_wait(self) -> Optional[bool]:
        """
        Disable collapsed forwarding, so you don't wait
        for other objects to origin.
        """
        return pulumi.get(self, "bypass_busy_wait")

    @property
    @pulumi.getter(name="defaultHost")
    def default_host(self) -> Optional[str]:
        """
        Sets the host header.
        """
        return pulumi.get(self, "default_host")

    @property
    @pulumi.getter(name="forceMiss")
    def force_miss(self) -> Optional[bool]:
        """
        Force a cache miss for the request. If specified,
        can be `true` or `false`.
        """
        return pulumi.get(self, "force_miss")

    @property
    @pulumi.getter(name="forceSsl")
    def force_ssl(self) -> Optional[bool]:
        """
        Forces the request to use SSL (Redirects a non-SSL request to SSL).
        """
        return pulumi.get(self, "force_ssl")

    @property
    @pulumi.getter(name="geoHeaders")
    def geo_headers(self) -> Optional[bool]:
        """
        Injects Fastly-Geo-Country, Fastly-Geo-City, and
        Fastly-Geo-Region into the request headers.
        """
        return pulumi.get(self, "geo_headers")

    @property
    @pulumi.getter(name="hashKeys")
    def hash_keys(self) -> Optional[str]:
        """
        Comma separated list of varnish request object fields
        that should be in the hash key.
        """
        return pulumi.get(self, "hash_keys")

    @property
    @pulumi.getter(name="maxStaleAge")
    def max_stale_age(self) -> Optional[float]:
        """
        How old an object is allowed to be to serve
        `stale-if-error` or `stale-while-revalidate`, in seconds.
        """
        return pulumi.get(self, "max_stale_age")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`.
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter(name="timerSupport")
    def timer_support(self) -> Optional[bool]:
        """
        Injects the X-Timer info into the request for
        viewing origin fetch durations.
        """
        return pulumi.get(self, "timer_support")

    @property
    @pulumi.getter
    def xff(self) -> Optional[str]:
        """
        X-Forwarded-For, should be `clear`, `leave`, `append`,
        `append_all`, or `overwrite`. Default `append`.
        """
        return pulumi.get(self, "xff")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1ResponseObject(dict):
    def __init__(__self__, *,
                 name: str,
                 cache_condition: Optional[str] = None,
                 content: Optional[str] = None,
                 content_type: Optional[str] = None,
                 request_condition: Optional[str] = None,
                 response: Optional[str] = None,
                 status: Optional[float] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str cache_condition: Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals,
               see [Fastly's Documentation on Conditionals][fastly-conditionals].
        :param str content: The custom VCL code to upload.
        :param str content_type: The MIME type of the content.
        :param str request_condition: Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`.
        :param str response: The HTTP Response. Default `Ok`.
        :param float status: The HTTP Status Code. Default `200`.
        """
        pulumi.set(__self__, "name", name)
        if cache_condition is not None:
            pulumi.set(__self__, "cache_condition", cache_condition)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if request_condition is not None:
            pulumi.set(__self__, "request_condition", request_condition)
        if response is not None:
            pulumi.set(__self__, "response", response)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="cacheCondition")
    def cache_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to check after we have retrieved an object. If the condition passes then deliver this Request Object instead. This `condition` must be of type `CACHE`. For detailed information about Conditionals,
        see [Fastly's Documentation on Conditionals][fastly-conditionals].
        """
        return pulumi.get(self, "cache_condition")

    @property
    @pulumi.getter
    def content(self) -> Optional[str]:
        """
        The custom VCL code to upload.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[str]:
        """
        The MIME type of the content.
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter(name="requestCondition")
    def request_condition(self) -> Optional[str]:
        """
        Name of already defined `condition` to be checked during the request phase. If the condition passes then this object will be delivered. This `condition` must be of type `REQUEST`.
        """
        return pulumi.get(self, "request_condition")

    @property
    @pulumi.getter
    def response(self) -> Optional[str]:
        """
        The HTTP Response. Default `Ok`.
        """
        return pulumi.get(self, "response")

    @property
    @pulumi.getter
    def status(self) -> Optional[float]:
        """
        The HTTP Status Code. Default `200`.
        """
        return pulumi.get(self, "status")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1S3logging(dict):
    def __init__(__self__, *,
                 bucket_name: str,
                 name: str,
                 domain: Optional[str] = None,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 gzip_level: Optional[float] = None,
                 message_type: Optional[str] = None,
                 path: Optional[str] = None,
                 period: Optional[float] = None,
                 placement: Optional[str] = None,
                 public_key: Optional[str] = None,
                 redundancy: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 s3_access_key: Optional[str] = None,
                 s3_secret_key: Optional[str] = None,
                 server_side_encryption: Optional[str] = None,
                 server_side_encryption_kms_key_id: Optional[str] = None,
                 timestamp_format: Optional[str] = None):
        """
        :param str bucket_name: The name of your Cloud Files container.
        :param str name: A unique name to identify this dictionary.
        :param str domain: The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param float gzip_level: What level of GZIP encoding to have when dumping logs (default 0, no compression).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str path: The path to upload logs to.
        :param float period: How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str public_key: The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        :param str redundancy: The S3 redundancy level. Should be formatted; one of: `standard`, `reduced_redundancy` or null. Default `null`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str s3_access_key: AWS Access Key of an account with the required
               permissions to post logs. It is **strongly** recommended you create a separate
               IAM user with permissions to only operate on this Bucket. This key will be
               not be encrypted. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`.
        :param str s3_secret_key: AWS Secret Key of an account with the required
               permissions to post logs. It is **strongly** recommended you create a separate
               IAM user with permissions to only operate on this Bucket. This secret will be
               not be encrypted. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`.
        :param str server_side_encryption: Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`.
        :param str server_side_encryption_kms_key_id: Server-side KMS Key ID. Must be set if `server_side_encryption` is set to `aws:kms`.
        :param str timestamp_format: The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "name", name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if gzip_level is not None:
            pulumi.set(__self__, "gzip_level", gzip_level)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redundancy is not None:
            pulumi.set(__self__, "redundancy", redundancy)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if s3_access_key is not None:
            pulumi.set(__self__, "s3_access_key", s3_access_key)
        if s3_secret_key is not None:
            pulumi.set(__self__, "s3_secret_key", s3_secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)
        if server_side_encryption_kms_key_id is not None:
            pulumi.set(__self__, "server_side_encryption_kms_key_id", server_side_encryption_kms_key_id)
        if timestamp_format is not None:
            pulumi.set(__self__, "timestamp_format", timestamp_format)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> str:
        """
        The name of your Cloud Files container.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        The domain of the DigitalOcean Spaces endpoint (default "nyc3.digitaloceanspaces.com").
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="gzipLevel")
    def gzip_level(self) -> Optional[float]:
        """
        What level of GZIP encoding to have when dumping logs (default 0, no compression).
        """
        return pulumi.get(self, "gzip_level")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path to upload logs to.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def period(self) -> Optional[float]:
        """
        How frequently log files are finalized so they can be available for reading (in seconds, default 3600).
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        The PGP public key that Fastly will use to encrypt your log files before writing them to disk.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def redundancy(self) -> Optional[str]:
        """
        The S3 redundancy level. Should be formatted; one of: `standard`, `reduced_redundancy` or null. Default `null`.
        """
        return pulumi.get(self, "redundancy")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="s3AccessKey")
    def s3_access_key(self) -> Optional[str]:
        """
        AWS Access Key of an account with the required
        permissions to post logs. It is **strongly** recommended you create a separate
        IAM user with permissions to only operate on this Bucket. This key will be
        not be encrypted. You can provide this key via an environment variable, `FASTLY_S3_ACCESS_KEY`.
        """
        return pulumi.get(self, "s3_access_key")

    @property
    @pulumi.getter(name="s3SecretKey")
    def s3_secret_key(self) -> Optional[str]:
        """
        AWS Secret Key of an account with the required
        permissions to post logs. It is **strongly** recommended you create a separate
        IAM user with permissions to only operate on this Bucket. This secret will be
        not be encrypted. You can provide this secret via an environment variable, `FASTLY_S3_SECRET_KEY`.
        """
        return pulumi.get(self, "s3_secret_key")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[str]:
        """
        Specify what type of server side encryption should be used. Can be either `AES256` or `aws:kms`.
        """
        return pulumi.get(self, "server_side_encryption")

    @property
    @pulumi.getter(name="serverSideEncryptionKmsKeyId")
    def server_side_encryption_kms_key_id(self) -> Optional[str]:
        """
        Server-side KMS Key ID. Must be set if `server_side_encryption` is set to `aws:kms`.
        """
        return pulumi.get(self, "server_side_encryption_kms_key_id")

    @property
    @pulumi.getter(name="timestampFormat")
    def timestamp_format(self) -> Optional[str]:
        """
        The strftime specified timestamp formatting (default `%Y-%m-%dT%H:%M:%S.000`).
        """
        return pulumi.get(self, "timestamp_format")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Snippet(dict):
    def __init__(__self__, *,
                 content: str,
                 name: str,
                 type: str,
                 priority: Optional[float] = None):
        """
        :param str content: The custom VCL code to upload.
        :param str name: A unique name to identify this dictionary.
        :param str type: The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`).
        :param float priority: Priority determines the ordering for multiple snippets. Lower numbers execute first.  Defaults to `100`.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The custom VCL code to upload.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The location in generated VCL where the snippet should be placed (can be one of `init`, `recv`, `hit`, `miss`, `pass`, `fetch`, `error`, `deliver`, `log` or `none`).
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def priority(self) -> Optional[float]:
        """
        Priority determines the ordering for multiple snippets. Lower numbers execute first.  Defaults to `100`.
        """
        return pulumi.get(self, "priority")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Splunk(dict):
    def __init__(__self__, *,
                 name: str,
                 token: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_hostname: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str token: The data authentication token associated with this endpoint.
        :param str url: Your OpenStack auth url.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "token", token)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format.
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        return pulumi.get(self, "tls_hostname")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Sumologic(dict):
    def __init__(__self__, *,
                 name: str,
                 url: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 message_type: Optional[str] = None,
                 placement: Optional[str] = None,
                 response_condition: Optional[str] = None):
        """
        :param str name: A unique name to identify this dictionary.
        :param str url: Your OpenStack auth url.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Your OpenStack auth url.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Syslog(dict):
    def __init__(__self__, *,
                 address: str,
                 name: str,
                 format: Optional[str] = None,
                 format_version: Optional[float] = None,
                 message_type: Optional[str] = None,
                 placement: Optional[str] = None,
                 port: Optional[float] = None,
                 response_condition: Optional[str] = None,
                 tls_ca_cert: Optional[str] = None,
                 tls_client_cert: Optional[str] = None,
                 tls_client_key: Optional[str] = None,
                 tls_hostname: Optional[str] = None,
                 token: Optional[str] = None,
                 use_tls: Optional[bool] = None):
        """
        :param str address: The SFTP address to stream logs to.
        :param str name: A unique name to identify this dictionary.
        :param str format: Apache style log formatting.
        :param float format_version: The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        :param str message_type: How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        :param str placement: Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        :param float port: The port the SFTP service listens on. (Default: `22`).
        :param str response_condition: The name of an existing condition in the configured endpoint, or leave blank to always execute.
        :param str tls_ca_cert: A secure certificate to authenticate the server with. Must be in PEM format.
        :param str tls_client_cert: The client certificate used to make authenticated requests. Must be in PEM format.
        :param str tls_client_key: The client private key used to make authenticated requests. Must be in PEM format.
        :param str tls_hostname: The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        :param str token: The data authentication token associated with this endpoint.
        :param bool use_tls: Whether to use TLS for secure logging. Can be either true or false.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "name", name)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if format_version is not None:
            pulumi.set(__self__, "format_version", format_version)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if response_condition is not None:
            pulumi.set(__self__, "response_condition", response_condition)
        if tls_ca_cert is not None:
            pulumi.set(__self__, "tls_ca_cert", tls_ca_cert)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_hostname is not None:
            pulumi.set(__self__, "tls_hostname", tls_hostname)
        if token is not None:
            pulumi.set(__self__, "token", token)
        if use_tls is not None:
            pulumi.set(__self__, "use_tls", use_tls)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The SFTP address to stream logs to.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        """
        Apache style log formatting.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> Optional[float]:
        """
        The version of the custom logging format used for the configured endpoint. Can be either `1` or `2`. (default: `2`).
        """
        return pulumi.get(self, "format_version")

    @property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[str]:
        """
        How the message should be formatted. One of: classic (default), loggly, logplex or blank.
        """
        return pulumi.get(self, "message_type")

    @property
    @pulumi.getter
    def placement(self) -> Optional[str]:
        """
        Where in the generated VCL the logging call should be placed. Can be `none` or `waf_debug`.
        """
        return pulumi.get(self, "placement")

    @property
    @pulumi.getter
    def port(self) -> Optional[float]:
        """
        The port the SFTP service listens on. (Default: `22`).
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="responseCondition")
    def response_condition(self) -> Optional[str]:
        """
        The name of an existing condition in the configured endpoint, or leave blank to always execute.
        """
        return pulumi.get(self, "response_condition")

    @property
    @pulumi.getter(name="tlsCaCert")
    def tls_ca_cert(self) -> Optional[str]:
        """
        A secure certificate to authenticate the server with. Must be in PEM format.
        """
        return pulumi.get(self, "tls_ca_cert")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[str]:
        """
        The client certificate used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[str]:
        """
        The client private key used to make authenticated requests. Must be in PEM format.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsHostname")
    def tls_hostname(self) -> Optional[str]:
        """
        The hostname used to verify the server's certificate. It can either be the Common Name or a Subject Alternative Name (SAN).
        """
        return pulumi.get(self, "tls_hostname")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        The data authentication token associated with this endpoint.
        """
        return pulumi.get(self, "token")

    @property
    @pulumi.getter(name="useTls")
    def use_tls(self) -> Optional[bool]:
        """
        Whether to use TLS for secure logging. Can be either true or false.
        """
        return pulumi.get(self, "use_tls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Vcl(dict):
    def __init__(__self__, *,
                 content: str,
                 name: str,
                 main: Optional[bool] = None):
        """
        :param str content: The custom VCL code to upload.
        :param str name: A unique name to identify this dictionary.
        :param bool main: If `true`, use this block as the main configuration. If
               `false`, use this block as an includable library. Only a single VCL block can be
               marked as the main block. Default is `false`.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "name", name)
        if main is not None:
            pulumi.set(__self__, "main", main)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        The custom VCL code to upload.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A unique name to identify this dictionary.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def main(self) -> Optional[bool]:
        """
        If `true`, use this block as the main configuration. If
        `false`, use this block as an includable library. Only a single VCL block can be
        marked as the main block. Default is `false`.
        """
        return pulumi.get(self, "main")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Servicev1Waf(dict):
    def __init__(__self__, *,
                 response_object: str,
                 prefetch_condition: Optional[str] = None,
                 waf_id: Optional[str] = None):
        """
        :param str response_object: The name of the response object used by the Web Application Firewall.
        :param str prefetch_condition: The `condition` to determine which requests will be run past your Fastly WAF. This `condition` must be of type `PREFETCH`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals][fastly-conditionals].
        :param str waf_id: The ID of the WAF.
        """
        pulumi.set(__self__, "response_object", response_object)
        if prefetch_condition is not None:
            pulumi.set(__self__, "prefetch_condition", prefetch_condition)
        if waf_id is not None:
            pulumi.set(__self__, "waf_id", waf_id)

    @property
    @pulumi.getter(name="responseObject")
    def response_object(self) -> str:
        """
        The name of the response object used by the Web Application Firewall.
        """
        return pulumi.get(self, "response_object")

    @property
    @pulumi.getter(name="prefetchCondition")
    def prefetch_condition(self) -> Optional[str]:
        """
        The `condition` to determine which requests will be run past your Fastly WAF. This `condition` must be of type `PREFETCH`. For detailed information about Conditionals, see [Fastly's Documentation on Conditionals][fastly-conditionals].
        """
        return pulumi.get(self, "prefetch_condition")

    @property
    @pulumi.getter(name="wafId")
    def waf_id(self) -> Optional[str]:
        """
        The ID of the WAF.
        """
        return pulumi.get(self, "waf_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GetWafRulesRuleResult(dict):
    def __init__(__self__, *,
                 latest_revision_number: float,
                 modsec_rule_id: float,
                 type: str):
        """
        :param float latest_revision_number: The rule's latest revision.
        :param float modsec_rule_id: The rule's modsecurity ID.
        :param str type: The rule's type.
        """
        pulumi.set(__self__, "latest_revision_number", latest_revision_number)
        pulumi.set(__self__, "modsec_rule_id", modsec_rule_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="latestRevisionNumber")
    def latest_revision_number(self) -> float:
        """
        The rule's latest revision.
        """
        return pulumi.get(self, "latest_revision_number")

    @property
    @pulumi.getter(name="modsecRuleId")
    def modsec_rule_id(self) -> float:
        """
        The rule's modsecurity ID.
        """
        return pulumi.get(self, "modsec_rule_id")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The rule's type.
        """
        return pulumi.get(self, "type")


