"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Activate = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [activate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsactivate.html).
 *
 * @experimental
 */
class Activate extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [activate](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsactivate.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'activate';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "CreateForm",
                "PutMemberInfo"
            ],
            "Read": [
                "GetAccountContact",
                "GetContentInfo",
                "GetCosts",
                "GetCredits",
                "GetMemberInfo",
                "GetProgram"
            ]
        };
    }
    /**
     * (experimental) Grants permission to submit an Activate application form.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toCreateForm() {
        return this.to('CreateForm');
    }
    /**
     * (experimental) Grants permission to get the AWS account contact information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetAccountContact() {
        return this.to('GetAccountContact');
    }
    /**
     * (experimental) Grants permission to get Activate tech posts and offer information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetContentInfo() {
        return this.to('GetContentInfo');
    }
    /**
     * (experimental) Grants permission to get the AWS cost information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetCosts() {
        return this.to('GetCosts');
    }
    /**
     * (experimental) Grants permission to get the AWS credit information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetCredits() {
        return this.to('GetCredits');
    }
    /**
     * (experimental) Grants permission to get the Activate member information.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetMemberInfo() {
        return this.to('GetMemberInfo');
    }
    /**
     * (experimental) Grants permission to get an Activate program.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetProgram() {
        return this.to('GetProgram');
    }
    /**
     * (experimental) Grants permission to create or update the Activate member information.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toPutMemberInfo() {
        return this.to('PutMemberInfo');
    }
}
exports.Activate = Activate;
//# sourceMappingURL=data:application/json;base64,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