from typing import Any, Literal, overload

from django.contrib.gis.gdal.raster.base import GDALRasterBase

class GDALBand(GDALRasterBase):
    source: Any
    def __init__(self, source: Any, index: Any) -> None: ...
    @property
    def description(self) -> str: ...
    @property
    def width(self) -> int: ...
    @property
    def height(self) -> int: ...
    @property
    def pixel_count(self) -> int: ...
    def statistics(
        self, refresh: bool = ..., approximate: bool = ...
    ) -> tuple[float, float, float, float] | tuple[None, None, None, None]: ...
    @property
    def min(self) -> float | None: ...
    @property
    def max(self) -> float | None: ...
    @property
    def mean(self) -> float | None: ...
    @property
    def std(self) -> float | None: ...
    @property
    def nodata_value(self) -> float | None: ...
    @nodata_value.setter
    def nodata_value(self, value: float | None) -> None: ...
    @overload
    def datatype(self, as_string: Literal[False] = ...) -> int: ...
    @overload
    def datatype(self, as_string: Literal[True]) -> str: ...
    @overload
    def color_interp(self, as_string: Literal[False] = ...) -> int: ...
    @overload
    def color_interp(self, as_string: Literal[True]) -> str: ...
    def data(
        self,
        data: Any | None = ...,
        offset: Any | None = ...,
        size: Any | None = ...,
        shape: Any | None = ...,
        as_memoryview: bool = ...,
    ) -> Any: ...

class BandList(list[GDALBand]):
    source: Any
    def __init__(self, source: Any) -> None: ...
