from dataclasses import dataclass
from typing import Optional
import re

@dataclass
class CSS:
    alignContent: Optional[str] = None
    alignItems: Optional[str] = None
    alignSelf: Optional[str] = None
    alignmentBaseline: Optional[str] = None
    all: Optional[str] = None
    animation: Optional[str] = None
    animationDelay: Optional[str] = None
    animationDirection: Optional[str] = None
    animationDuration: Optional[str] = None
    animationFillMode: Optional[str] = None
    animationIterationCount: Optional[str] = None
    animationName: Optional[str] = None
    animationPlayState: Optional[str] = None
    animationTimingFunction: Optional[str] = None
    appearance: Optional[str] = None
    ascentOverride: Optional[str] = None
    aspectRatio: Optional[str] = None
    backdropFilter: Optional[str] = None
    backfaceVisibility: Optional[str] = None
    background: Optional[str] = None
    backgroundAttachment: Optional[str] = None
    backgroundBlendMode: Optional[str] = None
    backgroundClip: Optional[str] = None
    backgroundColor: Optional[str] = None
    backgroundImage: Optional[str] = None
    backgroundOrigin: Optional[str] = None
    backgroundPosition: Optional[str] = None
    backgroundPositionX: Optional[str] = None
    backgroundPositionY: Optional[str] = None
    backgroundRepeat: Optional[str] = None
    backgroundRepeatX: Optional[str] = None
    backgroundRepeatY: Optional[str] = None
    backgroundSize: Optional[str] = None
    baselineShift: Optional[str] = None
    blockSize: Optional[str] = None
    border: Optional[str] = None
    borderBlock: Optional[str] = None
    borderBlockColor: Optional[str] = None
    borderBlockEnd: Optional[str] = None
    borderBlockEndColor: Optional[str] = None
    borderBlockEndStyle: Optional[str] = None
    borderBlockEndWidth: Optional[str] = None
    borderBlockStart: Optional[str] = None
    borderBlockStartColor: Optional[str] = None
    borderBlockStartStyle: Optional[str] = None
    borderBlockStartWidth: Optional[str] = None
    borderBlockStyle: Optional[str] = None
    borderBlockWidth: Optional[str] = None
    borderBottom: Optional[str] = None
    borderBottomColor: Optional[str] = None
    borderBottomLeftRadius: Optional[str] = None
    borderBottomRightRadius: Optional[str] = None
    borderBottomStyle: Optional[str] = None
    borderBottomWidth: Optional[str] = None
    borderCollapse: Optional[str] = None
    borderColor: Optional[str] = None
    borderEndEndRadius: Optional[str] = None
    borderEndStartRadius: Optional[str] = None
    borderImage: Optional[str] = None
    borderImageOutset: Optional[str] = None
    borderImageRepeat: Optional[str] = None
    borderImageSlice: Optional[str] = None
    borderImageSource: Optional[str] = None
    borderImageWidth: Optional[str] = None
    borderInline: Optional[str] = None
    borderInlineColor: Optional[str] = None
    borderInlineEnd: Optional[str] = None
    borderInlineEndColor: Optional[str] = None
    borderInlineEndStyle: Optional[str] = None
    borderInlineEndWidth: Optional[str] = None
    borderInlineStart: Optional[str] = None
    borderInlineStartColor: Optional[str] = None
    borderInlineStartStyle: Optional[str] = None
    borderInlineStartWidth: Optional[str] = None
    borderInlineStyle: Optional[str] = None
    borderInlineWidth: Optional[str] = None
    borderLeft: Optional[str] = None
    borderLeftColor: Optional[str] = None
    borderLeftStyle: Optional[str] = None
    borderLeftWidth: Optional[str] = None
    borderRadius: Optional[str] = None
    borderRight: Optional[str] = None
    borderRightColor: Optional[str] = None
    borderRightStyle: Optional[str] = None
    borderRightWidth: Optional[str] = None
    borderSpacing: Optional[str] = None
    borderStartEndRadius: Optional[str] = None
    borderStartStartRadius: Optional[str] = None
    borderStyle: Optional[str] = None
    borderTop: Optional[str] = None
    borderTopColor: Optional[str] = None
    borderTopLeftRadius: Optional[str] = None
    borderTopRightRadius: Optional[str] = None
    borderTopStyle: Optional[str] = None
    borderTopWidth: Optional[str] = None
    borderWidth: Optional[str] = None
    bottom: Optional[str] = None
    boxShadow: Optional[str] = None
    boxSizing: Optional[str] = None
    breakAfter: Optional[str] = None
    breakBefore: Optional[str] = None
    breakInside: Optional[str] = None
    bufferedRendering: Optional[str] = None
    captionSide: Optional[str] = None
    caretColor: Optional[str] = None
    clear: Optional[str] = None
    clip: Optional[str] = None
    clipPath: Optional[str] = None
    clipRule: Optional[str] = None
    color: Optional[str] = None
    colorInterpolation: Optional[str] = None
    colorInterpolationFilters: Optional[str] = None
    colorRendering: Optional[str] = None
    colorScheme: Optional[str] = None
    columnCount: Optional[str] = None
    columnFill: Optional[str] = None
    columnGap: Optional[str] = None
    columnRule: Optional[str] = None
    columnRuleColor: Optional[str] = None
    columnRuleStyle: Optional[str] = None
    columnRuleWidth: Optional[str] = None
    columnSpan: Optional[str] = None
    columnWidth: Optional[str] = None
    columns: Optional[str] = None
    contain: Optional[str] = None
    containIntrinsicSize: Optional[str] = None
    content: Optional[str] = None
    contentVisibility: Optional[str] = None
    counterIncrement: Optional[str] = None
    counterReset: Optional[str] = None
    counterSet: Optional[str] = None
    cursor: Optional[str] = None
    cx: Optional[str] = None
    cy: Optional[str] = None
    d: Optional[str] = None
    descentOverride: Optional[str] = None
    direction: Optional[str] = None
    display: Optional[str] = None
    dominantBaseline: Optional[str] = None
    emptyCells: Optional[str] = None
    fallback: Optional[str] = None
    fill: Optional[str] = None
    fillOpacity: Optional[str] = None
    fillRule: Optional[str] = None
    filter: Optional[str] = None
    flex: Optional[str] = None
    flexBasis: Optional[str] = None
    flexDirection: Optional[str] = None
    flexFlow: Optional[str] = None
    flexGrow: Optional[str] = None
    flexShrink: Optional[str] = None
    flexWrap: Optional[str] = None
    float: Optional[str] = None
    floodColor: Optional[str] = None
    floodOpacity: Optional[str] = None
    font: Optional[str] = None
    fontDisplay: Optional[str] = None
    fontFamily: Optional[str] = None
    fontFeatureSettings: Optional[str] = None
    fontKerning: Optional[str] = None
    fontOpticalSizing: Optional[str] = None
    fontSize: Optional[str] = None
    fontStretch: Optional[str] = None
    fontStyle: Optional[str] = None
    fontVariant: Optional[str] = None
    fontVariantCaps: Optional[str] = None
    fontVariantEastAsian: Optional[str] = None
    fontVariantLigatures: Optional[str] = None
    fontVariantNumeric: Optional[str] = None
    fontVariationSettings: Optional[str] = None
    fontWeight: Optional[str] = None
    forcedColorAdjust: Optional[str] = None
    gap: Optional[str] = None
    grid: Optional[str] = None
    gridArea: Optional[str] = None
    gridAutoColumns: Optional[str] = None
    gridAutoFlow: Optional[str] = None
    gridAutoRows: Optional[str] = None
    gridColumn: Optional[str] = None
    gridColumnEnd: Optional[str] = None
    gridColumnGap: Optional[str] = None
    gridColumnStart: Optional[str] = None
    gridGap: Optional[str] = None
    gridRow: Optional[str] = None
    gridRowEnd: Optional[str] = None
    gridRowGap: Optional[str] = None
    gridRowStart: Optional[str] = None
    gridTemplate: Optional[str] = None
    gridTemplateAreas: Optional[str] = None
    gridTemplateColumns: Optional[str] = None
    gridTemplateRows: Optional[str] = None
    height: Optional[str] = None
    hyphens: Optional[str] = None
    imageOrientation: Optional[str] = None
    imageRendering: Optional[str] = None
    inherits: Optional[str] = None
    initialValue: Optional[str] = None
    inlineSize: Optional[str] = None
    inset: Optional[str] = None
    insetBlock: Optional[str] = None
    insetBlockEnd: Optional[str] = None
    insetBlockStart: Optional[str] = None
    insetInline: Optional[str] = None
    insetInlineEnd: Optional[str] = None
    insetInlineStart: Optional[str] = None
    isolation: Optional[str] = None
    justifyContent: Optional[str] = None
    justifyItems: Optional[str] = None
    justifySelf: Optional[str] = None
    left: Optional[str] = None
    letterSpacing: Optional[str] = None
    lightingColor: Optional[str] = None
    lineBreak: Optional[str] = None
    lineGapOverride: Optional[str] = None
    lineHeight: Optional[str] = None
    listStyle: Optional[str] = None
    listStyleImage: Optional[str] = None
    listStylePosition: Optional[str] = None
    listStyleType: Optional[str] = None
    margin: Optional[str] = None
    marginBlock: Optional[str] = None
    marginBlockEnd: Optional[str] = None
    marginBlockStart: Optional[str] = None
    marginBottom: Optional[str] = None
    marginInline: Optional[str] = None
    marginInlineEnd: Optional[str] = None
    marginInlineStart: Optional[str] = None
    marginLeft: Optional[str] = None
    marginRight: Optional[str] = None
    marginTop: Optional[str] = None
    marker: Optional[str] = None
    markerEnd: Optional[str] = None
    markerMid: Optional[str] = None
    markerStart: Optional[str] = None
    mask: Optional[str] = None
    maskType: Optional[str] = None
    maxBlockSize: Optional[str] = None
    maxHeight: Optional[str] = None
    maxInlineSize: Optional[str] = None
    maxWidth: Optional[str] = None
    maxZoom: Optional[str] = None
    minBlockSize: Optional[str] = None
    minHeight: Optional[str] = None
    minInlineSize: Optional[str] = None
    minWidth: Optional[str] = None
    minZoom: Optional[str] = None
    mixBlendMode: Optional[str] = None
    negative: Optional[str] = None
    objectFit: Optional[str] = None
    objectPosition: Optional[str] = None
    offset: Optional[str] = None
    offsetDistance: Optional[str] = None
    offsetPath: Optional[str] = None
    offsetRotate: Optional[str] = None
    opacity: Optional[str] = None
    order: Optional[str] = None
    orientation: Optional[str] = None
    orphans: Optional[str] = None
    outline: Optional[str] = None
    outlineColor: Optional[str] = None
    outlineOffset: Optional[str] = None
    outlineStyle: Optional[str] = None
    outlineWidth: Optional[str] = None
    overflow: Optional[str] = None
    overflowAnchor: Optional[str] = None
    overflowClipMargin: Optional[str] = None
    overflowWrap: Optional[str] = None
    overflowX: Optional[str] = None
    overflowY: Optional[str] = None
    overscrollBehavior: Optional[str] = None
    overscrollBehaviorBlock: Optional[str] = None
    overscrollBehaviorInline: Optional[str] = None
    overscrollBehaviorX: Optional[str] = None
    overscrollBehaviorY: Optional[str] = None
    pad: Optional[str] = None
    padding: Optional[str] = None
    paddingBlock: Optional[str] = None
    paddingBlockEnd: Optional[str] = None
    paddingBlockStart: Optional[str] = None
    paddingBottom: Optional[str] = None
    paddingInline: Optional[str] = None
    paddingInlineEnd: Optional[str] = None
    paddingInlineStart: Optional[str] = None
    paddingLeft: Optional[str] = None
    paddingRight: Optional[str] = None
    paddingTop: Optional[str] = None
    page: Optional[str] = None
    pageBreakAfter: Optional[str] = None
    pageBreakBefore: Optional[str] = None
    pageBreakInside: Optional[str] = None
    pageOrientation: Optional[str] = None
    paintOrder: Optional[str] = None
    perspective: Optional[str] = None
    perspectiveOrigin: Optional[str] = None
    placeContent: Optional[str] = None
    placeItems: Optional[str] = None
    placeSelf: Optional[str] = None
    pointerEvents: Optional[str] = None
    position: Optional[str] = None
    prefix: Optional[str] = None
    quotes: Optional[str] = None
    r: Optional[str] = None
    range: Optional[str] = None
    resize: Optional[str] = None
    right: Optional[str] = None
    rowGap: Optional[str] = None
    rubyPosition: Optional[str] = None
    rx: Optional[str] = None
    ry: Optional[str] = None
    scrollBehavior: Optional[str] = None
    scrollMargin: Optional[str] = None
    scrollMarginBlock: Optional[str] = None
    scrollMarginBlockEnd: Optional[str] = None
    scrollMarginBlockStart: Optional[str] = None
    scrollMarginBottom: Optional[str] = None
    scrollMarginInline: Optional[str] = None
    scrollMarginInlineEnd: Optional[str] = None
    scrollMarginInlineStart: Optional[str] = None
    scrollMarginLeft: Optional[str] = None
    scrollMarginRight: Optional[str] = None
    scrollMarginTop: Optional[str] = None
    scrollPadding: Optional[str] = None
    scrollPaddingBlock: Optional[str] = None
    scrollPaddingBlockEnd: Optional[str] = None
    scrollPaddingBlockStart: Optional[str] = None
    scrollPaddingBottom: Optional[str] = None
    scrollPaddingInline: Optional[str] = None
    scrollPaddingInlineEnd: Optional[str] = None
    scrollPaddingInlineStart: Optional[str] = None
    scrollPaddingLeft: Optional[str] = None
    scrollPaddingRight: Optional[str] = None
    scrollPaddingTop: Optional[str] = None
    scrollSnapAlign: Optional[str] = None
    scrollSnapStop: Optional[str] = None
    scrollSnapType: Optional[str] = None
    shapeImageThreshold: Optional[str] = None
    shapeMargin: Optional[str] = None
    shapeOutside: Optional[str] = None
    shapeRendering: Optional[str] = None
    size: Optional[str] = None
    sizeAdjust: Optional[str] = None
    speak: Optional[str] = None
    speakAs: Optional[str] = None
    src: Optional[str] = None
    stopColor: Optional[str] = None
    stopOpacity: Optional[str] = None
    stroke: Optional[str] = None
    strokeDasharray: Optional[str] = None
    strokeDashoffset: Optional[str] = None
    strokeLinecap: Optional[str] = None
    strokeLinejoin: Optional[str] = None
    strokeMiterlimit: Optional[str] = None
    strokeOpacity: Optional[str] = None
    strokeWidth: Optional[str] = None
    suffix: Optional[str] = None
    symbols: Optional[str] = None
    syntax: Optional[str] = None
    system: Optional[str] = None
    tabSize: Optional[str] = None
    tableLayout: Optional[str] = None
    textAlign: Optional[str] = None
    textAlignLast: Optional[str] = None
    textAnchor: Optional[str] = None
    textCombineUpright: Optional[str] = None
    textDecoration: Optional[str] = None
    textDecorationColor: Optional[str] = None
    textDecorationLine: Optional[str] = None
    textDecorationSkipInk: Optional[str] = None
    textDecorationStyle: Optional[str] = None
    textDecorationThickness: Optional[str] = None
    textIndent: Optional[str] = None
    textOrientation: Optional[str] = None
    textOverflow: Optional[str] = None
    textRendering: Optional[str] = None
    textShadow: Optional[str] = None
    textSizeAdjust: Optional[str] = None
    textTransform: Optional[str] = None
    textUnderlineOffset: Optional[str] = None
    textUnderlinePosition: Optional[str] = None
    top: Optional[str] = None
    touchAction: Optional[str] = None
    transform: Optional[str] = None
    transformBox: Optional[str] = None
    transformOrigin: Optional[str] = None
    transformStyle: Optional[str] = None
    transition: Optional[str] = None
    transitionDelay: Optional[str] = None
    transitionDuration: Optional[str] = None
    transitionProperty: Optional[str] = None
    transitionTimingFunction: Optional[str] = None
    unicodeBidi: Optional[str] = None
    unicodeRange: Optional[str] = None
    userSelect: Optional[str] = None
    userZoom: Optional[str] = None
    vectorEffect: Optional[str] = None
    verticalAlign: Optional[str] = None
    visibility: Optional[str] = None
    webkitAlignContent: Optional[str] = None
    webkitAlignItems: Optional[str] = None
    webkitAlignSelf: Optional[str] = None
    webkitAnimation: Optional[str] = None
    webkitAnimationDelay: Optional[str] = None
    webkitAnimationDirection: Optional[str] = None
    webkitAnimationDuration: Optional[str] = None
    webkitAnimationFillMode: Optional[str] = None
    webkitAnimationIterationCount: Optional[str] = None
    webkitAnimationName: Optional[str] = None
    webkitAnimationPlayState: Optional[str] = None
    webkitAnimationTimingFunction: Optional[str] = None
    webkitAppRegion: Optional[str] = None
    webkitAppearance: Optional[str] = None
    webkitBackfaceVisibility: Optional[str] = None
    webkitBackgroundClip: Optional[str] = None
    webkitBackgroundOrigin: Optional[str] = None
    webkitBackgroundSize: Optional[str] = None
    webkitBorderAfter: Optional[str] = None
    webkitBorderAfterColor: Optional[str] = None
    webkitBorderAfterStyle: Optional[str] = None
    webkitBorderAfterWidth: Optional[str] = None
    webkitBorderBefore: Optional[str] = None
    webkitBorderBeforeColor: Optional[str] = None
    webkitBorderBeforeStyle: Optional[str] = None
    webkitBorderBeforeWidth: Optional[str] = None
    webkitBorderBottomLeftRadius: Optional[str] = None
    webkitBorderBottomRightRadius: Optional[str] = None
    webkitBorderEnd: Optional[str] = None
    webkitBorderEndColor: Optional[str] = None
    webkitBorderEndStyle: Optional[str] = None
    webkitBorderEndWidth: Optional[str] = None
    webkitBorderHorizontalSpacing: Optional[str] = None
    webkitBorderImage: Optional[str] = None
    webkitBorderRadius: Optional[str] = None
    webkitBorderStart: Optional[str] = None
    webkitBorderStartColor: Optional[str] = None
    webkitBorderStartStyle: Optional[str] = None
    webkitBorderStartWidth: Optional[str] = None
    webkitBorderTopLeftRadius: Optional[str] = None
    webkitBorderTopRightRadius: Optional[str] = None
    webkitBorderVerticalSpacing: Optional[str] = None
    webkitBoxAlign: Optional[str] = None
    webkitBoxDecorationBreak: Optional[str] = None
    webkitBoxDirection: Optional[str] = None
    webkitBoxFlex: Optional[str] = None
    webkitBoxOrdinalGroup: Optional[str] = None
    webkitBoxOrient: Optional[str] = None
    webkitBoxPack: Optional[str] = None
    webkitBoxReflect: Optional[str] = None
    webkitBoxShadow: Optional[str] = None
    webkitBoxSizing: Optional[str] = None
    webkitClipPath: Optional[str] = None
    webkitColumnBreakAfter: Optional[str] = None
    webkitColumnBreakBefore: Optional[str] = None
    webkitColumnBreakInside: Optional[str] = None
    webkitColumnCount: Optional[str] = None
    webkitColumnGap: Optional[str] = None
    webkitColumnRule: Optional[str] = None
    webkitColumnRuleColor: Optional[str] = None
    webkitColumnRuleStyle: Optional[str] = None
    webkitColumnRuleWidth: Optional[str] = None
    webkitColumnSpan: Optional[str] = None
    webkitColumnWidth: Optional[str] = None
    webkitColumns: Optional[str] = None
    webkitFilter: Optional[str] = None
    webkitFlex: Optional[str] = None
    webkitFlexBasis: Optional[str] = None
    webkitFlexDirection: Optional[str] = None
    webkitFlexFlow: Optional[str] = None
    webkitFlexGrow: Optional[str] = None
    webkitFlexShrink: Optional[str] = None
    webkitFlexWrap: Optional[str] = None
    webkitFontFeatureSettings: Optional[str] = None
    webkitFontSmoothing: Optional[str] = None
    webkitHighlight: Optional[str] = None
    webkitHyphenateCharacter: Optional[str] = None
    webkitJustifyContent: Optional[str] = None
    webkitLineBreak: Optional[str] = None
    webkitLineClamp: Optional[str] = None
    webkitLocale: Optional[str] = None
    webkitLogicalHeight: Optional[str] = None
    webkitLogicalWidth: Optional[str] = None
    webkitMarginAfter: Optional[str] = None
    webkitMarginBefore: Optional[str] = None
    webkitMarginEnd: Optional[str] = None
    webkitMarginStart: Optional[str] = None
    webkitMask: Optional[str] = None
    webkitMaskBoxImage: Optional[str] = None
    webkitMaskBoxImageOutset: Optional[str] = None
    webkitMaskBoxImageRepeat: Optional[str] = None
    webkitMaskBoxImageSlice: Optional[str] = None
    webkitMaskBoxImageSource: Optional[str] = None
    webkitMaskBoxImageWidth: Optional[str] = None
    webkitMaskClip: Optional[str] = None
    webkitMaskComposite: Optional[str] = None
    webkitMaskImage: Optional[str] = None
    webkitMaskOrigin: Optional[str] = None
    webkitMaskPosition: Optional[str] = None
    webkitMaskPositionX: Optional[str] = None
    webkitMaskPositionY: Optional[str] = None
    webkitMaskRepeat: Optional[str] = None
    webkitMaskRepeatX: Optional[str] = None
    webkitMaskRepeatY: Optional[str] = None
    webkitMaskSize: Optional[str] = None
    webkitMaxLogicalHeight: Optional[str] = None
    webkitMaxLogicalWidth: Optional[str] = None
    webkitMinLogicalHeight: Optional[str] = None
    webkitMinLogicalWidth: Optional[str] = None
    webkitOpacity: Optional[str] = None
    webkitOrder: Optional[str] = None
    webkitPaddingAfter: Optional[str] = None
    webkitPaddingBefore: Optional[str] = None
    webkitPaddingEnd: Optional[str] = None
    webkitPaddingStart: Optional[str] = None
    webkitPerspective: Optional[str] = None
    webkitPerspectiveOrigin: Optional[str] = None
    webkitPerspectiveOriginX: Optional[str] = None
    webkitPerspectiveOriginY: Optional[str] = None
    webkitPrintColorAdjust: Optional[str] = None
    webkitRtlOrdering: Optional[str] = None
    webkitRubyPosition: Optional[str] = None
    webkitShapeImageThreshold: Optional[str] = None
    webkitShapeMargin: Optional[str] = None
    webkitShapeOutside: Optional[str] = None
    webkitTapHighlightColor: Optional[str] = None
    webkitTextCombine: Optional[str] = None
    webkitTextDecorationsInEffect: Optional[str] = None
    webkitTextEmphasis: Optional[str] = None
    webkitTextEmphasisColor: Optional[str] = None
    webkitTextEmphasisPosition: Optional[str] = None
    webkitTextEmphasisStyle: Optional[str] = None
    webkitTextFillColor: Optional[str] = None
    webkitTextOrientation: Optional[str] = None
    webkitTextSecurity: Optional[str] = None
    webkitTextSizeAdjust: Optional[str] = None
    webkitTextStroke: Optional[str] = None
    webkitTextStrokeColor: Optional[str] = None
    webkitTextStrokeWidth: Optional[str] = None
    webkitTransform: Optional[str] = None
    webkitTransformOrigin: Optional[str] = None
    webkitTransformOriginX: Optional[str] = None
    webkitTransformOriginY: Optional[str] = None
    webkitTransformOriginZ: Optional[str] = None
    webkitTransformStyle: Optional[str] = None
    webkitTransition: Optional[str] = None
    webkitTransitionDelay: Optional[str] = None
    webkitTransitionDuration: Optional[str] = None
    webkitTransitionProperty: Optional[str] = None
    webkitTransitionTimingFunction: Optional[str] = None
    webkitUserDrag: Optional[str] = None
    webkitUserModify: Optional[str] = None
    webkitUserSelect: Optional[str] = None
    webkitWritingMode: Optional[str] = None
    whiteSpace: Optional[str] = None
    widows: Optional[str] = None
    width: Optional[str] = None
    willChange: Optional[str] = None
    wordBreak: Optional[str] = None
    wordSpacing: Optional[str] = None
    wordWrap: Optional[str] = None
    writingMode: Optional[str] = None
    x: Optional[str] = None
    y: Optional[str] = None
    zIndex: Optional[str] = None
    zoom: Optional[str] = None

    def render(self):
        output = {}
        for attr, value in self.__dict__.items():
            if type(value) == str:
                kebab_case = re.sub(r'([a-z0-9]|(?=[A-Z]))([A-Z])', r'\1-\2', attr).lower()
                output[kebab_case] = value
            elif type(value) == CSS:
                output[attr] = value.render()
        return output

@dataclass
class CSSWithLabel(CSS):
    labelStyle: Optional[CSS] = None
