"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChimeVoiceConnector = exports.Protocol = exports.NotificationTargetType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const pstnCustomResources_1 = require("./pstnCustomResources");
const voiceConnectorValidator_1 = require("./voiceConnectorValidator");
var NotificationTargetType;
(function (NotificationTargetType) {
    NotificationTargetType["EVENTBRIDGE"] = "EventBridge";
    NotificationTargetType["SNS"] = "SNS";
    NotificationTargetType["SQS"] = "SQS";
})(NotificationTargetType = exports.NotificationTargetType || (exports.NotificationTargetType = {}));
var Protocol;
(function (Protocol) {
    Protocol["TCP"] = "TCP";
    Protocol["UDP"] = "UDP";
})(Protocol = exports.Protocol || (exports.Protocol = {}));
class ChimeVoiceConnector extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, region, encryption, termination, origination, streaming } = props;
        voiceConnectorValidator_1.voiceConnectorValidator(props);
        const voiceConnectorRequest = new pstnCustomResources_1.PSTNResources(this, 'voiceConnectorRequest', {
            resourceType: 'VoiceConnector',
            uid: uid,
            properties: {
                region: region || cdk.Stack.of(this).region,
                name: name ?? uid,
                encryption: encryption || false,
                termination: termination,
                origination: origination,
                streaming: streaming,
            },
        });
        this.voiceConnectorId =
            voiceConnectorRequest.pstnCustomResource.getAttString('voiceConnectorId');
    }
}
exports.ChimeVoiceConnector = ChimeVoiceConnector;
_a = JSII_RTTI_SYMBOL_1;
ChimeVoiceConnector[_a] = { fqn: "cdk-amazon-chime-resources.ChimeVoiceConnector", version: "0.1.182" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidm9pY2VDb25uZWN0b3IuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcHN0bi92b2ljZUNvbm5lY3Rvci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLG1DQUFtQztBQUNuQywyQ0FBdUM7QUFDdkMsK0RBQXNEO0FBQ3RELHVFQUFvRTtBQUVwRSxJQUFZLHNCQUlYO0FBSkQsV0FBWSxzQkFBc0I7SUFDaEMscURBQTJCLENBQUE7SUFDM0IscUNBQVcsQ0FBQTtJQUNYLHFDQUFXLENBQUE7QUFDYixDQUFDLEVBSlcsc0JBQXNCLEdBQXRCLDhCQUFzQixLQUF0Qiw4QkFBc0IsUUFJakM7QUFFRCxJQUFZLFFBR1g7QUFIRCxXQUFZLFFBQVE7SUFDbEIsdUJBQVcsQ0FBQTtJQUNYLHVCQUFXLENBQUE7QUFDYixDQUFDLEVBSFcsUUFBUSxHQUFSLGdCQUFRLEtBQVIsZ0JBQVEsUUFHbkI7QUE2RUQsTUFBYSxtQkFBb0IsU0FBUSxzQkFBUztJQUdoRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTBCO1FBQ2xFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxHQUFHLEdBQVcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7UUFFN0MsTUFBTSxFQUFFLElBQUksRUFBRSxNQUFNLEVBQUUsVUFBVSxFQUFFLFdBQVcsRUFBRSxXQUFXLEVBQUUsU0FBUyxFQUFFLEdBQ3JFLEtBQUssQ0FBQztRQUVSLGlEQUF1QixDQUFDLEtBQUssQ0FBQyxDQUFDO1FBRS9CLE1BQU0scUJBQXFCLEdBQUcsSUFBSSxtQ0FBYSxDQUM3QyxJQUFJLEVBQ0osdUJBQXVCLEVBQ3ZCO1lBQ0UsWUFBWSxFQUFFLGdCQUFnQjtZQUM5QixHQUFHLEVBQUUsR0FBRztZQUNSLFVBQVUsRUFBRTtnQkFDVixNQUFNLEVBQUUsTUFBTSxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU07Z0JBQzNDLElBQUksRUFBRSxJQUFJLElBQUksR0FBRztnQkFDakIsVUFBVSxFQUFFLFVBQVUsSUFBSSxLQUFLO2dCQUMvQixXQUFXLEVBQUUsV0FBVztnQkFDeEIsV0FBVyxFQUFFLFdBQVc7Z0JBQ3hCLFNBQVMsRUFBRSxTQUFTO2FBQ3JCO1NBQ0YsQ0FDRixDQUFDO1FBRUYsSUFBSSxDQUFDLGdCQUFnQjtZQUNuQixxQkFBcUIsQ0FBQyxrQkFBa0IsQ0FBQyxZQUFZLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUM5RSxDQUFDOztBQWhDSCxrREFpQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBQU1ROUmVzb3VyY2VzIH0gZnJvbSAnLi9wc3RuQ3VzdG9tUmVzb3VyY2VzJztcbmltcG9ydCB7IHZvaWNlQ29ubmVjdG9yVmFsaWRhdG9yIH0gZnJvbSAnLi92b2ljZUNvbm5lY3RvclZhbGlkYXRvcic7XG5cbmV4cG9ydCBlbnVtIE5vdGlmaWNhdGlvblRhcmdldFR5cGUge1xuICBFVkVOVEJSSURHRSA9ICdFdmVudEJyaWRnZScsXG4gIFNOUyA9ICdTTlMnLFxuICBTUVMgPSAnU1FTJyxcbn1cblxuZXhwb3J0IGVudW0gUHJvdG9jb2wge1xuICBUQ1AgPSAnVENQJyxcbiAgVURQID0gJ1VEUCcsXG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgVGVybWluYXRpb24ge1xuICAvKipcbiAgICogQ2FsbGluZyBSZWdpb25zIGZvciBWb2ljZUNvbm5lY3RvciAob3B0aW9uYWwpXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gWydVUyddXG4gICAqL1xuICByZWFkb25seSBjYWxsaW5nUmVnaW9uczogQXJyYXk8c3RyaW5nPjtcbiAgLyoqXG4gICAqIENQUyBMaW1pdFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIDFcbiAgICovXG4gIHJlYWRvbmx5IGNwcz86IG51bWJlcjtcbiAgLyoqXG4gICAqIHRlcm1pbmF0aW9uIElQIGZvciBWb2ljZUNvbm5lY3RvciAob3B0aW9uYWwpXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcmVhZG9ubHkgdGVybWluYXRpb25DaWRyczogQXJyYXk8c3RyaW5nPjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBSb3V0ZXMge1xuICByZWFkb25seSBob3N0OiBzdHJpbmc7XG4gIHJlYWRvbmx5IHBvcnQ6IG51bWJlcjtcbiAgcmVhZG9ubHkgcHJvdG9jb2w6IFByb3RvY29sO1xuICByZWFkb25seSBwcmlvcml0eTogbnVtYmVyO1xuICByZWFkb25seSB3ZWlnaHQ6IG51bWJlcjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBTdHJlYW1pbmcge1xuICByZWFkb25seSBlbmFibGVkOiBib29sZWFuO1xuICAvKipcbiAgICogU3RyZWFtaW5nIGRhdGEgcmV0ZW50aW9uIGZvciBWb2ljZUNvbm5lY3RvclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIDBcbiAgICovXG4gIHJlYWRvbmx5IGRhdGFSZXRlbnRpb246IG51bWJlcjtcblxuICAvKipcbiAgICogU3RyZWFtaW5nIGRhdGEgcmV0ZW50aW9uIGZvciBWb2ljZUNvbm5lY3RvclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIDBcbiAgICovXG4gIHJlYWRvbmx5IG5vdGlmaWNhdGlvblRhcmdldHM6IEFycmF5PE5vdGlmaWNhdGlvblRhcmdldFR5cGU+O1xufVxuLyoqXG4gKiBQcm9wcyBmb3IgYFNpcE1lZGlhQXBwbGljYXRpb25gLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFZvaWNlQ29ubmVjdG9yUHJvcHMge1xuICAvKipcbiAgICogcmVnaW9uIGZvciBTaXBNZWRpYUFwcGxpY2F0aW9uKHJlcXVpcmVkKSAtIE11c3QgdXMtZWFzdC0xIG9yIHVzLXdlc3QtMiBhbmQgaW4gdGhlIHNhbWUgcmVnaW9uIGFzIHRoZSBTaXBNZWRpYUFwcGxpY2F0aW9uIExhbWJkYSBoYW5kbGVyXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gc2FtZSByZWdpb24gYXMgc3RhY2sgZGVwbG95bWVudFxuICAgKi9cbiAgcmVhZG9ubHkgcmVnaW9uPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBuYW1lIGZvciBWb2ljZUNvbm5lY3RvclxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHVuaXF1ZSBJRCBmb3IgcmVzb3VyY2VcbiAgICovXG4gIHJlYWRvbmx5IG5hbWU/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEVuY3J5cHRpb24gYm9vbGVhbiBmb3IgVm9pY2VDb25uZWN0b3JcbiAgICpcbiAgICogQGRlZmF1bHQgLSBGYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgZW5jcnlwdGlvbj86IGJvb2xlYW47XG5cbiAgcmVhZG9ubHkgdGVybWluYXRpb24/OiBUZXJtaW5hdGlvbjtcbiAgcmVhZG9ubHkgb3JpZ2luYXRpb24/OiBBcnJheTxSb3V0ZXM+O1xuICByZWFkb25seSBzdHJlYW1pbmc/OiBTdHJlYW1pbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBDaGltZVZvaWNlQ29ubmVjdG9yIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IHZvaWNlQ29ubmVjdG9ySWQ6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogVm9pY2VDb25uZWN0b3JQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCB1aWQ6IHN0cmluZyA9IGNkay5OYW1lcy51bmlxdWVJZCh0aGlzKTtcblxuICAgIGNvbnN0IHsgbmFtZSwgcmVnaW9uLCBlbmNyeXB0aW9uLCB0ZXJtaW5hdGlvbiwgb3JpZ2luYXRpb24sIHN0cmVhbWluZyB9ID1cbiAgICAgIHByb3BzO1xuXG4gICAgdm9pY2VDb25uZWN0b3JWYWxpZGF0b3IocHJvcHMpO1xuXG4gICAgY29uc3Qgdm9pY2VDb25uZWN0b3JSZXF1ZXN0ID0gbmV3IFBTVE5SZXNvdXJjZXMoXG4gICAgICB0aGlzLFxuICAgICAgJ3ZvaWNlQ29ubmVjdG9yUmVxdWVzdCcsXG4gICAgICB7XG4gICAgICAgIHJlc291cmNlVHlwZTogJ1ZvaWNlQ29ubmVjdG9yJyxcbiAgICAgICAgdWlkOiB1aWQsXG4gICAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgICByZWdpb246IHJlZ2lvbiB8fCBjZGsuU3RhY2sub2YodGhpcykucmVnaW9uLFxuICAgICAgICAgIG5hbWU6IG5hbWUgPz8gdWlkLFxuICAgICAgICAgIGVuY3J5cHRpb246IGVuY3J5cHRpb24gfHwgZmFsc2UsXG4gICAgICAgICAgdGVybWluYXRpb246IHRlcm1pbmF0aW9uLFxuICAgICAgICAgIG9yaWdpbmF0aW9uOiBvcmlnaW5hdGlvbixcbiAgICAgICAgICBzdHJlYW1pbmc6IHN0cmVhbWluZyxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgKTtcblxuICAgIHRoaXMudm9pY2VDb25uZWN0b3JJZCA9XG4gICAgICB2b2ljZUNvbm5lY3RvclJlcXVlc3QucHN0bkN1c3RvbVJlc291cmNlLmdldEF0dFN0cmluZygndm9pY2VDb25uZWN0b3JJZCcpO1xuICB9XG59XG4iXX0=