# mypy-boto3-kms

[![PyPI - mypy-boto3-kms](https://img.shields.io/pypi/v/mypy-boto3-kms.svg?color=blue)](https://pypi.org/project/mypy-boto3-kms)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-kms.svg?color=blue)](https://pypi.org/project/mypy-boto3-kms)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-kms](#mypy-boto3-kms)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)

Type annotations for
[boto3.KMS 1.13.26](https://boto3.amazonaws.com/v1/documentation/api/1.13.26/reference/services/kms.html#KMS) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `KMS` service.

```bash
python -m pip install boto3-stubs[kms]
```

Use `boto3` with `mypy_boto3_kms` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_kms import KMSClient

# Now mypy can check if your code is valid.
client: KMSClient = boto3.client("kms")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: KMSClient = session.client("kms")



# Annotated paginators are included as well

import mypy_boto3_kms.paginator as kms_paginators

list_aliases_paginator: kms_paginators.ListAliasesPaginator = client.get_paginator("list_aliases")
list_grants_paginator: kms_paginators.ListGrantsPaginator = client.get_paginator("list_grants")
list_key_policies_paginator: kms_paginators.ListKeyPoliciesPaginator = client.get_paginator("list_key_policies")
list_keys_paginator: kms_paginators.ListKeysPaginator = client.get_paginator("list_keys")
```

## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_kms` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python
import boto3

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("kms")

session_client = boto3.Session().client("kms")
```