from src import *
# Initialize environment (explicit wiring)
env = DecoderEnvironment()
rows = get_latest_from_table('log_payloads')
none_payloads = {}
for row in rows:
    event = row["event"]
    discriminator = row["discriminator"]
    
    result = env.decode(
        row["b64"],
        signature=row["signature"],
        program_id=row["program_id"],
    )
    
    if result == None:
        
        if discriminator not in none_payloads:
            none_payloads[discriminator] = []
        if event not in none_payloads[discriminator]:
            none_payloads[discriminator].append(event) 
            safe_dump_to_json(data=none_payloads,file_path='none_payloads.json')
    else:
        print(event,discriminator )
        print(result)
print(none_payloads)
##for log in logs:
##    b64 = log.get('b64')
##    event_name = log.get("event")
##    signature = log.get('signature')
##    program_id = log.get('program_id')
##    result = env.decode(b64, signature=signature, program_id=program_id)
##    print(result)
