from .imports import *
# ============================================================================
# DECODERS
# ============================================================================

def read_pubkey(raw: bytes, offset: int) -> tuple[str, int]:
    """Read 32-byte pubkey, return (base58_str, new_offset)"""
    pk = base58.b58encode(raw[offset:offset+32]).decode()
    return pk, offset + 32


def read_u64(raw: bytes, offset: int) -> tuple[int, int]:
    val, = struct.unpack_from("<Q", raw, offset)
    return val, offset + 8


def read_i64(raw: bytes, offset: int) -> tuple[int, int]:
    val, = struct.unpack_from("<q", raw, offset)
    return val, offset + 8


def read_bool(raw: bytes, offset: int) -> tuple[bool, int]:
    val, = struct.unpack_from("<?", raw, offset)
    return val, offset + 1


def read_string(raw: bytes, offset: int) -> tuple[str, int]:
    ln, = struct.unpack_from("<I", raw, offset)
    offset += 4
    val = raw[offset:offset+ln].decode("utf-8")
    return val, offset + ln


def is_null_pubkey(raw: bytes, offset: int) -> bool:
    return raw[offset:offset+32] == bytes(32)
