# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_dialog_system.ipynb (unless otherwise specified).

__all__ = ['DialogSystem']

# Cell
from .settings import *
import logging
from collections import defaultdict

logging.basicConfig(
    #filename='example.log',
    format='%(asctime)s %(levelname)s:%(message)s',
    level=logging.ERROR,
    datefmt='%I:%M:%S'
)

logging.debug(" Debug Log Active")
logging.info("Hello! Welcome to our automated dialog system!")
logging.warning(' Warning Log Active')
#logging.error(' Error Log Active ')

# Cell
class DialogSystem:
    ''' The DialogSystem class implements the main methods
    defined in settings module
    '''
    def __init__(
        self,
        context_data_file=None,
        faq_data_file=None,
        configs_faq=None,
        download_models=True
    ):
        run_shell_installs()
        self.data = {'context': defaultdict(str), 'faq': defaultdict(str)}
        self.download = download_models
        load_and_prepare_data(
            context_data_file=context_data_file,
            faq_data_file=faq_data_file,
            configs_faq=configs_faq,
            data=self.data
        )
        self.qa_models = load_qa_models(
            config_tfidf=self.data['faq']['config'], download=self.download
        )

    def question_answer(self):
        ''' Gets answer from a question
        '''
        question, responses = question_response(
            data=self.data,
            qa_models=self.qa_models,
            num_returned_values_per_squad_model=1
        )
        print('\n\n' + responses)

    def new_q_a(self):
        '''Stores new question answer
        '''
        new_question_answer(self.data, self.qa_models)

    def new_context(self):
        '''Stores a new context
        '''
        new_context(self.data)