# Generated by Django 3.1.3 on 2020-12-03 19:51
import uuid
from django.db import migrations


def generate_payment_uuid(apps, schema_editor):
    PaymentModel = apps.get_model('vendor', 'Payment')
    for payment in PaymentModel.objects.all():
        payment.uuid = uuid.uuid4()
        payment.save(update_fields=['uuid'])
    
def generate_receipt_uuid(apps, schema_editor):
    ReceiptModel = apps.get_model('vendor', 'Receipt')
    for receipt in ReceiptModel.objects.all():
        receipt.uuid = uuid.uuid4()
        receipt.save(update_fields=['uuid'])


class Migration(migrations.Migration):

    dependencies = [
        ('vendor', '0014_term_types_update_value'),
    ]

    operations = [
        migrations.RunPython(generate_payment_uuid, reverse_code=migrations.RunPython.noop),
        migrations.RunPython(generate_receipt_uuid, reverse_code=migrations.RunPython.noop),
    ]
