"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TriggerFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const lambda = require("@aws-cdk/aws-lambda");
const _1 = require(".");
/**
 * Invokes an AWS Lambda function during deployment.
 */
class TriggerFunction extends lambda.Function {
    constructor(scope, id, props) {
        super(scope, id, props);
        jsiiDeprecationWarnings._aws_cdk_triggers_TriggerFunctionProps(props);
        this.trigger = new _1.Trigger(this, 'Trigger', {
            ...props,
            handler: this,
        });
    }
    executeAfter(...scopes) {
        this.trigger.executeAfter(...scopes);
    }
    executeBefore(...scopes) {
        this.trigger.executeBefore(...scopes);
    }
}
exports.TriggerFunction = TriggerFunction;
_a = JSII_RTTI_SYMBOL_1;
TriggerFunction[_a] = { fqn: "@aws-cdk/triggers.TriggerFunction", version: "1.150.0" };
//# sourceMappingURL=data:application/json;base64,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