## 使い方
```python
from tcgshuffle import evaluate
evaluate(評価したいシャッフル関数, デッキ枚数)
```

## 出力
- position_prob_map: 元々i番目にあったカードが、シャッフル後デッキ内のどこに移動した頻度
- neighbor_prob_map: 元々i番目にあったカードとj番目にあったカードについて、シャッフル後にそれらが隣り合っていた頻度
- position_badness: position_prob_mapの頻度が、理想頻度(1 / デッキ枚数)とどの程度乖離しているか
- neighbor_badness: neighbor_prob_map、理想頻度(1 / (デッキ枚数 - 1))とどの程度乖離しているか
- total_position_badness: 総合評価として、理想頻度を1とした場合にposition_badnessの偏りがどの程度大きいかを示す（もっとも悪い数字をデッキ枚数分取り出し平均したもの）
- total_neighbor_badness: 総合評価として、理想頻度を1とした場合にneighbor_badnessの偏りがどの程度大きいかを示す（もっとも悪い数字をデッキ枚数分取り出し平均したもの）

## シャッフル関数定義方法

説明準備中...

### basic example 1
1. ディールシャッフル（6つの束）
2. ファローシャッフル（5回連続）
3. ヒンドゥーシャッフル（4回シャカシャカする作業を1回）
4. ファローシャッフル（5回連続）
5. ヒンドゥーシャッフル（4回シャカシャカする作業を1回）
6. カット（3分割）
```python
from tcgshuffle import Deck, Shuffler, evaluate
def shuffle(d: Deck, s: Shuffler) -> Deck:
    s.deal(d, [6])
    s.fallow(d, 5, 0.1, 0.1)
    s.over_hand(d, [4], 0.1)
    s.fallow(d, 5, 0.1, 0.1)
    s.over_hand(d, [4], 0.1)
    s.cut(d, 3, 0.1)
    return d

position_prob_map, neighbor_prob_map, position_badness, neighbor_badness, total_position_badness, total_neighbor_badness\
    = evaluate(shuffle, 60)
```
total_position_badness = 0.21536666666666665
total_neighbor_badness = 0.21140000000000003

### basic example 2
1. ヒンドゥーシャッフル（5回シャカシャカ、4回シャカシャカ、3回シャカシャカ、・・・と21回行う）
```python
from tcgshuffle import Deck, Shuffler, evaluate
def shuffle(d: Deck, s: Shuffler):
    s.hindu(d, [5, 4, 3, 4, 5, 4, 3, 4, 5, 4, 3, 4, 5, 4, 3, 4, 5, 4, 3, 4, 5], 0.4)
    return d
position_prob_map, neighbor_prob_map, position_badness, neighbor_badness, total_position_badness, total_neighbor_badness\
    = evaluate(shuffle, 60)
```
total_position_badness = 0.4182666666666666
total_neighbor_badness = 13.671499999999998

### advanced example 1
1. ２束に分ける
2. それぞれの束をファローシャッフル（8回連続）
3. ２束を合わせる（上に載せるだけ）
```python
from tcgshuffle import Deck, Shuffler, evaluate
def shuffle(d: Deck, s: Shuffler):
    ds = s.split(d, 2, 0.1)
    s.super_fallow(ds, 8, 0.1, 0.1)
    d = s.merge(ds)
    return d
position_prob_map, neighbor_prob_map, position_badness, neighbor_badness, total_position_badness, total_neighbor_badness\
    = evaluate(shuffle, 60)
```
total_position_badness = 1.2804000000000002
total_neighbor_badness = 1.3671999999999995

### advanced example 2
1. ディールシャッフル（6つの束）
2. 以下を3回繰り返す
   1. 束を2つに分ける（元の束 -> [A, B]）
   2. 各束をさらに3つに分ける（A -> [A1, A2, A3], B -> [B1, B2, B3]）
   3. A1とB1、A2とB2、A3とB3をそれぞれ合わせる
   4. A1+B1、A2+B2、A3+B3にそれぞれ、ファローシャッフル（3回連続）
   5. A1+B1、A2+B2、A3+B3を合わせる
   6. ヒンドゥーシャッフル（4回シャカシャカする作業を3回実施）
```python
from tcgshuffle import Deck, Shuffler, evaluate
def shuffle(d: Deck, s: Shuffler):
    s.deal(d, [6])
    for i in range(3):
        sp2 = s.split(d, 2)
        sp6 = s.super_split(sp2, 3)
        pile1 = s.merge([sp6[0], sp6[3]])
        pile2 = s.merge([sp6[1], sp6[4]])
        pile3 = s.merge([sp6[2], sp6[5]])
        s.fallow(pile1, 3, 0.1, 0.1)
        s.fallow(pile2, 3, 0.1, 0.1)
        s.fallow(pile3, 3, 0.1, 0.1)
        d = s.merge([pile1, pile2, pile3])
        s.hindu(d, [4, 4, 4], 0.1)
    return d
position_prob_map, neighbor_prob_map, position_badness, neighbor_badness, total_position_badness, total_neighbor_badness\
    = evaluate(shuffle, 60)
```
total_position_badness = 0.23553333333333332
total_neighbor_badness = 0.2083